/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.scripting.xslt;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.lucene.util.ResourceLoader;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.common.util.XMLErrorLogger;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.util.SystemIdResolver;
import org.apache.solr.util.TimeOut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TransformerProvider {
    private String lastFilename;
    private Templates lastTemplates = null;
    private TimeOut cacheExpiresTimeout;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final XMLErrorLogger xmllog = new XMLErrorLogger(log);
    public static TransformerProvider instance = new TransformerProvider();

    private TransformerProvider() {
        log.warn("The TransformerProvider's simplistic XSLT caching mechanism is not appropriate for high load scenarios, unless a single XSLT transform is used and xsltCacheLifetimeSeconds is set to a sufficiently high value.");
    }

    static Transformer getTransformer(SolrQueryRequest request, String xslt, int xsltCacheLifetimeSeconds) throws IOException {
        Map<Object, Object> ctx = request.getContext();
        Transformer result = (Transformer)ctx.get("xsltwriter.transformer");
        if (result == null) {
            SolrConfig solrConfig = request.getCore().getSolrConfig();
            result = instance.getTransformer(solrConfig, xslt, xsltCacheLifetimeSeconds);
            result.setErrorListener(xmllog);
            ctx.put("xsltwriter.transformer", result);
        }
        return result;
    }

    public synchronized Transformer getTransformer(SolrConfig solrConfig, String filename, int cacheLifetimeSeconds) throws IOException {
        if (this.lastTemplates != null && filename.equals(this.lastFilename) && this.cacheExpiresTimeout != null && !this.cacheExpiresTimeout.hasTimedOut()) {
            if (log.isDebugEnabled()) {
                log.debug("Using cached Templates:{}", (Object)filename);
            }
        } else {
            this.lastTemplates = this.getTemplates(solrConfig.getResourceLoader(), filename, cacheLifetimeSeconds);
        }
        Transformer result = null;
        try {
            result = this.lastTemplates.newTransformer();
        }
        catch (TransformerConfigurationException tce) {
            log.error(this.getClass().getName(), (Object)"getTransformer", (Object)tce);
            throw new IOException("newTransformer fails ( " + this.lastFilename + ")", tce);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Templates getTemplates(ResourceLoader loader, String filename, int cacheLifetimeSeconds) throws IOException {
        Templates result = null;
        this.lastFilename = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug("compiling XSLT templates:{}", (Object)filename);
            }
            String fn = "xslt/" + filename;
            TransformerFactory tFactory = TransformerFactory.newInstance();
            tFactory.setURIResolver(new SystemIdResolver(loader).asURIResolver());
            tFactory.setErrorListener(xmllog);
            StreamSource src = new StreamSource(loader.openResource(fn), SystemIdResolver.createSystemIdFromResourceName(fn));
            try {
                result = tFactory.newTemplates(src);
            }
            finally {
                IOUtils.closeQuietly(src.getInputStream());
            }
        }
        catch (Exception e) {
            log.error(this.getClass().getName(), (Object)"newTemplates", (Object)e);
            throw new IOException("Unable to initialize Templates '" + filename + "'", e);
        }
        this.lastFilename = filename;
        this.lastTemplates = result;
        this.cacheExpiresTimeout = new TimeOut(cacheLifetimeSeconds, TimeUnit.SECONDS, TimeSource.NANO_TIME);
        return result;
    }
}

