/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.handler.component.MergeStrategy;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.QueryCommand;
import org.apache.solr.search.RankQuery;
import org.apache.solr.search.SyntaxError;

public class ExportQParserPlugin
extends QParserPlugin {
    public static final String NAME = "xport";

    @Override
    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest request) {
        return new ExportQParser(qstr, localParams, params, request);
    }

    private static class ExportCollector
    extends TopDocsCollector<ScoreDoc> {
        private FixedBitSet[] sets;

        public ExportCollector(FixedBitSet[] sets) {
            super(null);
            this.sets = sets;
        }

        @Override
        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            FixedBitSet set;
            this.sets[context.ord] = set = new FixedBitSet(context.reader().maxDoc());
            return new LeafCollector(){

                @Override
                public void setScorer(Scorable scorer) throws IOException {
                }

                @Override
                public void collect(int docId) throws IOException {
                    ++totalHits;
                    set.set(docId);
                }
            };
        }

        private ScoreDoc[] getScoreDocs(int howMany) {
            ScoreDoc[] docs = new ScoreDoc[Math.min(this.totalHits, howMany)];
            for (int i = 0; i < docs.length; ++i) {
                docs[i] = new ScoreDoc(i, 0.0f);
            }
            return docs;
        }

        @Override
        public TopDocs topDocs(int start, int howMany) {
            assert (this.sets != null);
            SolrRequestInfo info = SolrRequestInfo.getRequestInfo();
            SolrQueryRequest req = null;
            if (info != null && (req = info.getReq()) != null) {
                Map<Object, Object> context = req.getContext();
                context.put("export", this.sets);
                context.put("totalHits", this.totalHits);
            }
            ScoreDoc[] scoreDocs = this.getScoreDocs(howMany);
            assert (scoreDocs.length <= this.totalHits);
            return new TopDocs(new TotalHits(this.totalHits, this.totalHitsRelation), scoreDocs);
        }

        @Override
        public ScoreMode scoreMode() {
            return ScoreMode.COMPLETE_NO_SCORES;
        }
    }

    public static class ExportQuery
    extends RankQuery {
        private Query mainQuery;
        private Object id;

        public RankQuery clone() {
            ExportQuery clone = new ExportQuery();
            clone.id = this.id;
            return clone;
        }

        @Override
        public RankQuery wrap(Query mainQuery) {
            this.mainQuery = mainQuery;
            return this;
        }

        @Override
        public MergeStrategy getMergeStrategy() {
            return null;
        }

        @Override
        public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
            return this.mainQuery.createWeight(searcher, scoreMode, boost);
        }

        @Override
        public Query rewrite(IndexReader reader) throws IOException {
            Query q = this.mainQuery.rewrite(reader);
            if (q.equals(this.mainQuery)) {
                return super.rewrite(reader);
            }
            return this.clone().wrap(q);
        }

        @Override
        public TopDocsCollector<ScoreDoc> getTopDocsCollector(int len, QueryCommand cmd, IndexSearcher searcher) throws IOException {
            int leafCount = searcher.getTopReaderContext().leaves().size();
            FixedBitSet[] sets = new FixedBitSet[leafCount];
            return new ExportCollector(sets);
        }

        @Override
        public int hashCode() {
            return this.classHash() + 31 * this.id.hashCode() + 31 * Objects.hash(this.mainQuery);
        }

        @Override
        public boolean equals(Object other) {
            return this.sameClassAs(other) && this.equalsTo((ExportQuery)this.getClass().cast(other));
        }

        private boolean equalsTo(ExportQuery other) {
            return Objects.equals(this.id, other.id) && Objects.equals(this.mainQuery, other.mainQuery);
        }

        @Override
        public String toString(String s) {
            return s;
        }

        @Override
        public void visit(QueryVisitor visitor) {
            visitor.visitLeaf(this);
        }

        public ExportQuery() {
        }

        public ExportQuery(SolrParams localParams, SolrParams params, SolrQueryRequest request) throws IOException {
            this.id = new Object();
        }
    }

    public static class ExportQParser
    extends QParser {
        public ExportQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest request) {
            super(qstr, localParams, params, request);
        }

        @Override
        public Query parse() throws SyntaxError {
            try {
                return new ExportQuery(this.localParams, this.params, this.req);
            }
            catch (Exception e) {
                throw new SyntaxError(e.getMessage(), e);
            }
        }
    }
}

