/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.ValueSourceScorer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.apache.solr.common.SolrException;
import org.apache.solr.search.DelegatingCollector;
import org.apache.solr.search.ExtendedQueryBase;
import org.apache.solr.search.PostFilter;
import org.apache.solr.search.function.ValueSourceRangeFilter;

public class FunctionRangeQuery
extends ExtendedQueryBase
implements PostFilter {
    final ValueSourceRangeFilter rangeFilt;

    public FunctionRangeQuery(ValueSourceRangeFilter filter) {
        this.rangeFilt = filter;
        super.setCost(100);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return this.rangeFilt.createWeight(searcher, scoreMode, boost);
    }

    @Override
    public DelegatingCollector getFilterCollector(IndexSearcher searcher) {
        Map<Object, Object> fcontext = ValueSource.newContext(searcher);
        Weight weight = null;
        try {
            weight = this.rangeFilt.createWeight(searcher, ScoreMode.COMPLETE, 1.0f);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        return new FunctionRangeCollector(fcontext, weight);
    }

    @Override
    public String toString(String field) {
        return "FunctionRangeQuery(" + field + ")";
    }

    @Override
    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf(this);
    }

    @Override
    public boolean equals(Object obj) {
        return this.sameClassAs(obj) && Objects.equals(this.rangeFilt, ((FunctionRangeQuery)obj).rangeFilt);
    }

    @Override
    public int hashCode() {
        return 31 * this.classHash() + this.rangeFilt.hashCode();
    }

    class FunctionRangeCollector
    extends DelegatingCollector {
        final Map<Object, Object> fcontext;
        final Weight weight;
        ValueSourceScorer valueSourceScorer;
        int maxdoc;

        public FunctionRangeCollector(Map<Object, Object> fcontext, Weight weight) {
            this.fcontext = fcontext;
            this.weight = weight;
        }

        @Override
        public void collect(int doc) throws IOException {
            assert (doc < this.maxdoc);
            if (this.valueSourceScorer.matches(doc)) {
                this.leafDelegate.collect(doc);
            }
        }

        @Override
        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            super.doSetNextReader(context);
            this.maxdoc = context.reader().maxDoc();
            FunctionValues dv = FunctionRangeQuery.this.rangeFilt.getValueSource().getValues(this.fcontext, context);
            this.valueSourceScorer = dv.getRangeScorer(this.weight, context, FunctionRangeQuery.this.rangeFilt.getLowerVal(), FunctionRangeQuery.this.rangeFilt.getUpperVal(), FunctionRangeQuery.this.rangeFilt.isIncludeLower(), FunctionRangeQuery.this.rangeFilt.isIncludeUpper());
        }
    }
}

