/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrException;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.DocSetQuery;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.WrappedQuery;

public class QueryUtils {
    public static boolean isNegative(Query q) {
        if (!(q instanceof BooleanQuery)) {
            return false;
        }
        BooleanQuery bq = (BooleanQuery)q;
        List<BooleanClause> clauses = bq.clauses();
        if (clauses.size() == 0) {
            return false;
        }
        for (BooleanClause clause : clauses) {
            if (clause.isProhibited()) continue;
            return false;
        }
        return true;
    }

    public static boolean isConstantScoreQuery(Query q) {
        while (true) {
            if (q instanceof BoostQuery) {
                q = ((BoostQuery)q).getQuery();
                continue;
            }
            if (!(q instanceof WrappedQuery)) break;
            q = ((WrappedQuery)q).getWrappedQuery();
        }
        if (q instanceof ConstantScoreQuery) {
            return true;
        }
        if (q instanceof MatchAllDocsQuery) {
            return true;
        }
        if (q instanceof MatchNoDocsQuery) {
            return true;
        }
        if (q instanceof DocSetQuery) {
            return true;
        }
        if (q instanceof BooleanQuery) {
            return ((BooleanQuery)q).clauses().stream().noneMatch(BooleanClause::isScoring);
        }
        return false;
    }

    public static Query getAbs(Query q) {
        if (q instanceof BoostQuery) {
            BoostQuery bq = (BoostQuery)q;
            Query subQ = bq.getQuery();
            Query absSubQ = QueryUtils.getAbs(subQ);
            if (absSubQ.equals(subQ)) {
                return q;
            }
            return new BoostQuery(absSubQ, bq.getBoost());
        }
        if (q instanceof WrappedQuery) {
            Query subQ = ((WrappedQuery)q).getWrappedQuery();
            Query absSubQ = QueryUtils.getAbs(subQ);
            if (absSubQ.equals(subQ)) {
                return q;
            }
            return new WrappedQuery(absSubQ);
        }
        if (!(q instanceof BooleanQuery)) {
            return q;
        }
        BooleanQuery bq = (BooleanQuery)q;
        List<BooleanClause> clauses = bq.clauses();
        if (clauses.size() == 0) {
            return q;
        }
        for (BooleanClause clause : clauses) {
            if (clause.isProhibited()) continue;
            return q;
        }
        if (clauses.size() == 1) {
            Query negClause = ((BooleanClause)clauses.iterator().next()).getQuery();
            return negClause;
        }
        BooleanQuery.Builder newBqB = new BooleanQuery.Builder();
        for (BooleanClause clause : clauses) {
            newBqB.add(clause.getQuery(), BooleanClause.Occur.SHOULD);
        }
        return newBqB.build();
    }

    public static Query makeQueryable(Query q) {
        if (q instanceof WrappedQuery) {
            return QueryUtils.makeQueryable(((WrappedQuery)q).getWrappedQuery());
        }
        return QueryUtils.isNegative(q) ? QueryUtils.fixNegativeQuery(q) : q;
    }

    public static Query fixNegativeQuery(Query q) {
        Query bq;
        float boost = 1.0f;
        if (q instanceof BoostQuery) {
            bq = (BoostQuery)q;
            boost = ((BoostQuery)bq).getBoost();
            q = ((BoostQuery)bq).getQuery();
        }
        bq = (BooleanQuery)q;
        BooleanQuery.Builder newBqB = new BooleanQuery.Builder();
        newBqB.setMinimumNumberShouldMatch(((BooleanQuery)bq).getMinimumNumberShouldMatch());
        Iterator<BooleanClause> iterator = ((BooleanQuery)bq).iterator();
        while (iterator.hasNext()) {
            BooleanClause clause = iterator.next();
            newBqB.add(clause);
        }
        newBqB.add(new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
        BooleanQuery newBq = newBqB.build();
        return new BoostQuery(newBq, boost);
    }

    public static BooleanQuery build(BooleanQuery.Builder builder, QParser parser) {
        int configuredMax = parser != null ? parser.getReq().getCore().getSolrConfig().booleanQueryMaxClauseCount : IndexSearcher.getMaxClauseCount();
        BooleanQuery bq = builder.build();
        if (bq.clauses().size() > configuredMax) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Too many clauses in boolean query: encountered=" + bq.clauses().size() + " configured in solrconfig.xml via maxBooleanClauses=" + configuredMax);
        }
        return bq;
    }

    public static Query combineQueryAndFilter(Query scoreQuery, Query filterQuery) {
        if (scoreQuery == null || scoreQuery instanceof MatchAllDocsQuery) {
            if (filterQuery == null) {
                return new MatchAllDocsQuery();
            }
            return new ConstantScoreQuery(filterQuery);
        }
        if (filterQuery == null || filterQuery instanceof MatchAllDocsQuery) {
            return scoreQuery;
        }
        return new BooleanQuery.Builder().add(scoreQuery, BooleanClause.Occur.MUST).add(filterQuery, BooleanClause.Occur.FILTER).build();
    }

    public static List<Query> parseFilterQueries(SolrQueryRequest req) throws SyntaxError {
        String[] filterQueriesStr = req.getParams().getParams("fq");
        if (filterQueriesStr != null) {
            ArrayList<Query> filters = new ArrayList<Query>(filterQueriesStr.length);
            for (String fq : filterQueriesStr) {
                if (fq == null || fq.trim().length() == 0) continue;
                QParser fqp = QParser.getParser(fq, req);
                fqp.setIsFilter(true);
                Query query = fqp.getQuery();
                filters.add(query);
            }
            return filters;
        }
        return Collections.emptyList();
    }

    public static Set<Query> getTaggedQueries(SolrQueryRequest req, Collection<String> desiredTags) {
        Map tagMap = (Map)req.getContext().get("tags");
        if (tagMap == null || tagMap.isEmpty() || desiredTags == null || desiredTags.isEmpty()) {
            return Collections.emptySet();
        }
        Set<Query> taggedQueries = Collections.newSetFromMap(new IdentityHashMap());
        for (String tagName : desiredTags) {
            Object tagVal = tagMap.get(tagName);
            if (!(tagVal instanceof Collection)) continue;
            for (Object obj : (Collection)tagVal) {
                Query query;
                if (!(obj instanceof QParser)) continue;
                QParser qParser = (QParser)obj;
                try {
                    query = qParser.getQuery();
                }
                catch (SyntaxError syntaxError) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)syntaxError);
                }
                taggedQueries.add(query);
            }
        }
        return taggedQueries;
    }
}

