/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PrefixCodedTerms;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.AutomatonQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.LongBitSet;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.PointField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.WrappedQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermsQParserPlugin
extends QParserPlugin {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String NAME = "terms";
    public static final String SEPARATOR = "separator";
    private static final String METHOD = "method";

    @Override
    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new QParser(qstr, localParams, params, req){

            @Override
            public Query parse() throws SyntaxError {
                String[] splitVals;
                String fname = this.localParams.get("f");
                if (fname == null || fname.isEmpty()) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing field to query");
                }
                FieldType ft = this.req.getSchema().getFieldType(fname);
                String separator = this.localParams.get(TermsQParserPlugin.SEPARATOR, ",");
                String qstr = this.localParams.get("v");
                Method method = Method.valueOf(this.localParams.get(TermsQParserPlugin.METHOD, Method.termsFilter.name()));
                boolean sepIsSpace = separator.equals(" ");
                if (sepIsSpace) {
                    qstr = qstr.trim();
                }
                if (qstr.length() == 0) {
                    return new MatchNoDocsQuery();
                }
                String[] stringArray = splitVals = sepIsSpace ? qstr.split("\\s+") : qstr.split(Pattern.quote(separator), -1);
                assert (splitVals.length > 0);
                if (ft.isPointField()) {
                    if (this.localParams.get(TermsQParserPlugin.METHOD) != null) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, "Method '%s' not supported in TermsQParser when using PointFields", this.localParams.get(TermsQParserPlugin.METHOD)));
                    }
                    return ((PointField)ft).getSetQuery(this, this.req.getSchema().getField(fname), Arrays.asList(splitVals));
                }
                BytesRef[] bytesRefs = new BytesRef[splitVals.length];
                BytesRefBuilder term = new BytesRefBuilder();
                for (int i = 0; i < splitVals.length; ++i) {
                    String stringVal = splitVals[i];
                    if (ft != null) {
                        ft.readableToIndexed(stringVal, term);
                    } else {
                        term.copyChars(stringVal);
                    }
                    bytesRefs[i] = term.toBytesRef();
                }
                return method.makeFilter(fname, bytesRefs);
            }
        };
    }

    private static class TopLevelDocValuesTermsQuery
    extends TermInSetQuery {
        private final String fieldName;
        private SortedSetDocValues topLevelDocValues;
        private LongBitSet topLevelTermOrdinals;
        private boolean matchesAtLeastOneTerm = false;

        public TopLevelDocValuesTermsQuery(String field, BytesRef ... terms) {
            super(MultiTermQuery.DOC_VALUES_REWRITE, field, terms);
            this.fieldName = field;
        }

        @Override
        public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
            if (!(searcher instanceof SolrIndexSearcher)) {
                log.debug("Falling back to DocValuesTermsQuery because searcher [{}] is not the required SolrIndexSearcher", (Object)searcher);
                return super.createWeight(searcher, scoreMode, boost);
            }
            this.topLevelDocValues = DocValues.getSortedSet(((SolrIndexSearcher)searcher).getSlowAtomicReader(), this.fieldName);
            this.topLevelTermOrdinals = new LongBitSet(this.topLevelDocValues.getValueCount());
            PrefixCodedTerms.TermIterator iterator = this.getTermData().iterator();
            long lastTermOrdFound = 0L;
            BytesRef term = iterator.next();
            while (term != null) {
                long currentTermOrd = this.lookupTerm(this.topLevelDocValues, term, lastTermOrdFound);
                if (currentTermOrd >= 0L) {
                    this.matchesAtLeastOneTerm = true;
                    this.topLevelTermOrdinals.set(currentTermOrd);
                    lastTermOrdFound = currentTermOrd;
                }
                term = iterator.next();
            }
            return new ConstantScoreWeight(this, boost){

                @Override
                public Scorer scorer(LeafReaderContext context) throws IOException {
                    if (!matchesAtLeastOneTerm) {
                        return null;
                    }
                    SortedSetDocValues segmentDocValues = DocValues.getSortedSet(context.reader(), fieldName);
                    if (segmentDocValues == null) {
                        return null;
                    }
                    final int docBase = context.docBase;
                    return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, new TwoPhaseIterator(segmentDocValues){

                        @Override
                        public boolean matches() throws IOException {
                            topLevelDocValues.advanceExact(docBase + this.approximation.docID());
                            long ord = topLevelDocValues.nextOrd();
                            while (ord != -1L) {
                                if (topLevelTermOrdinals.get(ord)) {
                                    return true;
                                }
                                ord = topLevelDocValues.nextOrd();
                            }
                            return false;
                        }

                        @Override
                        public float matchCost() {
                            return 10.0f;
                        }
                    });
                }

                @Override
                public boolean isCacheable(LeafReaderContext ctx) {
                    return DocValues.isCacheable(ctx, fieldName);
                }
            };
        }

        private long lookupTerm(SortedSetDocValues docValues, BytesRef key, long startOrd) throws IOException {
            long low = startOrd;
            long high = docValues.getValueCount() - 1L;
            while (low <= high) {
                long mid = low + high >>> 1;
                BytesRef term = docValues.lookupOrd(mid);
                int cmp = term.compareTo(key);
                if (cmp < 0) {
                    low = mid + 1L;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1L;
                    continue;
                }
                return mid;
            }
            return -(low + 1L);
        }
    }

    private static enum Method {
        termsFilter{

            @Override
            Query makeFilter(String fname, BytesRef[] bytesRefs) {
                return new TermInSetQuery(fname, bytesRefs);
            }
        }
        ,
        booleanQuery{

            @Override
            Query makeFilter(String fname, BytesRef[] byteRefs) {
                BooleanQuery.Builder bq = new BooleanQuery.Builder();
                for (BytesRef byteRef : byteRefs) {
                    bq.add(new TermQuery(new Term(fname, byteRef)), BooleanClause.Occur.SHOULD);
                }
                return new ConstantScoreQuery(bq.build());
            }
        }
        ,
        automaton{

            @Override
            Query makeFilter(String fname, BytesRef[] byteRefs) {
                ArrayUtil.timSort((Comparable[])byteRefs);
                Automaton union = Automata.makeStringUnion(Arrays.asList(byteRefs));
                return new AutomatonQuery(new Term(fname), union);
            }
        }
        ,
        docValuesTermsFilter{

            @Override
            Query makeFilter(String fname, BytesRef[] byteRefs) {
                return byteRefs.length > 700 ? docValuesTermsFilterTopLevel.makeFilter(fname, byteRefs) : docValuesTermsFilterPerSegment.makeFilter(fname, byteRefs);
            }
        }
        ,
        docValuesTermsFilterTopLevel{

            @Override
            Query makeFilter(String fname, BytesRef[] byteRefs) {
                return Method.disableCacheByDefault(new TopLevelDocValuesTermsQuery(fname, byteRefs));
            }
        }
        ,
        docValuesTermsFilterPerSegment{

            @Override
            Query makeFilter(String fname, BytesRef[] byteRefs) {
                return Method.disableCacheByDefault(SortedSetDocValuesField.newSlowSetQuery(fname, byteRefs));
            }
        };


        private static Query disableCacheByDefault(Query q) {
            WrappedQuery wrappedQuery = new WrappedQuery(q);
            wrappedQuery.setCache(false);
            return wrappedQuery;
        }

        abstract Query makeFilter(String var1, BytesRef[] var2);
    }
}

