/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.text.ParseException;
import java.util.function.IntFunction;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongValues;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocSetUtil;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetField;
import org.apache.solr.search.facet.FacetFieldProcessor;
import org.apache.solr.search.facet.FacetRangeProcessor;
import org.apache.solr.search.facet.FieldUtil;
import org.apache.solr.search.facet.SlotAcc;

class FacetFieldProcessorByHashDV
extends FacetFieldProcessor {
    static int MAXIMUM_STARTING_TABLE_SIZE = 1024;
    FacetRangeProcessor.Calc calc;
    LongCounts table;
    int allBucketsSlot = -1;
    private IntFunction<SlotAcc.SlotContext> slotContext = slotNum -> {
        long val = this.table.vals[slotNum];
        Comparable value = this.calc.bitsToValue(val);
        return new SlotAcc.SlotContext(this.sf.getType().getFieldTermQuery(null, this.sf, this.calc.formatValue(value)));
    };

    FacetFieldProcessorByHashDV(FacetContext fcontext, FacetField freq, SchemaField sf) {
        super(fcontext, freq, sf);
        if (freq.mincount == 0L) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, this.getClass() + " doesn't support mincount=0");
        }
        if (freq.prefix != null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, this.getClass() + " doesn't support prefix");
        }
        FieldInfo fieldInfo = fcontext.searcher.getFieldInfos().fieldInfo(sf.getName());
        if (fieldInfo != null && fieldInfo.getDocValuesType() != DocValuesType.NUMERIC && fieldInfo.getDocValuesType() != DocValuesType.SORTED && fieldInfo.getDocValuesType() != DocValuesType.SORTED_NUMERIC) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, this.getClass() + " only support single valued number/string with docValues");
        }
    }

    @Override
    public void process() throws IOException {
        super.process();
        this.response = this.calcFacets();
        this.table = null;
    }

    private SimpleOrderedMap<Object> calcFacets() throws IOException {
        this.calc = this.sf.getType().getNumberType() != null ? FacetRangeProcessor.getNumericCalc(this.sf) : new TermOrdCalc();
        int possibleValues = this.fcontext.base.size();
        int currHashSize = BitUtil.nextHighestPowerOfTwo((int)((float)possibleValues * 1.4285715f + 1.0f));
        currHashSize = Math.min(currHashSize, MAXIMUM_STARTING_TABLE_SIZE);
        this.table = new LongCounts(currHashSize){

            @Override
            protected void rehash() {
                super.rehash();
                FacetFieldProcessorByHashDV.this.doRehash(this);
                this.oldToNewMapping = null;
            }
        };
        this.createCollectAcc();
        this.collectDocs();
        return super.findTopSlots(this.table.numSlots(), this.table.cardinality(), slotNum -> this.calc.bitsToValue(this.table.vals[slotNum]), val -> this.calc.formatValue((Comparable)val));
    }

    private void createCollectAcc() throws IOException {
        int numSlots = this.table.numSlots();
        if (((FacetField)this.freq).allBuckets) {
            this.allBucketsSlot = numSlots++;
        }
        this.indexOrderAcc = new SlotAcc(this.fcontext){

            @Override
            public void collect(int doc, int slot, IntFunction<SlotAcc.SlotContext> slotContext) throws IOException {
            }

            @Override
            public int compare(int slotA, int slotB) {
                long s1 = FacetFieldProcessorByHashDV.this.calc.bitsToSortableBits(FacetFieldProcessorByHashDV.this.table.vals[slotA]);
                long s2 = FacetFieldProcessorByHashDV.this.calc.bitsToSortableBits(FacetFieldProcessorByHashDV.this.table.vals[slotB]);
                return Long.compare(s1, s2);
            }

            @Override
            public Object getValue(int slotNum) throws IOException {
                return null;
            }

            @Override
            public void reset() {
            }

            @Override
            public void resize(SlotAcc.Resizer resizer) {
            }
        };
        this.countAcc = new SlotAcc.CountSlotAcc(this.fcontext){

            @Override
            public void incrementCount(int slot, long count) {
                throw new UnsupportedOperationException();
            }

            @Override
            public long getCount(int slot) {
                return FacetFieldProcessorByHashDV.this.table.counts[slot];
            }

            @Override
            public Object getValue(int slotNum) {
                return this.getCount(slotNum);
            }

            @Override
            public void reset() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void collect(int doc, int slot, IntFunction<SlotAcc.SlotContext> slotContext) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public int compare(int slotA, int slotB) {
                return Long.compare(FacetFieldProcessorByHashDV.this.table.counts[slotA], FacetFieldProcessorByHashDV.this.table.counts[slotB]);
            }

            @Override
            public void resize(SlotAcc.Resizer resizer) {
                throw new UnsupportedOperationException();
            }
        };
        super.createCollectAcc(this.fcontext.base.size(), numSlots);
        if (((FacetField)this.freq).allBuckets) {
            this.allBucketsAcc = new FacetFieldProcessor.SpecialSlotAcc(this.fcontext, this.collectAcc, this.allBucketsSlot, this.otherAccs, 0);
        }
    }

    private void collectDocs() throws IOException {
        if (this.calc instanceof TermOrdCalc) {
            final SortedDocValues globalDocValues = FieldUtil.getSortedDocValues(this.fcontext.qcontext, this.sf, null);
            ((TermOrdCalc)this.calc).lookupOrdFunction = ord -> {
                try {
                    return globalDocValues.lookupOrd(ord);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            };
            DocSetUtil.collectSortedDocSet(this.fcontext.base, this.fcontext.searcher.getIndexReader(), new SimpleCollector(){
                SortedDocValues docValues;
                LongValues toGlobal;
                {
                    this.docValues = globalDocValues;
                    this.toGlobal = LongValues.IDENTITY;
                }

                @Override
                public ScoreMode scoreMode() {
                    return ScoreMode.COMPLETE_NO_SCORES;
                }

                @Override
                protected void doSetNextReader(LeafReaderContext ctx) throws IOException {
                    FacetFieldProcessorByHashDV.this.setNextReaderFirstPhase(ctx);
                    if (globalDocValues instanceof MultiDocValues.MultiSortedDocValues) {
                        MultiDocValues.MultiSortedDocValues multiDocValues = (MultiDocValues.MultiSortedDocValues)globalDocValues;
                        this.docValues = multiDocValues.values[ctx.ord];
                        this.toGlobal = multiDocValues.mapping.getGlobalOrds(ctx.ord);
                    }
                }

                @Override
                public void collect(int segDoc) throws IOException {
                    if (this.docValues.advanceExact(segDoc)) {
                        long val = this.toGlobal.get(this.docValues.ordValue());
                        FacetFieldProcessorByHashDV.this.collectValFirstPhase(segDoc, val);
                    }
                }
            });
        } else if (this.sf.multiValued()) {
            DocSetUtil.collectSortedDocSet(this.fcontext.base, this.fcontext.searcher.getIndexReader(), new SimpleCollector(){
                SortedNumericDocValues values = null;

                @Override
                public ScoreMode scoreMode() {
                    return ScoreMode.COMPLETE_NO_SCORES;
                }

                @Override
                protected void doSetNextReader(LeafReaderContext ctx) throws IOException {
                    FacetFieldProcessorByHashDV.this.setNextReaderFirstPhase(ctx);
                    this.values = DocValues.getSortedNumeric(ctx.reader(), FacetFieldProcessorByHashDV.this.sf.getName());
                }

                @Override
                public void collect(int segDoc) throws IOException {
                    if (this.values.advanceExact(segDoc)) {
                        long l = this.values.nextValue();
                        FacetFieldProcessorByHashDV.this.collectValFirstPhase(segDoc, l);
                        int count = this.values.docValueCount();
                        for (int i = 1; i < count; ++i) {
                            long lnew = this.values.nextValue();
                            if (lnew != l) {
                                FacetFieldProcessorByHashDV.this.collectValFirstPhase(segDoc, lnew);
                            }
                            l = lnew;
                        }
                    }
                }
            });
        } else {
            DocSetUtil.collectSortedDocSet(this.fcontext.base, this.fcontext.searcher.getIndexReader(), new SimpleCollector(){
                NumericDocValues values = null;

                @Override
                public ScoreMode scoreMode() {
                    return ScoreMode.COMPLETE_NO_SCORES;
                }

                @Override
                protected void doSetNextReader(LeafReaderContext ctx) throws IOException {
                    FacetFieldProcessorByHashDV.this.setNextReaderFirstPhase(ctx);
                    this.values = DocValues.getNumeric(ctx.reader(), FacetFieldProcessorByHashDV.this.sf.getName());
                }

                @Override
                public void collect(int segDoc) throws IOException {
                    if (this.values.advanceExact(segDoc)) {
                        FacetFieldProcessorByHashDV.this.collectValFirstPhase(segDoc, this.values.longValue());
                    }
                }
            });
        }
    }

    private void collectValFirstPhase(int segDoc, long val) throws IOException {
        int slot = this.table.add(val);
        super.collectFirstPhase(segDoc, slot, this.slotContext);
    }

    private void doRehash(LongCounts table) {
        int newTableSize;
        if (this.collectAcc == null && this.allBucketsAcc == null) {
            return;
        }
        int numSlots = newTableSize = table.numSlots();
        final int oldAllBucketsSlot = this.allBucketsSlot;
        if (oldAllBucketsSlot >= 0) {
            this.allBucketsSlot = numSlots++;
        }
        final int finalNumSlots = numSlots;
        final long[] mapping = table.oldToNewMapping;
        SlotAcc.Resizer resizer = new SlotAcc.Resizer(){

            @Override
            public int getNewSize() {
                return finalNumSlots;
            }

            @Override
            public int getNewSlot(int oldSlot) {
                if (oldSlot < mapping.length) {
                    return (int)mapping[oldSlot];
                }
                if (oldSlot == oldAllBucketsSlot) {
                    return FacetFieldProcessorByHashDV.this.allBucketsSlot;
                }
                return -1;
            }
        };
        if (this.collectAcc != null) {
            this.collectAcc.resize(resizer);
        }
        if (this.allBucketsAcc != null) {
            this.allBucketsAcc.resize(resizer);
        }
    }

    private class TermOrdCalc
    extends FacetRangeProcessor.Calc {
        IntFunction<BytesRef> lookupOrdFunction;

        TermOrdCalc() throws IOException {
            super(FacetFieldProcessorByHashDV.this.sf);
        }

        @Override
        public long bitsToSortableBits(long globalOrd) {
            return globalOrd;
        }

        @Override
        public Comparable bitsToValue(long globalOrd) {
            BytesRef bytesRef = this.lookupOrdFunction.apply((int)globalOrd);
            return FacetFieldProcessorByHashDV.this.sf.getType().toObject(FacetFieldProcessorByHashDV.this.sf, bytesRef).toString();
        }

        @Override
        public String formatValue(Comparable val) {
            return (String)((Object)val);
        }

        @Override
        protected Comparable parseStr(String rawval) throws ParseException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Comparable parseAndAddGap(Comparable value, String gap) throws ParseException {
            throw new UnsupportedOperationException();
        }
    }

    private static class LongCounts {
        static final float LOAD_FACTOR = 0.7f;
        long[] vals;
        long[] counts;
        long[] oldToNewMapping;
        int cardinality;
        int threshold;

        LongCounts(int sz) {
            this.vals = new long[sz];
            this.counts = new long[sz];
            this.threshold = (int)((float)sz * 0.7f);
        }

        int numSlots() {
            return this.vals.length;
        }

        private int hash(long val) {
            int h = (int)(val + (val >>> 44) + (val >>> 15));
            return h;
        }

        int add(long val) {
            if (this.cardinality >= this.threshold) {
                this.rehash();
            }
            int h = this.hash(val);
            int slot = h & this.vals.length - 1;
            while (true) {
                long count;
                if ((count = this.counts[slot]) == 0L) {
                    this.counts[slot] = 1L;
                    this.vals[slot] = val;
                    ++this.cardinality;
                    return slot;
                }
                if (this.vals[slot] == val) {
                    this.counts[slot] = count + 1L;
                    return slot;
                }
                slot = slot + (h >> 7 | 1) & this.vals.length - 1;
            }
        }

        protected void rehash() {
            long[] oldVals = this.vals;
            long[] oldCounts = this.counts;
            int newCapacity = this.vals.length << 1;
            this.vals = new long[newCapacity];
            this.counts = new long[newCapacity];
            this.threshold = (int)((float)newCapacity * 0.7f);
            for (int i = 0; i < oldVals.length; ++i) {
                long count = oldCounts[i];
                if (count == 0L) {
                    oldCounts[i] = -1L;
                    continue;
                }
                long val = oldVals[i];
                int h = this.hash(val);
                int slot = h & this.vals.length - 1;
                while (this.counts[slot] != 0L) {
                    slot = slot + (h >> 7 | 1) & this.vals.length - 1;
                }
                this.counts[slot] = count;
                this.vals[slot] = val;
                oldCounts[i] = slot;
            }
            this.oldToNewMapping = oldCounts;
        }

        int cardinality() {
            return this.cardinality;
        }
    }
}

