/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.CollectionUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.search.QueryContext;
import org.apache.solr.search.facet.AggValueSource;
import org.apache.solr.search.facet.FacetBucket;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetDebugInfo;
import org.apache.solr.search.facet.FacetMerger;
import org.apache.solr.search.facet.FacetQuery;
import org.apache.solr.search.facet.FacetRequest;
import org.apache.solr.search.facet.LegacyFacet;
import org.noggit.CharArr;
import org.noggit.JSONWriter;

public class FacetModule
extends SearchComponent {
    public static final String COMPONENT_NAME = "facet_module";
    public static final int PURPOSE_GET_JSON_FACETS = 0x100000;
    public static final int PURPOSE_REFINE_JSON_FACETS = 0x200000;
    private static final String FACET_INFO = "_facet_";
    private static final String FACET_REFINE = "refine";

    public FacetComponentState getFacetComponentState(ResponseBuilder rb) {
        return (FacetComponentState)rb.req.getContext().get(FacetComponentState.class);
    }

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
        Map<String, Object> json = rb.req.getJSON();
        Map<String, Object> jsonFacet = null;
        if (json == null) {
            int version = rb.req.getParams().getInt("facet.version", 1);
            if (version <= 1) {
                return;
            }
            boolean facetsEnabled = rb.req.getParams().getBool("facet", false);
            if (!facetsEnabled) {
                return;
            }
            jsonFacet = new LegacyFacet(rb.req.getParams()).getLegacy();
        } else {
            Object jsonObj = json.get("facet");
            if (jsonObj instanceof Map) {
                jsonFacet = (Map<String, Object>)jsonObj;
            } else if (jsonObj != null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Expected Map for 'facet', received " + jsonObj.getClass().getSimpleName() + "=" + jsonObj);
            }
        }
        if (jsonFacet == null) {
            return;
        }
        SolrParams params = rb.req.getParams();
        boolean isShard = params.getBool("isShard", false);
        Map facetInfo = null;
        if (isShard) {
            String jfacet = params.get(FACET_INFO);
            if (jfacet == null) {
                return;
            }
            facetInfo = (Map)Utils.fromJSONString(jfacet);
        }
        rb.setNeedDocSet(true);
        FacetRequest facetRequest = FacetRequest.parse(rb.req, jsonFacet);
        FacetComponentState fcState = new FacetComponentState();
        fcState.rb = rb;
        fcState.isShard = isShard;
        fcState.facetInfo = facetInfo;
        fcState.facetCommands = jsonFacet;
        fcState.facetRequest = facetRequest;
        rb.req.getContext().put(FacetComponentState.class, fcState);
    }

    @Override
    public void process(ResponseBuilder rb) throws IOException {
        FacetComponentState facetState = this.getFacetComponentState(rb);
        if (facetState == null) {
            return;
        }
        boolean cache = rb.req.getParams().getBool("cache", true);
        boolean isShard = rb.req.getParams().getBool("isShard", false);
        FacetContext fcontext = new FacetContext();
        fcontext.base = rb.getResults().docSet;
        fcontext.req = rb.req;
        fcontext.searcher = rb.req.getSearcher();
        fcontext.qcontext = QueryContext.newContext(fcontext.searcher);
        fcontext.cache = cache;
        if (isShard) {
            fcontext.flags |= 1;
            Map<String, Object> map = fcontext.facetInfo = facetState.facetInfo.isEmpty() ? null : (Map<String, Object>)facetState.facetInfo.get(FACET_REFINE);
            if (fcontext.facetInfo != null) {
                fcontext.flags |= 2;
                fcontext.flags |= 4;
            }
        }
        if (rb.isDebug()) {
            FacetDebugInfo fdebug = new FacetDebugInfo();
            fcontext.setDebugInfo(fdebug);
            rb.req.getContext().put("FacetDebugInfo", fdebug);
        }
        Object results = facetState.facetRequest.process(fcontext);
        rb.rsp.add("facets", results);
    }

    private void clearFaceting(List<ShardRequest> outgoing) {
        for (ShardRequest sreq : outgoing) {
            if ((sreq.purpose & 0x200000) != 0) continue;
            sreq.params.remove("json.facet");
            sreq.params.remove(FACET_INFO);
        }
    }

    @Override
    public int distributedProcess(ResponseBuilder rb) throws IOException {
        FacetComponentState facetState = this.getFacetComponentState(rb);
        if (facetState == null) {
            return ResponseBuilder.STAGE_DONE;
        }
        if (rb.stage != ResponseBuilder.STAGE_GET_FIELDS) {
            return ResponseBuilder.STAGE_DONE;
        }
        if (facetState.mcontext == null || facetState.mcontext.getSubsWithRefinement(facetState.facetRequest).isEmpty()) {
            this.clearFaceting(rb.outgoing);
            return ResponseBuilder.STAGE_DONE;
        }
        assert (rb.shards.length == facetState.mcontext.numShards);
        for (String shard : rb.shards) {
            facetState.mcontext.setShard(shard);
            Map<String, Object> refinement = facetState.merger.getRefinement(facetState.mcontext);
            if (refinement == null) continue;
            boolean newRequest = false;
            ShardRequest shardsRefineRequest = null;
            for (ShardRequest sreq : rb.outgoing) {
                if ((sreq.purpose & 0x2060) == 0 || sreq.shards == null || sreq.shards.length != 1 || !sreq.shards[0].equals(shard)) continue;
                shardsRefineRequest = sreq;
                break;
            }
            if (shardsRefineRequest == null) {
                newRequest = true;
                shardsRefineRequest = new ShardRequest();
                shardsRefineRequest.shards = new String[]{shard};
                shardsRefineRequest.params = new ModifiableSolrParams(rb.req.getParams());
                shardsRefineRequest.params.remove("start");
                shardsRefineRequest.params.set("rows", "0");
                shardsRefineRequest.params.set("facet", false);
            }
            shardsRefineRequest.purpose |= 0x200000;
            HashMap<String, Map<String, Object>> finfo = CollectionUtil.newHashMap(1);
            finfo.put(FACET_REFINE, refinement);
            CharArr out = new CharArr();
            JSONWriter jsonWriter = new JSONWriter(out, -1){

                @Override
                public void handleUnknownClass(Object o) {
                    if (o instanceof Date) {
                        String s = ((Date)o).toInstant().toString();
                        this.writeString(s);
                        return;
                    }
                    super.handleUnknownClass(o);
                }
            };
            jsonWriter.write(finfo);
            String finfoStr = out.toString();
            shardsRefineRequest.params.add(FACET_INFO, finfoStr);
            if (!newRequest) continue;
            rb.addRequest(this, shardsRefineRequest);
        }
        return ResponseBuilder.STAGE_DONE;
    }

    @Override
    public void modifyRequest(ResponseBuilder rb, SearchComponent who, ShardRequest sreq) {
        FacetComponentState facetState = this.getFacetComponentState(rb);
        if (facetState == null) {
            return;
        }
        if ((sreq.purpose & 4) != 0) {
            sreq.purpose |= 0x100000;
            sreq.params.set(FACET_INFO, "{}");
        }
    }

    @Override
    public void handleResponses(ResponseBuilder rb, ShardRequest sreq) {
        FacetComponentState facetState = this.getFacetComponentState(rb);
        if (facetState == null) {
            return;
        }
        for (ShardResponse shardRsp : sreq.responses) {
            SolrResponse rsp = shardRsp.getSolrResponse();
            NamedList<Object> top = rsp.getResponse();
            if (top == null) continue;
            Object facet = top.get("facets");
            if (facet == null) {
                SimpleOrderedMap shardResponseHeader = (SimpleOrderedMap)rsp.getResponse().get("responseHeader");
                if (!Boolean.TRUE.equals(shardResponseHeader.getBooleanArg("partialResults"))) continue;
                rb.rsp.getResponseHeader().asShallowMap().put("partialResults", Boolean.TRUE);
                continue;
            }
            if (facetState.merger == null) {
                facetState.merger = facetState.facetRequest.createFacetMerger(facet);
                facetState.mcontext = new FacetMerger.Context(sreq.responses.size());
            }
            if ((sreq.purpose & 0x200000) != 0) {
                facetState.mcontext.root = facet;
                facetState.mcontext.setShard(shardRsp.getShard());
                facetState.merger.merge(facet, facetState.mcontext);
                return;
            }
            facetState.mcontext.root = facet;
            facetState.mcontext.newShard(shardRsp.getShard());
            facetState.merger.merge(facet, facetState.mcontext);
        }
    }

    @Override
    public void finishStage(ResponseBuilder rb) {
        if (rb.stage != ResponseBuilder.STAGE_GET_FIELDS) {
            return;
        }
        FacetComponentState facetState = this.getFacetComponentState(rb);
        if (facetState == null) {
            return;
        }
        if (facetState.merger != null) {
            rb.rsp.add("facets", facetState.merger.getMergedResult());
        }
    }

    @Override
    public String getDescription() {
        return "Facet Module";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.QUERY;
    }

    static class FacetQueryMerger
    extends FacetBucketMerger<FacetQuery> {
        FacetBucket bucket;

        public FacetQueryMerger(FacetQuery freq) {
            super(freq);
        }

        @Override
        public void merge(Object facet, FacetMerger.Context mcontext) {
            if (this.bucket == null) {
                this.bucket = this.newBucket(null, mcontext);
            }
            this.bucket.mergeBucket((SimpleOrderedMap)facet, mcontext);
        }

        @Override
        public Map<String, Object> getRefinement(FacetMerger.Context mcontext) {
            Collection<String> tags = mcontext.bucketWasMissing() ? mcontext.getSubsWithPartial(this.freq) : mcontext.getSubsWithRefinement(this.freq);
            Map<String, Object> refinement = this.bucket.getRefinement(mcontext, tags);
            return refinement;
        }

        @Override
        public void finish(FacetMerger.Context mcontext) {
        }

        @Override
        public Object getMergedResult() {
            return this.bucket.getMergedBucket();
        }
    }

    static abstract class FacetBucketMerger<FacetRequestT extends FacetRequest>
    extends FacetMerger {
        FacetRequestT freq;

        public FacetBucketMerger(FacetRequestT freq) {
            this.freq = freq;
        }

        FacetBucket newBucket(Comparable bucketVal, FacetMerger.Context mcontext) {
            return new FacetBucket(this, bucketVal, mcontext);
        }

        @Override
        public Map<String, Object> getRefinement(FacetMerger.Context mcontext) {
            Collection<String> refineTags = mcontext.getSubsWithRefinement((FacetRequest)this.freq);
            return null;
        }

        FacetMerger createFacetMerger(String key, Object val) {
            FacetRequest sub = ((FacetRequest)this.freq).getSubFacets().get(key);
            if (sub != null) {
                return sub.createFacetMerger(val);
            }
            AggValueSource subStat = ((FacetRequest)this.freq).getFacetStats().get(key);
            if (subStat != null) {
                return subStat.createFacetMerger(val);
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "no merger for key=" + key + " , val=" + val);
        }
    }

    static class FacetLongMerger
    extends FacetSortableMerger {
        long val;

        FacetLongMerger() {
        }

        @Override
        public void merge(Object facetResult, FacetMerger.Context mcontext) {
            this.val += ((Number)facetResult).longValue();
        }

        @Override
        public Object getMergedResult() {
            return this.val;
        }

        @Override
        public int compareTo(FacetSortableMerger other, FacetRequest.SortDirection direction) {
            return Long.compare(this.val, ((FacetLongMerger)other).val);
        }
    }

    static abstract class FacetDoubleMerger
    extends FacetSortableMerger {
        FacetDoubleMerger() {
        }

        @Override
        public abstract void merge(Object var1, FacetMerger.Context var2);

        protected abstract double getDouble();

        @Override
        public Object getMergedResult() {
            return this.getDouble();
        }

        @Override
        public int compareTo(FacetSortableMerger other, FacetRequest.SortDirection direction) {
            return FacetDoubleMerger.compare(this.getDouble(), ((FacetDoubleMerger)other).getDouble(), direction);
        }

        public static int compare(double a, double b, FacetRequest.SortDirection direction) {
            if (a < b) {
                return -1;
            }
            if (a > b) {
                return 1;
            }
            if (Double.isNaN(a)) {
                if (Double.isNaN(b)) {
                    return 0;
                }
                return -1 * direction.getMultiplier();
            }
            if (Double.isNaN(b)) {
                return 1 * direction.getMultiplier();
            }
            return 0;
        }
    }

    static abstract class FacetSortableMerger
    extends FacetMerger {
        FacetSortableMerger() {
        }

        public void prepareSort() {
        }

        @Override
        public void finish(FacetMerger.Context mcontext) {
        }

        public abstract int compareTo(FacetSortableMerger var1, FacetRequest.SortDirection var2);
    }

    static class FacetComponentState {
        ResponseBuilder rb;
        Map<String, Object> facetCommands;
        FacetRequest facetRequest;
        boolean isShard;
        Map<String, Object> facetInfo;
        FacetMerger merger;
        FacetMerger.Context mcontext;

        FacetComponentState() {
        }
    }
}

