/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.params.FacetParams;
import org.apache.solr.common.util.CollectionUtil;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.search.facet.FacetBucket;
import org.apache.solr.search.facet.FacetMerger;
import org.apache.solr.search.facet.FacetRange;
import org.apache.solr.search.facet.FacetRequest;
import org.apache.solr.search.facet.FacetRequestSortedMerger;

public class FacetRangeMerger
extends FacetRequestSortedMerger<FacetRange> {
    FacetBucket beforeBucket;
    FacetBucket afterBucket;
    FacetBucket betweenBucket;
    Object actual_end = null;

    public FacetRangeMerger(FacetRange freq) {
        super(freq);
    }

    @Override
    public void merge(Object facetResult, FacetMerger.Context mcontext) {
        super.merge(facetResult, mcontext);
        this.merge((SimpleOrderedMap)facetResult, mcontext);
    }

    @Override
    public void sortBuckets(FacetRequest.FacetSort sort) {
        this.sortedBuckets = new ArrayList(this.buckets.values());
    }

    @Override
    public void finish(FacetMerger.Context mcontext) {
    }

    @Override
    Map<String, Object> getRefinementSpecial(FacetMerger.Context mcontext, Map<String, Object> refinement, Collection<String> tagsWithPartial) {
        if (!tagsWithPartial.isEmpty()) {
            refinement = this.getRefinementSpecial(mcontext, refinement, tagsWithPartial, this.beforeBucket, FacetParams.FacetRangeOther.BEFORE.toString());
            refinement = this.getRefinementSpecial(mcontext, refinement, tagsWithPartial, this.afterBucket, FacetParams.FacetRangeOther.AFTER.toString());
            refinement = this.getRefinementSpecial(mcontext, refinement, tagsWithPartial, this.betweenBucket, FacetParams.FacetRangeOther.BETWEEN.toString());
            if (!((FacetRange)this.freq).hardend && this.actual_end != null && refinement != null && (refinement.containsKey(FacetParams.FacetRangeOther.AFTER.toString()) || refinement.containsKey(FacetParams.FacetRangeOther.BETWEEN.toString()))) {
                refinement.put("_actual_end", this.actual_end);
            }
        }
        return refinement;
    }

    private Map<String, Object> getRefinementSpecial(FacetMerger.Context mcontext, Map<String, Object> refinement, Collection<String> tagsWithPartial, FacetBucket bucket, String label) {
        if (null == bucket) {
            return refinement;
        }
        Map<String, Object> bucketRefinement = bucket.getRefinement(mcontext, tagsWithPartial);
        if (bucketRefinement != null) {
            refinement = refinement == null ? CollectionUtil.newHashMap(2) : refinement;
            refinement.put(label, bucketRefinement);
        }
        return refinement;
    }

    public void merge(SimpleOrderedMap<?> facetResult, FacetMerger.Context mcontext) {
        Object shard_actual_end;
        Object o;
        boolean all = ((FacetRange)this.freq).others.contains((Object)FacetParams.FacetRangeOther.ALL);
        if ((all || ((FacetRange)this.freq).others.contains((Object)FacetParams.FacetRangeOther.BEFORE)) && (o = facetResult.get(FacetParams.FacetRangeOther.BEFORE.toString())) != null) {
            if (this.beforeBucket == null) {
                this.beforeBucket = this.newBucket(null, mcontext);
            }
            this.beforeBucket.mergeBucket((SimpleOrderedMap)o, mcontext);
        }
        if ((all || ((FacetRange)this.freq).others.contains((Object)FacetParams.FacetRangeOther.AFTER)) && (o = facetResult.get(FacetParams.FacetRangeOther.AFTER.toString())) != null) {
            if (this.afterBucket == null) {
                this.afterBucket = this.newBucket(null, mcontext);
            }
            this.afterBucket.mergeBucket((SimpleOrderedMap)o, mcontext);
        }
        if ((all || ((FacetRange)this.freq).others.contains((Object)FacetParams.FacetRangeOther.BETWEEN)) && (o = facetResult.get(FacetParams.FacetRangeOther.BETWEEN.toString())) != null) {
            if (this.betweenBucket == null) {
                this.betweenBucket = this.newBucket(null, mcontext);
            }
            this.betweenBucket.mergeBucket((SimpleOrderedMap)o, mcontext);
        }
        if (null != (shard_actual_end = facetResult.get("_actual_end"))) {
            if (null == this.actual_end) {
                this.actual_end = shard_actual_end;
            } else assert (this.actual_end.equals(shard_actual_end)) : this.actual_end + " != " + shard_actual_end;
        }
        List bucketList = (List)facetResult.get("buckets");
        this.mergeBucketList(bucketList, mcontext);
    }

    @Override
    public Object getMergedResult() {
        SimpleOrderedMap<Cloneable> result = new SimpleOrderedMap<Cloneable>(4);
        ArrayList<SimpleOrderedMap<Object>> resultBuckets = new ArrayList<SimpleOrderedMap<Object>>(this.buckets.size());
        for (FacetBucket bucket : this.buckets.values()) {
            if (bucket.getCount() < ((FacetRange)this.freq).mincount) continue;
            resultBuckets.add(bucket.getMergedBucket());
        }
        result.add("buckets", resultBuckets);
        if (this.beforeBucket != null) {
            result.add(FacetParams.FacetRangeOther.BEFORE.toString(), this.beforeBucket.getMergedBucket());
        }
        if (this.afterBucket != null) {
            result.add(FacetParams.FacetRangeOther.AFTER.toString(), this.afterBucket.getMergedBucket());
        }
        if (this.betweenBucket != null) {
            result.add(FacetParams.FacetRangeOther.BETWEEN.toString(), this.betweenBucket.getMergedBucket());
        }
        return result;
    }
}

