/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.function.IntFunction;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.LongValues;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FieldUtil;
import org.apache.solr.search.facet.HLLAgg;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.search.facet.UniqueSlotAcc;

class UniqueMultiDvSlotAcc
extends UniqueSlotAcc {
    SortedSetDocValues topLevel;
    SortedSetDocValues[] subDvs;
    OrdinalMap ordMap;
    LongValues toGlobal;
    SortedSetDocValues subDv;

    public UniqueMultiDvSlotAcc(FacetContext fcontext, SchemaField field, int numSlots, HLLAgg.HLLFactory factory) throws IOException {
        super(fcontext, field, numSlots, factory);
    }

    @Override
    public void resetIterators() throws IOException {
        this.topLevel = FieldUtil.getSortedSetDocValues(this.fcontext.qcontext, this.field, null);
        this.nTerms = (int)this.topLevel.getValueCount();
        if (this.topLevel instanceof MultiDocValues.MultiSortedSetDocValues) {
            this.ordMap = ((MultiDocValues.MultiSortedSetDocValues)this.topLevel).mapping;
            this.subDvs = ((MultiDocValues.MultiSortedSetDocValues)this.topLevel).values;
        } else {
            this.ordMap = null;
            this.subDvs = null;
        }
    }

    @Override
    protected BytesRef lookupOrd(int ord) throws IOException {
        return this.topLevel.lookupOrd(ord);
    }

    @Override
    public void setNextReader(LeafReaderContext readerContext) throws IOException {
        super.setNextReader(readerContext);
        if (this.subDvs != null) {
            this.subDv = this.subDvs[readerContext.ord];
            this.toGlobal = this.ordMap.getGlobalOrds(readerContext.ord);
        } else {
            assert (readerContext.ord == 0 || this.topLevel.getValueCount() == 0L);
            this.subDv = this.topLevel;
        }
    }

    @Override
    public void collect(int doc, int slotNum, IntFunction<SlotAcc.SlotContext> slotContext) throws IOException {
        if (this.subDv.advanceExact(doc)) {
            int segOrd = (int)this.subDv.nextOrd();
            assert (segOrd >= 0);
            FixedBitSet bits = this.arr[slotNum];
            if (bits == null) {
                this.arr[slotNum] = bits = new FixedBitSet(this.nTerms);
            }
            do {
                int ord = this.toGlobal == null ? segOrd : (int)this.toGlobal.get(segOrd);
                bits.set(ord);
            } while ((segOrd = (int)this.subDv.nextOrd()) >= 0);
        }
    }
}

