/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.DoubleDocValues;
import org.apache.lucene.queries.function.valuesource.MultiFunction;
import org.apache.lucene.search.IndexSearcher;

public abstract class DualDoubleFunction
extends ValueSource {
    protected final ValueSource a;
    protected final ValueSource b;

    public DualDoubleFunction(ValueSource a, ValueSource b) {
        this.a = a;
        this.b = b;
    }

    protected abstract String name();

    protected abstract double func(int var1, FunctionValues var2, FunctionValues var3) throws IOException;

    @Override
    public String description() {
        return this.name() + "(" + this.a.description() + "," + this.b.description() + ")";
    }

    @Override
    public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        final FunctionValues aVals = this.a.getValues(context, readerContext);
        final FunctionValues bVals = this.b.getValues(context, readerContext);
        return new DoubleDocValues(this){

            @Override
            public double doubleVal(int doc) throws IOException {
                return DualDoubleFunction.this.func(doc, aVals, bVals);
            }

            @Override
            public boolean exists(int doc) throws IOException {
                return MultiFunction.allExists(doc, aVals, bVals);
            }

            @Override
            public String toString(int doc) throws IOException {
                return DualDoubleFunction.this.name() + "(" + aVals.toString(doc) + "," + bVals.toString(doc) + ")";
            }
        };
    }

    @Override
    public void createWeight(Map<Object, Object> context, IndexSearcher searcher) throws IOException {
        this.a.createWeight(context, searcher);
        this.b.createWeight(context, searcher);
    }

    @Override
    public int hashCode() {
        int h = this.a.hashCode();
        h ^= h << 13 | h >>> 20;
        h += this.b.hashCode();
        h ^= h << 23 | h >>> 10;
        return h += this.name().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DualDoubleFunction)) {
            return false;
        }
        DualDoubleFunction other = (DualDoubleFunction)o;
        return Objects.equals(this.a, other.a) && Objects.equals(this.b, other.b);
    }
}

