/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.ComparisonBoolFunction;

public class EqualFunction
extends ComparisonBoolFunction {
    public EqualFunction(ValueSource lhs, ValueSource rhs, String name) {
        super(lhs, rhs, name);
    }

    @Override
    public boolean compare(int doc, FunctionValues lhs, FunctionValues rhs) throws IOException {
        Object objL = lhs.objectVal(doc);
        Object objR = rhs.objectVal(doc);
        if (EqualFunction.isNumeric(objL) && EqualFunction.isNumeric(objR)) {
            if (EqualFunction.isInteger(objL) && EqualFunction.isInteger(objR)) {
                return Long.compare(((Number)objL).longValue(), ((Number)objR).longValue()) == 0;
            }
            return Double.compare(((Number)objL).doubleValue(), ((Number)objR).doubleValue()) == 0;
        }
        return Objects.equals(objL, objR);
    }

    private static boolean isInteger(Object obj) {
        return obj instanceof Integer || obj instanceof Long;
    }

    private static boolean isNumeric(Object obj) {
        return obj instanceof Number;
    }
}

