/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.IntDocValues;
import org.apache.lucene.search.SortedSetSelector;
import org.apache.solr.common.SolrException;
import org.apache.solr.index.SlowCompositeReaderWrapper;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.NumericHidingLeafReader;
import org.apache.solr.search.SolrIndexSearcher;

public class ReverseOrdFieldSource
extends ValueSource {
    public final String field;
    private static final int hcode = ReverseOrdFieldSource.class.hashCode();

    public ReverseOrdFieldSource(String field) {
        this.field = field;
    }

    @Override
    public String description() {
        return "rord(" + this.field + ")";
    }

    @Override
    public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        LeafReader r;
        final int off = readerContext.docBase;
        Object o = context.get("searcher");
        if (o instanceof SolrIndexSearcher) {
            SolrIndexSearcher is = (SolrIndexSearcher)o;
            SchemaField sf = is.getSchema().getFieldOrNull(this.field);
            if (sf != null && sf.getType().isPointField()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "rord() is not supported over Points based field " + this.field);
            }
            if (sf != null && !sf.hasDocValues() && !sf.multiValued() && sf.getType().getNumberType() != null) {
                List<LeafReaderContext> leaves = is.getIndexReader().leaves();
                IndexReader[] hidingLeaves = new LeafReader[leaves.size()];
                int upto = 0;
                for (LeafReaderContext raw : leaves) {
                    hidingLeaves[upto++] = NumericHidingLeafReader.wrap(raw.reader(), this.field);
                }
                r = SlowCompositeReaderWrapper.wrap(new MultiReader(hidingLeaves));
            } else {
                r = ((SolrIndexSearcher)o).getSlowAtomicReader();
            }
        } else {
            IndexReader topReader = ReaderUtil.getTopLevelContext(readerContext).reader();
            r = SlowCompositeReaderWrapper.wrap(topReader);
        }
        final SortedDocValues sindex = SortedSetSelector.wrap(DocValues.getSortedSet(r, this.field), SortedSetSelector.Type.MIN);
        final int end = sindex.getValueCount();
        return new IntDocValues(this){

            @Override
            public int intVal(int doc) throws IOException {
                if (doc + off > sindex.docID()) {
                    sindex.advance(doc + off);
                }
                if (doc + off == sindex.docID()) {
                    return end - sindex.ordValue() - 1;
                }
                return end;
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ReverseOrdFieldSource)) {
            return false;
        }
        ReverseOrdFieldSource other = (ReverseOrdFieldSource)o;
        return this.field.equals(other.field);
    }

    @Override
    public int hashCode() {
        return hcode + this.field.hashCode();
    }
}

