/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.distributed.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.grouping.AllGroupsCollector;
import org.apache.lucene.search.grouping.FirstPassGroupingCollector;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.search.grouping.TermGroupSelector;
import org.apache.lucene.search.grouping.ValueSourceGroupSelector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.grouping.Command;
import org.apache.solr.search.grouping.distributed.command.GroupConverter;
import org.apache.solr.search.grouping.distributed.command.SearchGroupsFieldCommandResult;

public class SearchGroupsFieldCommand
implements Command<SearchGroupsFieldCommandResult> {
    private final SchemaField field;
    private final Sort groupSort;
    private final int topNGroups;
    private final boolean includeGroupCount;
    private FirstPassGroupingCollector<?> firstPassGroupingCollector;
    private AllGroupsCollector<?> allGroupsCollector;

    private SearchGroupsFieldCommand(SchemaField field, Sort groupSort, int topNGroups, boolean includeGroupCount) {
        this.field = field;
        this.groupSort = groupSort;
        this.topNGroups = topNGroups;
        this.includeGroupCount = includeGroupCount;
    }

    @Override
    public List<Collector> create() throws IOException {
        ValueSource vs;
        ArrayList<Collector> collectors = new ArrayList<Collector>(2);
        FieldType fieldType = this.field.getType();
        if (this.topNGroups > 0) {
            if (fieldType.getNumberType() != null) {
                vs = fieldType.getValueSource(this.field, null);
                this.firstPassGroupingCollector = new FirstPassGroupingCollector<MutableValue>(new ValueSourceGroupSelector(vs, new HashMap<Object, Object>()), this.groupSort, this.topNGroups);
            } else {
                this.firstPassGroupingCollector = new FirstPassGroupingCollector<BytesRef>(new TermGroupSelector(this.field.getName()), this.groupSort, this.topNGroups);
            }
            collectors.add(this.firstPassGroupingCollector);
        }
        if (this.includeGroupCount) {
            if (fieldType.getNumberType() != null) {
                vs = fieldType.getValueSource(this.field, null);
                this.allGroupsCollector = new AllGroupsCollector<MutableValue>(new ValueSourceGroupSelector(vs, new HashMap<Object, Object>()));
            } else {
                this.allGroupsCollector = new AllGroupsCollector<BytesRef>(new TermGroupSelector(this.field.getName()));
            }
            collectors.add(this.allGroupsCollector);
        }
        return collectors;
    }

    @Override
    public SearchGroupsFieldCommandResult result() throws IOException {
        Collection<SearchGroup<Comparable<BytesRef>>> topGroups;
        if (this.firstPassGroupingCollector != null) {
            Collection<SearchGroup<MutableValue>> values = this.firstPassGroupingCollector.getTopGroups(0);
            topGroups = this.field.getType().getNumberType() != null ? GroupConverter.fromMutable(this.field, values) : values;
        } else {
            topGroups = Collections.emptyList();
        }
        Integer groupCount = this.allGroupsCollector != null ? Integer.valueOf(this.allGroupsCollector.getGroupCount()) : null;
        return new SearchGroupsFieldCommandResult(groupCount, topGroups);
    }

    @Override
    public Sort getWithinGroupSort() {
        return null;
    }

    @Override
    public Sort getGroupSort() {
        return this.groupSort;
    }

    @Override
    public String getKey() {
        return this.field.getName();
    }

    public static class Builder {
        private SchemaField field;
        private Sort groupSort;
        private Integer topNGroups;
        private boolean includeGroupCount = false;

        public Builder setField(SchemaField field) {
            this.field = field;
            return this;
        }

        public Builder setGroupSort(Sort groupSort) {
            this.groupSort = groupSort;
            return this;
        }

        public Builder setTopNGroups(int topNGroups) {
            this.topNGroups = topNGroups;
            return this;
        }

        public Builder setIncludeGroupCount(boolean includeGroupCount) {
            this.includeGroupCount = includeGroupCount;
            return this;
        }

        public SearchGroupsFieldCommand build() {
            if (this.field == null || this.groupSort == null || this.topNGroups == null) {
                throw new IllegalStateException("All fields must be set");
            }
            return new SearchGroupsFieldCommand(this.field, this.groupSort, this.topNGroups, this.includeGroupCount);
        }
    }
}

