/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.distributed.responseprocessor;

import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardDoc;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.search.grouping.distributed.ShardResponseProcessor;
import org.apache.solr.util.SolrResponseUtil;

public class StoredFieldsShardResponseProcessor
implements ShardResponseProcessor {
    @Override
    public void process(ResponseBuilder rb, ShardRequest shardRequest) {
        SolrDocumentList docs;
        boolean returnScores = (rb.getFieldFlags() & 1) != 0;
        ShardResponse srsp = shardRequest.responses.get(0);
        String uniqueIdFieldName = rb.req.getSchema().getUniqueKeyField().getName();
        if (rb.rsp.getReturnFields().getFieldRenames().get(uniqueIdFieldName) != null) {
            uniqueIdFieldName = rb.rsp.getReturnFields().getFieldRenames().get(uniqueIdFieldName);
        }
        if ((docs = (SolrDocumentList)SolrResponseUtil.getSubsectionFromShardResponse(rb, srsp, "response", false)) == null) {
            return;
        }
        for (SolrDocument doc : docs) {
            String id = doc.getFieldValue(uniqueIdFieldName).toString();
            ShardDoc shardDoc = rb.resultIds.get(id);
            if (shardDoc == null) continue;
            if (returnScores && !Float.isNaN(shardDoc.score)) {
                doc.setField("score", Float.valueOf(shardDoc.score));
            }
            rb.retrievedDocuments.put(id, doc);
        }
    }
}

