/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.endresulttransformer;

import java.io.Serializable;
import java.util.Map;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.search.grouping.distributed.command.QueryCommandResult;
import org.apache.solr.search.grouping.endresulttransformer.EndResultTransformer;

public class SimpleEndResultTransformer
implements EndResultTransformer {
    @Override
    public void transform(Map<String, ?> result, ResponseBuilder rb, EndResultTransformer.SolrDocumentSource solrDocumentSource) {
        SimpleOrderedMap commands = new SimpleOrderedMap();
        for (Map.Entry<String, ?> entry : result.entrySet()) {
            SimpleOrderedMap<Serializable> command;
            Object value = entry.getValue();
            if (TopGroups.class.isInstance(value)) {
                TopGroups topGroups = (TopGroups)value;
                command = new SimpleOrderedMap<Serializable>();
                command.add("matches", Integer.valueOf(rb.totalHitCount));
                if (topGroups.totalGroupCount != null) {
                    command.add("ngroups", topGroups.totalGroupCount);
                }
                SolrDocumentList docList = new SolrDocumentList();
                docList.setStart(rb.getGroupingSpec().getGroupSortSpec().getOffset());
                docList.setNumFound(topGroups.totalHitCount);
                float maxScore = Float.NEGATIVE_INFINITY;
                for (GroupDocs group : topGroups.groups) {
                    for (ScoreDoc scoreDoc : group.scoreDocs) {
                        SolrDocument solrDocument;
                        if (maxScore < scoreDoc.score) {
                            maxScore = scoreDoc.score;
                        }
                        if ((solrDocument = solrDocumentSource.retrieve(scoreDoc)) == null) continue;
                        docList.add(solrDocument);
                    }
                }
                if (maxScore != Float.NEGATIVE_INFINITY) {
                    docList.setMaxScore(Float.valueOf(maxScore));
                }
                command.add("doclist", docList);
                commands.add(entry.getKey(), command);
                continue;
            }
            if (!(value instanceof QueryCommandResult)) continue;
            QueryCommandResult queryCommandResult = (QueryCommandResult)value;
            command = new SimpleOrderedMap();
            command.add("matches", Integer.valueOf(queryCommandResult.getMatches()));
            TopDocs topDocs = queryCommandResult.getTopDocs();
            SolrDocumentList docList = new SolrDocumentList();
            docList.setStart(rb.getGroupingSpec().getGroupSortSpec().getOffset());
            docList.setNumFound(topDocs.totalHits.value);
            if (!Float.isNaN(queryCommandResult.getMaxScore())) {
                docList.setMaxScore(Float.valueOf(queryCommandResult.getMaxScore()));
            }
            for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                SolrDocument solrDocument = solrDocumentSource.retrieve(scoreDoc);
                if (solrDocument == null) continue;
                docList.add(solrDocument);
            }
            command.add("doclist", docList);
            commands.add(entry.getKey(), command);
        }
        rb.rsp.add("grouped", commands);
    }
}

