/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.join;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.join.CrossCollectionJoinQuery;

public class CrossCollectionJoinQParser
extends QParser {
    public static final String ZK_HOST = "zkHost";
    public static final String SOLR_URL = "solrUrl";
    public static final String FROM_INDEX = "fromIndex";
    public static final String FROM = "from";
    public static final String TO = "to";
    public static final String ROUTED_BY_JOIN_KEY = "routed";
    public static final String TTL = "ttl";
    public static final int TTL_DEFAULT = 3600;
    private static final Set<String> OWN_PARAMS = new HashSet<String>(Arrays.asList("type", "v", "zkHost", "solrUrl", "fromIndex", "from", "to", "routed", "ttl"));
    private final String routerField;
    private final Set<String> allowSolrUrls;

    public CrossCollectionJoinQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req, String routerField, Set<String> allowSolrUrls) {
        super(qstr, localParams, params, req);
        this.routerField = routerField;
        this.allowSolrUrls = allowSolrUrls;
    }

    @Override
    public Query parse() throws SyntaxError {
        String query = this.localParams.get("v");
        String zkHost = this.localParams.get(ZK_HOST);
        String solrUrl = this.localParams.get(SOLR_URL);
        if (solrUrl != null) {
            if (this.allowSolrUrls == null) {
                throw new SyntaxError("allowSolrUrls list must be configured to use solrUrl parameter.");
            }
            if (!this.allowSolrUrls.contains(solrUrl)) {
                throw new SyntaxError("Solr URL was not in allowSolrUrls list.  Please check your configuration.");
            }
        }
        String collection = this.localParams.get(FROM_INDEX);
        String fromField = this.localParams.get(FROM);
        String toField = this.localParams.get(TO);
        boolean routedByJoinKey = this.localParams.getBool(ROUTED_BY_JOIN_KEY, toField.equals(this.routerField));
        int ttl = this.localParams.getInt(TTL, 3600);
        ModifiableSolrParams otherParams = new ModifiableSolrParams();
        Iterator<String> it = this.localParams.getParameterNamesIterator();
        while (it.hasNext()) {
            String paramName = it.next();
            if (OWN_PARAMS.contains(paramName)) continue;
            otherParams.set(paramName, this.localParams.getParams(paramName));
        }
        return new CrossCollectionJoinQuery(query, zkHost, solrUrl, collection, fromField, toField, routedByJoinKey, ttl, otherParams);
    }
}

