/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.join;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.util.LongBitSet;

public class MultiValueTermOrdinalCollector
extends SimpleCollector {
    private int docBase;
    private SortedSetDocValues topLevelDocValues;
    private final String fieldName;
    private final LongBitSet topLevelDocValuesBitSet;

    public MultiValueTermOrdinalCollector(String fieldName, SortedSetDocValues topLevelDocValues, LongBitSet topLevelDocValuesBitSet) {
        this.fieldName = fieldName;
        this.topLevelDocValues = topLevelDocValues;
        this.topLevelDocValuesBitSet = topLevelDocValuesBitSet;
    }

    @Override
    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    @Override
    public void doSetNextReader(LeafReaderContext context) throws IOException {
        this.docBase = context.docBase;
    }

    @Override
    public void collect(int doc) throws IOException {
        int globalDoc = this.docBase + doc;
        if (this.topLevelDocValues.advanceExact(globalDoc)) {
            long ord = -1L;
            while ((ord = this.topLevelDocValues.nextOrd()) != -1L) {
                this.topLevelDocValuesBitSet.set(ord);
            }
        }
    }
}

