/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.beans.RateLimiterPayload;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.RateLimiterConfig;
import org.apache.solr.servlet.RequestRateLimiter;
import org.apache.solr.util.SolrJacksonAnnotationInspector;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

public class QueryRateLimiter
extends RequestRateLimiter {
    private static final ObjectMapper mapper = SolrJacksonAnnotationInspector.createObjectMapper();

    public QueryRateLimiter(SolrZkClient solrZkClient) {
        super(QueryRateLimiter.constructQueryRateLimiterConfig(solrZkClient));
    }

    public void processConfigChange(Map<String, Object> properties) throws IOException {
        RateLimiterConfig rateLimiterConfig = this.getRateLimiterConfig();
        byte[] configInput = Utils.toJSON(properties.get("rate-limiters"));
        if (configInput == null || configInput.length == 0) {
            return;
        }
        RateLimiterPayload rateLimiterMeta = (RateLimiterPayload)mapper.readValue(configInput, RateLimiterPayload.class);
        QueryRateLimiter.constructQueryRateLimiterConfigInternal(rateLimiterMeta, rateLimiterConfig);
    }

    private static RateLimiterConfig constructQueryRateLimiterConfig(SolrZkClient zkClient) {
        try {
            if (zkClient == null) {
                return new RateLimiterConfig(SolrRequest.SolrRequestType.QUERY);
            }
            RateLimiterConfig rateLimiterConfig = new RateLimiterConfig(SolrRequest.SolrRequestType.QUERY);
            Map clusterPropsJson = (Map)Utils.fromJSON(zkClient.getData("/clusterprops.json", null, new Stat(), true));
            byte[] configInput = Utils.toJSON(clusterPropsJson.get("rate-limiters"));
            if (configInput.length == 0) {
                return rateLimiterConfig;
            }
            RateLimiterPayload rateLimiterMeta = (RateLimiterPayload)mapper.readValue(configInput, RateLimiterPayload.class);
            QueryRateLimiter.constructQueryRateLimiterConfigInternal(rateLimiterMeta, rateLimiterConfig);
            return rateLimiterConfig;
        }
        catch (KeeperException.NoNodeException e) {
            return new RateLimiterConfig(SolrRequest.SolrRequestType.QUERY);
        }
        catch (InterruptedException | KeeperException e) {
            throw new RuntimeException("Error reading cluster property", SolrZkClient.checkInterrupted(e));
        }
        catch (IOException e) {
            throw new RuntimeException("Encountered an IOException " + e.getMessage());
        }
    }

    private static void constructQueryRateLimiterConfigInternal(RateLimiterPayload rateLimiterMeta, RateLimiterConfig rateLimiterConfig) {
        if (rateLimiterMeta == null) {
            return;
        }
        if (rateLimiterMeta.allowedRequests != null) {
            rateLimiterConfig.allowedRequests = rateLimiterMeta.allowedRequests;
        }
        if (rateLimiterMeta.enabled != null) {
            rateLimiterConfig.isEnabled = rateLimiterMeta.enabled;
        }
        if (rateLimiterMeta.guaranteedSlots != null) {
            rateLimiterConfig.guaranteedSlotsThreshold = rateLimiterMeta.guaranteedSlots;
        }
        if (rateLimiterMeta.slotBorrowingEnabled != null) {
            rateLimiterConfig.isSlotBorrowingEnabled = rateLimiterMeta.slotBorrowingEnabled;
        }
        if (rateLimiterMeta.slotAcquisitionTimeoutInMS != null) {
            rateLimiterConfig.waitForSlotAcquisition = rateLimiterMeta.slotAcquisitionTimeoutInMS.longValue();
        }
    }
}

