/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.MergeIndexesCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUpdateProcessorFactory
extends UpdateRequestProcessorFactory
implements UpdateRequestProcessorFactory.RunAlways {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    int maxNumToLog = 10;
    int slowUpdateThresholdMillis = -1;

    @Override
    public void init(NamedList<?> args) {
        if (args != null) {
            SolrParams params = args.toSolrParams();
            this.maxNumToLog = params.getInt("maxNumToLog", this.maxNumToLog);
            this.slowUpdateThresholdMillis = params.getInt("slowUpdateThresholdMillis", this.slowUpdateThresholdMillis);
        }
    }

    @Override
    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        return log.isInfoEnabled() || this.slowUpdateThresholdMillis >= 0 ? new LogUpdateProcessor(req, rsp, this, next) : next;
    }

    static class LogUpdateProcessor
    extends UpdateRequestProcessor {
        private final SolrQueryRequest req;
        private final SolrQueryResponse rsp;
        private final NamedList<Object> toLog;
        int numAdds;
        int numDeletes;
        private List<String> adds;
        private List<String> deletes;
        private final int maxNumToLog;
        private final int slowUpdateThresholdMillis;
        private final boolean logDebug = log.isDebugEnabled();

        public LogUpdateProcessor(SolrQueryRequest req, SolrQueryResponse rsp, LogUpdateProcessorFactory factory, UpdateRequestProcessor next) {
            super(next);
            this.req = req;
            this.rsp = rsp;
            this.maxNumToLog = factory.maxNumToLog;
            this.slowUpdateThresholdMillis = factory.slowUpdateThresholdMillis;
            this.toLog = new SimpleOrderedMap<Object>();
        }

        @Override
        public void processAdd(AddUpdateCommand cmd) throws IOException {
            if (this.logDebug) {
                log.debug("PRE_UPDATE {} {}", (Object)cmd, (Object)this.req);
            }
            if (this.next != null) {
                this.next.processAdd(cmd);
            }
            if (this.adds == null) {
                this.adds = new ArrayList<String>();
                this.toLog.add("add", this.adds);
            }
            if (this.adds.size() < this.maxNumToLog) {
                long version = cmd.getVersion();
                Object msg = cmd.getPrintableId();
                if (version != 0L) {
                    msg = (String)msg + " (" + version + ")";
                }
                this.adds.add((String)msg);
            }
            ++this.numAdds;
        }

        @Override
        public void processDelete(DeleteUpdateCommand cmd) throws IOException {
            if (this.logDebug) {
                log.debug("PRE_UPDATE {} {}", (Object)cmd, (Object)this.req);
            }
            if (this.next != null) {
                this.next.processDelete(cmd);
            }
            if (cmd.isDeleteById()) {
                if (this.deletes == null) {
                    this.deletes = new ArrayList<String>();
                    this.toLog.add("delete", this.deletes);
                }
                if (this.deletes.size() < this.maxNumToLog) {
                    long version = cmd.getVersion();
                    Object msg = cmd.getId();
                    if (version != 0L) {
                        msg = (String)msg + " (" + version + ")";
                    }
                    this.deletes.add((String)msg);
                }
            } else if (this.toLog.size() < this.maxNumToLog) {
                long version = cmd.getVersion();
                Object msg = cmd.query;
                if (version != 0L) {
                    msg = (String)msg + " (" + version + ")";
                }
                this.toLog.add("deleteByQuery", msg);
            }
            ++this.numDeletes;
        }

        @Override
        public void processMergeIndexes(MergeIndexesCommand cmd) throws IOException {
            if (this.logDebug) {
                log.debug("PRE_UPDATE {} {}", (Object)cmd, (Object)this.req);
            }
            if (this.next != null) {
                this.next.processMergeIndexes(cmd);
            }
            this.toLog.add("mergeIndexes", cmd.toString());
        }

        @Override
        public void processCommit(CommitUpdateCommand cmd) throws IOException {
            if (this.logDebug) {
                log.debug("PRE_UPDATE {} {}", (Object)cmd, (Object)this.req);
            }
            if (this.next != null) {
                this.next.processCommit(cmd);
            }
            String msg = cmd.optimize ? "optimize" : "commit";
            this.toLog.add(msg, "");
        }

        @Override
        public void processRollback(RollbackUpdateCommand cmd) throws IOException {
            if (this.logDebug) {
                log.debug("PRE_UPDATE {} {}", (Object)cmd, (Object)this.req);
            }
            if (this.next != null) {
                this.next.processRollback(cmd);
            }
            this.toLog.add("rollback", "");
        }

        @Override
        public void finish() throws IOException {
            long elapsed;
            if (this.logDebug) {
                log.debug("PRE_UPDATE FINISH {}", (Object)this.req);
            }
            if (this.next != null) {
                this.next.finish();
            }
            if (log.isInfoEnabled()) {
                log.info(this.getLogStringAndClearRspToLog());
            }
            if (log.isWarnEnabled() && this.slowUpdateThresholdMillis >= 0 && (elapsed = (long)this.req.getRequestTimer().getTime()) >= (long)this.slowUpdateThresholdMillis) {
                log.warn("slow: {}", (Object)this.getLogStringAndClearRspToLog());
            }
        }

        private String getLogStringAndClearRspToLog() {
            StringBuilder sb = new StringBuilder(this.rsp.getToLogAsString());
            this.rsp.getToLog().clear();
            if (this.adds != null && this.numAdds > this.maxNumToLog) {
                this.adds.add("... (" + this.numAdds + " adds)");
            }
            if (this.deletes != null && this.numDeletes > this.maxNumToLog) {
                this.deletes.add("... (" + this.numDeletes + " deletes)");
            }
            long elapsed = (long)this.req.getRequestTimer().getTime();
            sb.append(this.toLog).append(" 0 ").append(elapsed);
            return sb.toString();
        }
    }
}

