/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.solr.cluster.api.SimpleMap;
import org.apache.solr.common.ConfigNode;
import org.apache.solr.common.util.DOMUtil;
import org.apache.solr.common.util.WrappedSimpleMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMConfigNode
implements ConfigNode {
    private final Node node;
    SimpleMap<String> attrs;
    private static final SimpleMap<String> EMPTY = new WrappedSimpleMap(Collections.emptyMap());

    @Override
    public String name() {
        return this.node.getNodeName();
    }

    @Override
    public String txt() {
        return DOMUtil.getText(this.node);
    }

    public DOMConfigNode(Node node) {
        this.node = node;
    }

    @Override
    public SimpleMap<String> attributes() {
        if (this.attrs != null) {
            return this.attrs;
        }
        Map<String, String> attrs = DOMUtil.toMap(this.node.getAttributes());
        this.attrs = attrs.size() == 0 ? EMPTY : new WrappedSimpleMap<String>(attrs);
        return this.attrs;
    }

    @Override
    public ConfigNode child(String name) {
        Node n = DOMUtil.getChild(this.node, name);
        return n == null ? null : new DOMConfigNode(n);
    }

    @Override
    public List<ConfigNode> getAll(String name) {
        ArrayList<ConfigNode> result = new ArrayList<ConfigNode>();
        this.forEachChild(it -> {
            if (name.equals(it.name())) {
                result.add((ConfigNode)it);
            }
            return Boolean.TRUE;
        });
        return result;
    }

    @Override
    public void forEachChild(Function<ConfigNode, Boolean> fun) {
        Boolean toContinue;
        Node item;
        NodeList nlst = this.node.getChildNodes();
        for (int i = 0; !(i >= nlst.getLength() || (item = nlst.item(i)).getNodeType() == 1 && Boolean.FALSE.equals(toContinue = fun.apply(new DOMConfigNode(item)))); ++i) {
        }
    }
}

