/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.solr.cluster.api.SimpleMap;
import org.apache.solr.common.ConfigNode;
import org.apache.solr.common.util.PropertiesUtil;
import org.apache.solr.common.util.WrappedSimpleMap;

public class DataConfigNode
implements ConfigNode {
    public final String name;
    public final SimpleMap<String> attributes;
    public final SimpleMap<List<ConfigNode>> kids;
    public final String textData;
    public static final SimpleMap<List<ConfigNode>> EMPTY = new WrappedSimpleMap(Collections.emptyMap());

    public DataConfigNode(ConfigNode root) {
        LinkedHashMap kids = new LinkedHashMap();
        this.name = root.name();
        this.attributes = this.wrap(root.attributes());
        this.textData = root.txt();
        root.forEachChild(it -> {
            List nodes = kids.computeIfAbsent(it.name(), k -> new ArrayList());
            nodes.add(new DataConfigNode((ConfigNode)it));
            return Boolean.TRUE;
        });
        for (Map.Entry entry : kids.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.setValue(List.copyOf((Collection)entry.getValue()));
        }
        this.kids = kids.isEmpty() ? EMPTY : new WrappedSimpleMap(Map.copyOf(kids));
    }

    public String subtituteVal(String s) {
        return PropertiesUtil.substitute(s, (Function)SUBSTITUTES.get());
    }

    private SimpleMap<String> wrap(final SimpleMap<String> delegate) {
        if (delegate.size() == 0) {
            return delegate;
        }
        return new SimpleMap<String>(){

            @Override
            public String get(String key) {
                return DataConfigNode.this.subtituteVal((String)delegate.get(key));
            }

            @Override
            public void forEachEntry(BiConsumer<String, ? super String> fun) {
                delegate.forEachEntry((String k, ? super T v) -> fun.accept((String)k, DataConfigNode.this.subtituteVal((String)v)));
            }

            @Override
            public int size() {
                return delegate.size();
            }
        };
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String txt() {
        return this.subtituteVal(this.textData);
    }

    @Override
    public SimpleMap<String> attributes() {
        return this.attributes;
    }

    @Override
    public ConfigNode child(String name) {
        List<ConfigNode> val = this.kids.get(name);
        return val == null || val.isEmpty() ? null : val.get(0);
    }

    @Override
    public List<ConfigNode> getAll(String name) {
        return this.kids.get(name, Collections.emptyList());
    }

    @Override
    public List<ConfigNode> getAll(Predicate<ConfigNode> test, Set<String> matchNames) {
        ArrayList<ConfigNode> result = new ArrayList<ConfigNode>();
        for (String s : matchNames) {
            List<ConfigNode> vals = this.kids.get(s);
            if (vals == null) continue;
            vals.forEach(it -> {
                if (test == null || test.test((ConfigNode)it)) {
                    result.add((ConfigNode)it);
                }
            });
        }
        return result;
    }

    @Override
    public void forEachChild(Function<ConfigNode, Boolean> fun) {
        this.kids.forEachEntry((s, configNodes) -> {
            if (configNodes != null) {
                configNodes.forEach(fun::apply);
            }
        });
    }
}

