/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.solr.common.util.CollectionUtil;

public class MapListener<K, V>
implements Map<K, V> {
    private final Map<K, V> target;
    private final Set<K> seenKeys;

    public MapListener(Map<K, V> target) {
        this.target = target;
        this.seenKeys = CollectionUtil.newHashSet(target.size());
    }

    public Set<K> getSeenKeys() {
        return this.seenKeys;
    }

    @Override
    public int size() {
        return this.target.size();
    }

    @Override
    public boolean isEmpty() {
        return this.target.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.target.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.target.containsValue(value);
    }

    @Override
    public V get(Object key) {
        this.seenKeys.add(key);
        return this.target.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.target.put(key, value);
    }

    @Override
    public V remove(Object key) {
        this.seenKeys.add(key);
        return this.target.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.target.putAll(m);
    }

    @Override
    public void clear() {
        this.target.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.target.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.target.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.target.entrySet();
    }
}

