/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenFilterFactory;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.payloads.DelimitedPayloadTokenFilterFactory;
import org.apache.lucene.analysis.payloads.NumericPayloadTokenFilterFactory;
import org.apache.lucene.analysis.payloads.PayloadHelper;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.payloads.AveragePayloadFunction;
import org.apache.lucene.queries.payloads.MaxPayloadFunction;
import org.apache.lucene.queries.payloads.MinPayloadFunction;
import org.apache.lucene.queries.payloads.PayloadDecoder;
import org.apache.lucene.queries.payloads.PayloadFunction;
import org.apache.lucene.queries.payloads.SumPayloadFunction;
import org.apache.lucene.queries.spans.SpanNearQuery;
import org.apache.lucene.queries.spans.SpanOrQuery;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.queries.spans.SpanTermQuery;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.schema.FieldType;

public class PayloadUtils {
    public static String getPayloadEncoder(FieldType fieldType) {
        String encoder = null;
        Analyzer a = fieldType.getIndexAnalyzer();
        if (a instanceof TokenizerChain) {
            TokenFilterFactory[] factories;
            TokenizerChain tc = (TokenizerChain)a;
            for (TokenFilterFactory factory : factories = tc.getTokenFilterFactories()) {
                if (factory instanceof DelimitedPayloadTokenFilterFactory) {
                    encoder = factory.getOriginalArgs().get("encoder");
                    break;
                }
                if (!(factory instanceof NumericPayloadTokenFilterFactory)) continue;
                encoder = "float";
                break;
            }
        }
        return encoder;
    }

    public static PayloadDecoder getPayloadDecoder(FieldType fieldType) {
        PayloadDecoder decoder = null;
        String encoder = PayloadUtils.getPayloadEncoder(fieldType);
        if ("integer".equals(encoder)) {
            decoder = payload -> payload == null ? 1.0f : (float)PayloadHelper.decodeInt(payload.bytes, payload.offset);
        }
        if ("float".equals(encoder)) {
            decoder = payload -> payload == null ? 1.0f : PayloadHelper.decodeFloat(payload.bytes, payload.offset);
        }
        return decoder;
    }

    public static PayloadFunction getPayloadFunction(String func) {
        PayloadFunction payloadFunction = null;
        if ("min".equals(func)) {
            payloadFunction = new MinPayloadFunction();
        }
        if ("max".equals(func)) {
            payloadFunction = new MaxPayloadFunction();
        }
        if ("average".equals(func)) {
            payloadFunction = new AveragePayloadFunction();
        }
        if ("sum".equals(func)) {
            payloadFunction = new SumPayloadFunction();
        }
        return payloadFunction;
    }

    public static SpanQuery createSpanQuery(String field, String value, Analyzer analyzer) throws IOException {
        return PayloadUtils.createSpanQuery(field, value, analyzer, "phrase");
    }

    public static SpanQuery createSpanQuery(String field, String value, Analyzer analyzer, String operator) throws IOException {
        ArrayList<SpanTermQuery> terms = new ArrayList<SpanTermQuery>();
        try (TokenStream in = analyzer.tokenStream(field, value);){
            in.reset();
            TermToBytesRefAttribute termAtt = in.getAttribute(TermToBytesRefAttribute.class);
            while (in.incrementToken()) {
                terms.add(new SpanTermQuery(new Term(field, termAtt.getBytesRef())));
            }
            in.end();
        }
        SpanQuery query = terms.isEmpty() ? null : (terms.size() == 1 ? (SpanQuery)terms.get(0) : (operator != null && operator.equalsIgnoreCase("or") ? new SpanOrQuery(terms.toArray(new SpanTermQuery[0])) : new SpanNearQuery(terms.toArray(new SpanTermQuery[0]), 0, true)));
        return query;
    }
}

