/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import org.noggit.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordingJSONParser
extends JSONParser {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static ThreadLocal<char[]> buf = new ThreadLocal();
    private final char[] bufCopy;
    private long globalPosition = 0L;
    private StringBuilder sb = new StringBuilder();
    private boolean objectStarted = false;
    private long lastMarkedPosition = 0L;
    private long lastGlobalPosition = 0L;
    private static final int BUFFER_SIZE = 8192;

    public RecordingJSONParser(Reader in) {
        super(in, RecordingJSONParser.getChars());
        this.bufCopy = buf.get();
        buf.remove();
    }

    static char[] getChars() {
        buf.set(new char[8192]);
        return buf.get();
    }

    private void recordChar(int aChar) {
        if (this.objectStarted) {
            this.sb.append((char)aChar);
        } else if (aChar == 123) {
            this.sb.append((char)aChar);
            this.objectStarted = true;
        }
    }

    public void resetBuf() {
        this.sb = new StringBuilder();
        this.objectStarted = false;
    }

    @Override
    public int nextEvent() throws IOException {
        this.captureMissing();
        return super.nextEvent();
    }

    private void captureMissing() {
        long currPosition = this.getPosition() - this.globalPosition;
        if (currPosition < 0L) {
            log.error("currPosition less than zero in captureMissing()?");
        }
        if (currPosition > this.lastMarkedPosition) {
            for (long i = this.lastMarkedPosition; i < currPosition; ++i) {
                this.recordChar(this.bufCopy[(int)i]);
            }
        } else if (currPosition < this.lastMarkedPosition) {
            for (long i = 0L; i < currPosition; ++i) {
                this.recordChar(this.bufCopy[(int)i]);
            }
        } else if (currPosition == 8192L && this.lastGlobalPosition != this.globalPosition) {
            for (long i = 0L; i < currPosition; ++i) {
                this.recordChar(this.bufCopy[(int)i]);
            }
        }
        this.lastGlobalPosition = this.globalPosition;
        this.lastMarkedPosition = currPosition;
    }

    @Override
    protected void fill() throws IOException {
        this.captureMissing();
        super.fill();
        this.globalPosition = this.getPosition();
    }

    public String getBuf() {
        this.captureMissing();
        if (this.sb != null) {
            return this.sb.toString();
        }
        return null;
    }

    public JSONParser.ParseException error(String msg) {
        return this.err(msg);
    }
}

