/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.index.IndexWriter;
import org.apache.solr.common.NonExistentCoreException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.Pair;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.util.RefCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestInjection {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Pattern ENABLED_PERCENT = Pattern.compile("(true|false)(?:\\:(\\d+))?$", 2);
    private static final String LUCENE_TEST_CASE_FQN = "org.apache.lucene.tests.util.LuceneTestCase";
    private static final Class<?> LUCENE_TEST_CASE;
    public static volatile String nonGracefullClose;
    public static volatile String failReplicaRequests;
    public static volatile String failUpdateRequests;
    public static volatile String leaderTragedy;
    public static volatile String nonExistentCoreExceptionAfterUnload;
    public static volatile String updateLogReplayRandomPause;
    public static volatile String updateRandomPause;
    public static volatile String prepRecoveryOpPauseForever;
    public static volatile String randomDelayInCoreCreation;
    public static volatile int randomDelayMaxInCoreCreationInSec;
    public static volatile String splitFailureBeforeReplicaCreation;
    public static volatile String splitFailureAfterReplicaCreation;
    public static volatile CountDownLatch splitLatch;
    public static volatile CountDownLatch directUpdateLatch;
    public static volatile CountDownLatch reindexLatch;
    public static volatile String reindexFailure;
    public static volatile String failIndexFingerprintRequests;
    public static volatile String wrongIndexFingerprint;
    private static volatile Set<Timer> timers;
    private static volatile AtomicInteger countPrepRecoveryOpPauseForever;
    public static volatile Integer delayBeforeFollowerCommitRefresh;
    public static volatile Integer delayInExecutePlanAction;
    public static volatile Integer delayBeforeCreatingNewDocSet;
    public static volatile AtomicInteger countDocSetDelays;
    public static volatile boolean failInExecutePlanAction;
    public static volatile boolean skipIndexWriterCommitOnClose;
    public static volatile boolean uifOutOfMemoryError;
    private static volatile CountDownLatch notifyPauseForeverDone;
    static Set<Hook> newSearcherHooks;

    static Random random() {
        if (null == LUCENE_TEST_CASE) {
            return null;
        }
        try {
            Method randomMethod = LUCENE_TEST_CASE.getMethod("random", new Class[0]);
            return (Random)randomMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to use reflection to invoke LuceneTestCase.random()", e);
        }
    }

    public static void notifyPauseForeverDone() {
        notifyPauseForeverDone.countDown();
        notifyPauseForeverDone = new CountDownLatch(1);
    }

    public static void reset() {
        nonGracefullClose = null;
        failReplicaRequests = null;
        failUpdateRequests = null;
        leaderTragedy = null;
        nonExistentCoreExceptionAfterUnload = null;
        updateLogReplayRandomPause = null;
        updateRandomPause = null;
        randomDelayInCoreCreation = null;
        splitFailureBeforeReplicaCreation = null;
        splitFailureAfterReplicaCreation = null;
        splitLatch = null;
        directUpdateLatch = null;
        reindexLatch = null;
        reindexFailure = null;
        prepRecoveryOpPauseForever = null;
        countPrepRecoveryOpPauseForever = new AtomicInteger(0);
        failIndexFingerprintRequests = null;
        wrongIndexFingerprint = null;
        delayBeforeFollowerCommitRefresh = null;
        delayInExecutePlanAction = null;
        delayBeforeCreatingNewDocSet = null;
        countDocSetDelays.set(0);
        failInExecutePlanAction = false;
        skipIndexWriterCommitOnClose = false;
        uifOutOfMemoryError = false;
        TestInjection.notifyPauseForeverDone();
        newSearcherHooks.clear();
        for (Timer timer : timers) {
            timer.cancel();
        }
    }

    public static boolean injectWrongIndexFingerprint() {
        if (wrongIndexFingerprint != null) {
            Random rand = TestInjection.random();
            if (null == rand) {
                return true;
            }
            Pair<Boolean, Integer> pair = TestInjection.parseValue(wrongIndexFingerprint);
            boolean enabled = pair.first();
            int chanceIn100 = pair.second();
            if (enabled && rand.nextInt(100) >= 100 - chanceIn100) {
                return true;
            }
        }
        return false;
    }

    public static boolean injectFailIndexFingerprintRequests() {
        if (failIndexFingerprintRequests != null) {
            Random rand = TestInjection.random();
            if (null == rand) {
                return true;
            }
            Pair<Boolean, Integer> pair = TestInjection.parseValue(failIndexFingerprintRequests);
            boolean enabled = pair.first();
            int chanceIn100 = pair.second();
            if (enabled && rand.nextInt(100) >= 100 - chanceIn100) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Random test index fingerprint fail");
            }
        }
        return true;
    }

    public static boolean injectRandomDelayInCoreCreation() {
        if (randomDelayInCoreCreation != null) {
            Random rand = TestInjection.random();
            if (null == rand) {
                return true;
            }
            Pair<Boolean, Integer> pair = TestInjection.parseValue(randomDelayInCoreCreation);
            boolean enabled = pair.first();
            int chanceIn100 = pair.second();
            if (enabled && rand.nextInt(100) >= 100 - chanceIn100) {
                int delay = rand.nextInt(randomDelayMaxInCoreCreationInSec);
                log.info("Inject random core creation delay of {}s", (Object)delay);
                try {
                    Thread.sleep((long)delay * 1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return true;
    }

    public static boolean injectNonGracefullClose(CoreContainer cc) {
        if (cc.isShutDown() && nonGracefullClose != null) {
            Random rand = TestInjection.random();
            if (null == rand) {
                return true;
            }
            Pair<Boolean, Integer> pair = TestInjection.parseValue(nonGracefullClose);
            boolean enabled = pair.first();
            int chanceIn100 = pair.second();
            if (enabled && rand.nextInt(100) >= 100 - chanceIn100) {
                if (rand.nextBoolean()) {
                    throw new TestShutdownFailError("Test exception for non graceful close");
                }
                final Timer timer = new Timer();
                final Thread cthread = Thread.currentThread();
                TimerTask task = new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            Random taskRand = TestInjection.random();
                            Thread.sleep(taskRand.nextInt(1000));
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        cthread.interrupt();
                        timers.remove(timer);
                    }
                };
                timers.add(timer);
                timer.schedule(task, rand.nextInt(500));
            }
        }
        return true;
    }

    public static boolean injectSkipIndexWriterCommitOnClose(Object indexWriter) {
        if (skipIndexWriterCommitOnClose) {
            log.info("Inject failure: skipIndexWriterCommitOnClose={}: {}", (Object)skipIndexWriterCommitOnClose, indexWriter);
        }
        return skipIndexWriterCommitOnClose;
    }

    public static boolean injectFailReplicaRequests() {
        if (failReplicaRequests != null) {
            Random rand = TestInjection.random();
            if (null == rand) {
                return true;
            }
            Pair<Boolean, Integer> pair = TestInjection.parseValue(failReplicaRequests);
            boolean enabled = pair.first();
            int chanceIn100 = pair.second();
            if (enabled && rand.nextInt(100) >= 100 - chanceIn100) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Random test update fail");
            }
        }
        return true;
    }

    public static boolean injectFailUpdateRequests() {
        if (failUpdateRequests != null) {
            Random rand = TestInjection.random();
            if (null == rand) {
                return true;
            }
            Pair<Boolean, Integer> pair = TestInjection.parseValue(failUpdateRequests);
            boolean enabled = pair.first();
            int chanceIn100 = pair.second();
            if (enabled && rand.nextInt(100) >= 100 - chanceIn100) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Random test update fail");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean injectLeaderTragedy(SolrCore core) {
        if (leaderTragedy != null) {
            Random rand = TestInjection.random();
            if (null == rand) {
                return true;
            }
            Pair<Boolean, Integer> pair = TestInjection.parseValue(leaderTragedy);
            boolean enabled = pair.first();
            int chanceIn100 = pair.second();
            if (!core.getCoreDescriptor().getCloudDescriptor().isLeader()) {
                return true;
            }
            if (enabled && rand.nextInt(100) >= 100 - chanceIn100) {
                RefCounted<IndexWriter> writer = null;
                try {
                    writer = core.getSolrCoreState().getIndexWriter(null);
                    writer.get().onTragicEvent(new Exception("injected tragedy"), "injection");
                }
                catch (IOException e) {
                    boolean bl = true;
                    return bl;
                }
                finally {
                    if (writer != null) {
                        writer.decref();
                    }
                }
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Random tragedy fail");
            }
        }
        return true;
    }

    public static boolean injectNonExistentCoreExceptionAfterUnload(String cname) {
        if (nonExistentCoreExceptionAfterUnload != null) {
            Random rand = TestInjection.random();
            if (null == rand) {
                return true;
            }
            Pair<Boolean, Integer> pair = TestInjection.parseValue(nonExistentCoreExceptionAfterUnload);
            boolean enabled = pair.first();
            int chanceIn100 = pair.second();
            if (enabled && rand.nextInt(100) >= 100 - chanceIn100) {
                throw new NonExistentCoreException("Core not found to unload: " + cname);
            }
        }
        return true;
    }

    public static boolean injectUpdateLogReplayRandomPause() {
        if (updateLogReplayRandomPause != null) {
            Random rand = TestInjection.random();
            if (null == rand) {
                return true;
            }
            Pair<Boolean, Integer> pair = TestInjection.parseValue(updateLogReplayRandomPause);
            boolean enabled = pair.first();
            int chanceIn100 = pair.second();
            if (enabled && rand.nextInt(100) >= 100 - chanceIn100) {
                long rndTime = rand.nextInt(1000);
                log.info("inject random log replay delay of {}ms", (Object)rndTime);
                try {
                    Thread.sleep(rndTime);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return true;
    }

    public static boolean injectUpdateRandomPause() {
        if (updateRandomPause != null) {
            Random rand = TestInjection.random();
            if (null == rand) {
                return true;
            }
            Pair<Boolean, Integer> pair = TestInjection.parseValue(updateRandomPause);
            boolean enabled = pair.first();
            int chanceIn100 = pair.second();
            if (enabled && rand.nextInt(100) >= 100 - chanceIn100) {
                long rndTime = rand.nextInt(10) > 2 ? (long)rand.nextInt(300) : (long)rand.nextInt(1000);
                log.info("inject random update delay of {}ms", (Object)rndTime);
                try {
                    Thread.sleep(rndTime);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return true;
    }

    public static boolean injectPrepRecoveryOpPauseForever() {
        String val = prepRecoveryOpPauseForever;
        if (val != null) {
            Random rand = TestInjection.random();
            if (null == rand) {
                return true;
            }
            Pair<Boolean, Integer> pair = TestInjection.parseValue(val);
            boolean enabled = pair.first();
            int chanceIn100 = pair.second();
            if (enabled && rand.nextInt(100) >= 100 - chanceIn100 && countPrepRecoveryOpPauseForever.get() < 1) {
                countPrepRecoveryOpPauseForever.incrementAndGet();
                log.info("inject pause forever for prep recovery op");
                try {
                    notifyPauseForeverDone.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            } else {
                countPrepRecoveryOpPauseForever.set(0);
            }
        }
        return true;
    }

    private static boolean injectSplitFailure(String probability, String label) {
        if (probability != null) {
            Random rand = TestInjection.random();
            if (null == rand) {
                return true;
            }
            Pair<Boolean, Integer> pair = TestInjection.parseValue(probability);
            boolean enabled = pair.first();
            int chanceIn100 = pair.second();
            if (enabled && rand.nextInt(100) >= 100 - chanceIn100) {
                log.info("Injecting failure: {}", (Object)label);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error: " + label);
            }
        }
        return true;
    }

    public static boolean injectSplitFailureBeforeReplicaCreation() {
        return TestInjection.injectSplitFailure(splitFailureBeforeReplicaCreation, "before creating replica for sub-shard");
    }

    public static boolean injectSplitFailureAfterReplicaCreation() {
        return TestInjection.injectSplitFailure(splitFailureAfterReplicaCreation, "after creating replica for sub-shard");
    }

    public static boolean injectSplitLatch() {
        if (splitLatch != null) {
            try {
                log.info("Waiting in ReplicaMutator for up to 60s");
                return splitLatch.await(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return true;
    }

    public static boolean injectDirectUpdateLatch() {
        if (directUpdateLatch != null) {
            try {
                log.info("Waiting in DirectUpdateHandler2 for up to 60s");
                return directUpdateLatch.await(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return true;
    }

    public static boolean injectReindexFailure() {
        if (reindexFailure != null) {
            Random rand = TestInjection.random();
            if (null == rand) {
                return true;
            }
            Pair<Boolean, Integer> pair = TestInjection.parseValue(reindexFailure);
            boolean enabled = pair.first();
            int chanceIn100 = pair.second();
            if (enabled && rand.nextInt(100) >= 100 - chanceIn100) {
                log.info("Test injection failure");
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Test injection failure");
            }
        }
        return true;
    }

    public static boolean injectReindexLatch() {
        if (reindexLatch != null) {
            try {
                log.info("Waiting in ReindexCollectionCmd for up to 60s");
                return reindexLatch.await(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return true;
    }

    private static Pair<Boolean, Integer> parseValue(String raw) {
        if (raw == null) {
            return new Pair<Boolean, Integer>(false, 0);
        }
        Matcher m = ENABLED_PERCENT.matcher(raw);
        if (!m.matches()) {
            throw new RuntimeException("No match, probably bad syntax: " + raw);
        }
        String val = m.group(1);
        String percent = "100";
        if (m.groupCount() == 2) {
            percent = m.group(2);
        }
        return new Pair<Boolean, Integer>(Boolean.parseBoolean(val), Integer.parseInt(percent));
    }

    public static boolean injectDelayBeforeFollowerCommitRefresh() {
        if (delayBeforeFollowerCommitRefresh != null) {
            try {
                log.info("Pausing IndexFetcher for {}ms", (Object)delayBeforeFollowerCommitRefresh);
                Thread.sleep(delayBeforeFollowerCommitRefresh.intValue());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return true;
    }

    public static boolean injectUIFOutOfMemoryError() {
        if (uifOutOfMemoryError) {
            throw new OutOfMemoryError("Test Injection");
        }
        return true;
    }

    public static boolean injectDocSetDelay(Object query) {
        if (delayBeforeCreatingNewDocSet != null) {
            countDocSetDelays.incrementAndGet();
            try {
                log.info("Pausing DocSet for {}ms: {}", (Object)delayBeforeCreatingNewDocSet, query);
                if (log.isDebugEnabled()) {
                    log.debug("", (Throwable)new Exception("Stack Trace"));
                }
                Thread.sleep(delayBeforeCreatingNewDocSet.intValue());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return true;
    }

    public static boolean newSearcherHook(Hook hook) {
        newSearcherHooks.add(hook);
        return true;
    }

    public static boolean injectSearcherHooks(String collectionName) {
        for (Hook hook : newSearcherHooks) {
            hook.newSearcher(collectionName);
        }
        return true;
    }

    static {
        Class<?> nonFinalTemp = null;
        try {
            ClassLoader classLoader = MethodHandles.lookup().lookupClass().getClassLoader();
            nonFinalTemp = classLoader.loadClass(LUCENE_TEST_CASE_FQN);
        }
        catch (ClassNotFoundException e) {
            log.debug("TestInjection methods will all be No-Ops since LuceneTestCase not found");
        }
        LUCENE_TEST_CASE = nonFinalTemp;
        nonGracefullClose = null;
        failReplicaRequests = null;
        failUpdateRequests = null;
        leaderTragedy = null;
        nonExistentCoreExceptionAfterUnload = null;
        updateLogReplayRandomPause = null;
        updateRandomPause = null;
        prepRecoveryOpPauseForever = null;
        randomDelayInCoreCreation = null;
        randomDelayMaxInCoreCreationInSec = 10;
        splitFailureBeforeReplicaCreation = null;
        splitFailureAfterReplicaCreation = null;
        splitLatch = null;
        directUpdateLatch = null;
        reindexLatch = null;
        reindexFailure = null;
        failIndexFingerprintRequests = null;
        wrongIndexFingerprint = null;
        timers = Collections.synchronizedSet(new HashSet());
        countPrepRecoveryOpPauseForever = new AtomicInteger(0);
        delayBeforeFollowerCommitRefresh = null;
        delayInExecutePlanAction = null;
        delayBeforeCreatingNewDocSet = null;
        countDocSetDelays = new AtomicInteger(0);
        failInExecutePlanAction = false;
        skipIndexWriterCommitOnClose = false;
        uifOutOfMemoryError = false;
        notifyPauseForeverDone = new CountDownLatch(1);
        newSearcherHooks = ConcurrentHashMap.newKeySet();
    }

    public static interface Hook {
        public void newSearcher(String var1);

        public void waitForSearcher(String var1, int var2, int var3, boolean var4) throws InterruptedException;
    }

    public static class TestShutdownFailError
    extends OutOfMemoryError {
        public TestShutdownFailError(String msg) {
            super(msg);
        }
    }
}

