/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.coyote.http2.AbstractStream;
import org.apache.coyote.http2.FrameType;
import org.apache.coyote.http2.Http2Exception;
import org.apache.coyote.http2.Stream;
import org.apache.coyote.http2.StreamStateMachine;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

abstract class AbstractNonZeroStream
extends AbstractStream {
    private static final Log log = LogFactory.getLog(AbstractNonZeroStream.class);
    private static final StringManager sm = StringManager.getManager(AbstractNonZeroStream.class);
    protected static final ByteBuffer ZERO_LENGTH_BYTEBUFFER = ByteBuffer.allocate(0);
    protected final StreamStateMachine state;
    private volatile int weight = 16;

    AbstractNonZeroStream(String connectionId, Integer identifier) {
        super(identifier);
        this.state = new StreamStateMachine(connectionId, this.getIdAsString());
    }

    AbstractNonZeroStream(Integer identifier, StreamStateMachine state) {
        super(identifier);
        this.state = state;
    }

    @Override
    final int getWeight() {
        return this.weight;
    }

    final void rePrioritise(AbstractStream parent, boolean exclusive, int weight) {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("stream.reprioritisation.debug", this.getConnectionId(), this.getIdAsString(), Boolean.toString(exclusive), parent.getIdAsString(), Integer.toString(weight)));
        }
        if (this.isDescendant(parent)) {
            parent.detachFromParent();
            this.getParentStream().addChild((Stream)parent);
        }
        if (exclusive) {
            Iterator<AbstractNonZeroStream> parentsChildren = parent.getChildStreams().iterator();
            while (parentsChildren.hasNext()) {
                AbstractNonZeroStream parentsChild = parentsChildren.next();
                parentsChildren.remove();
                this.addChild(parentsChild);
            }
        }
        this.detachFromParent();
        parent.addChild(this);
        this.weight = weight;
    }

    final void rePrioritise(AbstractStream parent, int weight) {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("stream.reprioritisation.debug", this.getConnectionId(), this.getIdAsString(), Boolean.FALSE, parent.getIdAsString(), Integer.toString(weight)));
        }
        parent.addChild(this);
        this.weight = weight;
    }

    void replaceStream(AbstractNonZeroStream replacement) {
        this.getParentStream().addChild(replacement);
        this.detachFromParent();
        for (AbstractNonZeroStream child : this.getChildStreams()) {
            replacement.addChild(child);
        }
        this.getChildStreams().clear();
        replacement.weight = this.weight;
    }

    final boolean isClosedFinal() {
        return this.state.isClosedFinal();
    }

    final void checkState(FrameType frameType) throws Http2Exception {
        this.state.checkFrameType(frameType);
    }

    abstract ByteBuffer getInputByteBuffer();

    abstract void receivedData(int var1) throws Http2Exception;
}

