/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.ObjectName;
import org.apache.catalina.Engine;
import org.apache.catalina.Executor;
import org.apache.catalina.JmxEnabled;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.mapper.Mapper;
import org.apache.catalina.mapper.MapperListener;
import org.apache.catalina.util.LifecycleBase;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class StandardService
extends LifecycleMBeanBase
implements Service {
    private static final Log log = LogFactory.getLog(StandardService.class);
    private static final StringManager sm = StringManager.getManager(StandardService.class);
    private String name = null;
    private Server server = null;
    protected final PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected Connector[] connectors = new Connector[0];
    private final ReadWriteLock connectorsLock = new ReentrantReadWriteLock();
    protected final ArrayList<Executor> executors = new ArrayList();
    private final ReadWriteLock executorsLock = new ReentrantReadWriteLock();
    private Engine engine = null;
    private ClassLoader parentClassLoader = null;
    protected final Mapper mapper = new Mapper();
    protected final MapperListener mapperListener = new MapperListener(this);
    private long gracefulStopAwaitMillis = 0L;

    public long getGracefulStopAwaitMillis() {
        return this.gracefulStopAwaitMillis;
    }

    public void setGracefulStopAwaitMillis(long gracefulStopAwaitMillis) {
        this.gracefulStopAwaitMillis = gracefulStopAwaitMillis;
    }

    @Override
    public Mapper getMapper() {
        return this.mapper;
    }

    @Override
    public Engine getContainer() {
        return this.engine;
    }

    @Override
    public void setContainer(Engine engine) {
        Engine oldEngine = this.engine;
        if (oldEngine != null) {
            oldEngine.setService(null);
        }
        this.engine = engine;
        if (this.engine != null) {
            this.engine.setService(this);
        }
        if (this.getState().isAvailable()) {
            if (this.engine != null) {
                try {
                    this.engine.start();
                }
                catch (LifecycleException e) {
                    log.error((Object)sm.getString("standardService.engine.startFailed"), (Throwable)e);
                }
            }
            try {
                this.mapperListener.stop();
            }
            catch (LifecycleException e) {
                log.error((Object)sm.getString("standardService.mapperListener.stopFailed"), (Throwable)e);
            }
            try {
                this.mapperListener.start();
            }
            catch (LifecycleException e) {
                log.error((Object)sm.getString("standardService.mapperListener.startFailed"), (Throwable)e);
            }
            if (oldEngine != null) {
                try {
                    oldEngine.stop();
                }
                catch (LifecycleException e) {
                    log.error((Object)sm.getString("standardService.engine.stopFailed"), (Throwable)e);
                }
            }
        }
        this.support.firePropertyChange("container", oldEngine, this.engine);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public void setServer(Server server) {
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnector(Connector connector) {
        Lock writeLock = this.connectorsLock.writeLock();
        writeLock.lock();
        try {
            connector.setService(this);
            Connector[] results = new Connector[this.connectors.length + 1];
            System.arraycopy(this.connectors, 0, results, 0, this.connectors.length);
            results[this.connectors.length] = connector;
            this.connectors = results;
        }
        finally {
            writeLock.unlock();
        }
        try {
            if (this.getState().isAvailable()) {
                connector.start();
            }
        }
        catch (LifecycleException e) {
            throw new IllegalArgumentException(sm.getString("standardService.connector.startFailed", connector), e);
        }
        this.support.firePropertyChange("connector", null, connector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName[] getConnectorNames() {
        Lock readLock = this.connectorsLock.readLock();
        readLock.lock();
        try {
            ObjectName[] results = new ObjectName[this.connectors.length];
            for (int i = 0; i < results.length; ++i) {
                results[i] = this.connectors[i].getObjectName();
            }
            ObjectName[] objectNameArray = results;
            return objectNameArray;
        }
        finally {
            readLock.unlock();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public Connector[] findConnectors() {
        Lock readLock = this.connectorsLock.readLock();
        readLock.lock();
        try {
            Connector[] connectorArray = (Connector[])this.connectors.clone();
            return connectorArray;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnector(Connector connector) {
        Lock writeLock = this.connectorsLock.writeLock();
        writeLock.lock();
        try {
            int j = -1;
            for (int i = 0; i < this.connectors.length; ++i) {
                if (connector != this.connectors[i]) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            int k = 0;
            Connector[] results = new Connector[this.connectors.length - 1];
            for (int i = 0; i < this.connectors.length; ++i) {
                if (i == j) continue;
                results[k++] = this.connectors[i];
            }
            this.connectors = results;
        }
        finally {
            writeLock.unlock();
        }
        if (connector.getState().isAvailable()) {
            try {
                connector.stop();
            }
            catch (LifecycleException e) {
                log.error((Object)sm.getString("standardService.connector.stopFailed", connector), (Throwable)e);
            }
        }
        connector.setService(null);
        this.support.firePropertyChange("connector", connector, null);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StandardService[");
        sb.append(this.getName());
        sb.append(']');
        return sb.toString();
    }

    @Override
    public void addExecutor(Executor ex) {
        boolean added = false;
        this.executorsLock.writeLock().lock();
        try {
            if (!this.executors.contains(ex)) {
                added = true;
                this.executors.add(ex);
            }
        }
        finally {
            this.executorsLock.writeLock().unlock();
        }
        if (added && this.getState().isAvailable()) {
            try {
                ex.start();
            }
            catch (LifecycleException x) {
                log.error((Object)sm.getString("standardService.executor.start"), (Throwable)x);
            }
        }
    }

    @Override
    public Executor[] findExecutors() {
        this.executorsLock.readLock().lock();
        try {
            Executor[] executorArray = this.executors.toArray(new Executor[0]);
            return executorArray;
        }
        finally {
            this.executorsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Executor getExecutor(String executorName) {
        this.executorsLock.readLock().lock();
        try {
            for (Executor executor : this.executors) {
                if (!executorName.equals(executor.getName())) continue;
                Executor executor2 = executor;
                return executor2;
            }
        }
        finally {
            this.executorsLock.readLock().unlock();
        }
        return null;
    }

    @Override
    public void removeExecutor(Executor ex) {
        boolean removed = false;
        this.executorsLock.writeLock().lock();
        try {
            removed = this.executors.remove(ex);
        }
        finally {
            this.executorsLock.writeLock().unlock();
        }
        if (removed && this.getState().isAvailable()) {
            try {
                ex.stop();
            }
            catch (LifecycleException e) {
                log.error((Object)sm.getString("standardService.executor.stop"), (Throwable)e);
            }
        }
    }

    @Override
    protected void startInternal() throws LifecycleException {
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("standardService.start.name", this.name));
        }
        this.setState(LifecycleState.STARTING);
        if (this.engine != null) {
            this.engine.start();
        }
        for (Executor executor : this.findExecutors()) {
            executor.start();
        }
        this.mapperListener.start();
        for (Lifecycle lifecycle : this.findConnectors()) {
            if (((LifecycleBase)lifecycle).getState() == LifecycleState.FAILED) continue;
            ((LifecycleBase)lifecycle).start();
        }
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        Connector[] connectors;
        for (Connector connector : connectors = this.findConnectors()) {
            connector.getProtocolHandler().closeServerSocketGraceful();
        }
        long waitMillis = this.gracefulStopAwaitMillis;
        if (waitMillis > 0L) {
            Connector[] connectorArray = connectors;
            int n = connectorArray.length;
            for (int i = 0; i < n; ++i) {
                Connector connector = connectorArray[i];
                waitMillis = connector.getProtocolHandler().awaitConnectionsClose(waitMillis);
            }
        }
        for (Connector connector : connectors) {
            connector.pause();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("standardService.stop.name", this.name));
        }
        this.setState(LifecycleState.STOPPING);
        if (this.engine != null) {
            this.engine.stop();
        }
        for (Connector connector : connectors) {
            if (!LifecycleState.STARTED.equals((Object)connector.getState())) continue;
            connector.stop();
        }
        if (this.mapperListener.getState() != LifecycleState.INITIALIZED) {
            this.mapperListener.stop();
        }
        for (Lifecycle lifecycle : this.findExecutors()) {
            lifecycle.stop();
        }
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        if (this.engine != null) {
            this.engine.init();
        }
        for (Executor executor : this.findExecutors()) {
            if (executor instanceof JmxEnabled) {
                ((JmxEnabled)((Object)executor)).setDomain(this.getDomain());
            }
            executor.init();
        }
        this.mapperListener.init();
        for (Lifecycle lifecycle : this.findConnectors()) {
            ((LifecycleBase)lifecycle).init();
        }
    }

    @Override
    protected void destroyInternal() throws LifecycleException {
        this.mapperListener.destroy();
        for (Connector connector : this.findConnectors()) {
            connector.destroy();
        }
        for (Lifecycle lifecycle : this.findExecutors()) {
            lifecycle.destroy();
        }
        if (this.engine != null) {
            this.engine.destroy();
        }
        super.destroyInternal();
    }

    @Override
    public ClassLoader getParentClassLoader() {
        if (this.parentClassLoader != null) {
            return this.parentClassLoader;
        }
        if (this.server != null) {
            return this.server.getParentClassLoader();
        }
        return ClassLoader.getSystemClassLoader();
    }

    @Override
    public void setParentClassLoader(ClassLoader parent) {
        ClassLoader oldParentClassLoader = this.parentClassLoader;
        this.parentClassLoader = parent;
        this.support.firePropertyChange("parentClassLoader", oldParentClassLoader, this.parentClassLoader);
    }

    @Override
    protected String getDomainInternal() {
        String domain = null;
        Engine engine = this.getContainer();
        if (engine != null) {
            domain = engine.getName();
        }
        if (domain == null) {
            domain = this.getName();
        }
        return domain;
    }

    @Override
    public final String getObjectNameKeyProperties() {
        return "type=Service";
    }
}

