/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.owasp.csrfguard.CsrfGuardException;
import org.owasp.csrfguard.action.IAction;
import org.owasp.csrfguard.config.ConfigurationProvider;
import org.owasp.csrfguard.config.ConfigurationProviderFactory;
import org.owasp.csrfguard.config.NullConfigurationProvider;
import org.owasp.csrfguard.config.PropertiesConfigurationProvider;
import org.owasp.csrfguard.config.overlay.ExpirableCache;
import org.owasp.csrfguard.log.ILogger;
import org.owasp.csrfguard.log.LogLevel;
import org.owasp.csrfguard.servlet.JavaScriptServlet;
import org.owasp.csrfguard.util.CsrfGuardUtils;
import org.owasp.csrfguard.util.RandomGenerator;

public final class CsrfGuard {
    public static final String PAGE_TOKENS_KEY = "Owasp_CsrfGuard_Pages_Tokens_Key";
    private Properties properties = null;
    private static ExpirableCache<Boolean, ConfigurationProvider> configurationProviderExpirableCache = new ExpirableCache(1);
    private Map<String, Pattern> regexPatternCache = new HashMap<String, Pattern>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigurationProvider config() {
        if (this.properties == null) {
            return new NullConfigurationProvider();
        }
        ConfigurationProvider configurationProvider = configurationProviderExpirableCache.get(Boolean.TRUE);
        if (configurationProvider == null) {
            Class<CsrfGuard> clazz = CsrfGuard.class;
            synchronized (CsrfGuard.class) {
                if (configurationProvider == null) {
                    configurationProvider = this.retrieveNewConfig();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else if (!configurationProvider.isCacheable()) {
            configurationProvider = this.retrieveNewConfig();
        }
        return configurationProvider;
    }

    private ConfigurationProvider retrieveNewConfig() {
        ConfigurationProvider configurationProvider = null;
        String configurationProviderFactoryClassName = this.properties.getProperty("org.owasp.csrfguard.configuration.provider.factory", PropertiesConfigurationProvider.class.getName());
        Class configurationProviderFactoryClass = CsrfGuardUtils.forName(configurationProviderFactoryClassName);
        ConfigurationProviderFactory configurationProviderFactory = (ConfigurationProviderFactory)CsrfGuardUtils.newInstance(configurationProviderFactoryClass);
        configurationProvider = configurationProviderFactory.retrieveConfiguration(this.properties);
        configurationProviderExpirableCache.put(Boolean.TRUE, configurationProvider);
        return configurationProvider;
    }

    public static CsrfGuard getInstance() {
        return SingletonHolder.instance;
    }

    public static void load(Properties theProperties) throws NoSuchAlgorithmException, InstantiationException, IllegalAccessException, ClassNotFoundException, IOException, NoSuchProviderException {
        CsrfGuard.getInstance().properties = theProperties;
    }

    public ILogger getLogger() {
        return this.config().getLogger();
    }

    public String getTokenName() {
        return this.config().getTokenName();
    }

    public int getTokenLength() {
        return this.config().getTokenLength();
    }

    public boolean isRotateEnabled() {
        return this.config().isRotateEnabled();
    }

    public boolean isTokenPerPageEnabled() {
        return this.config().isTokenPerPageEnabled();
    }

    public boolean isTokenPerPagePrecreate() {
        return this.config().isTokenPerPagePrecreateEnabled();
    }

    public boolean isValidateWhenNoSessionExists() {
        return this.config().isValidateWhenNoSessionExists();
    }

    public SecureRandom getPrng() {
        return this.config().getPrng();
    }

    public String getNewTokenLandingPage() {
        return this.config().getNewTokenLandingPage();
    }

    public boolean isUseNewTokenLandingPage() {
        return this.config().isUseNewTokenLandingPage();
    }

    public boolean isAjaxEnabled() {
        return this.config().isAjaxEnabled();
    }

    public boolean isProtectEnabled() {
        return this.config().isProtectEnabled();
    }

    public boolean isEnabled() {
        return this.config().isEnabled();
    }

    public String getSessionKey() {
        return this.config().getSessionKey();
    }

    public Set<String> getProtectedPages() {
        return this.config().getProtectedPages();
    }

    public Set<String> getUnprotectedPages() {
        return this.config().getUnprotectedPages();
    }

    public Set<String> getProtectedMethods() {
        return this.config().getProtectedMethods();
    }

    public List<IAction> getActions() {
        return this.config().getActions();
    }

    public String getJavascriptSourceFile() {
        return this.config().getJavascriptSourceFile();
    }

    public boolean isJavascriptInjectFormAttributes() {
        return this.config().isJavascriptInjectFormAttributes();
    }

    public boolean isJavascriptInjectGetForms() {
        return this.config().isJavascriptInjectGetForms();
    }

    public boolean isJavascriptDomainStrict() {
        return this.config().isJavascriptDomainStrict();
    }

    public boolean isJavascriptRefererMatchDomain() {
        return this.config().isJavascriptRefererMatchDomain();
    }

    public String getJavascriptCacheControl() {
        return this.config().getJavascriptCacheControl();
    }

    public Pattern getJavascriptRefererPattern() {
        return this.config().getJavascriptRefererPattern();
    }

    public boolean isJavascriptInjectIntoForms() {
        return this.config().isJavascriptInjectIntoForms();
    }

    public boolean isJavascriptInjectIntoAttributes() {
        return this.config().isJavascriptInjectIntoAttributes();
    }

    public String getJavascriptXrequestedWith() {
        return this.config().getJavascriptXrequestedWith();
    }

    public String getJavascriptTemplateCode() {
        return this.config().getJavascriptTemplateCode();
    }

    public String getTokenValue(HttpServletRequest request) {
        return this.getTokenValue(request, request.getRequestURI());
    }

    public String getTokenValue(HttpServletRequest request, String uri) {
        String tokenValue = null;
        HttpSession session = request.getSession(false);
        if (session != null) {
            Map pageTokens;
            if (this.isTokenPerPageEnabled() && (pageTokens = (Map)session.getAttribute(PAGE_TOKENS_KEY)) != null) {
                if (this.isTokenPerPagePrecreate()) {
                    this.createPageToken(pageTokens, uri);
                }
                tokenValue = (String)pageTokens.get(uri);
            }
            if (tokenValue == null) {
                tokenValue = (String)session.getAttribute(this.getSessionKey());
            }
        }
        return tokenValue;
    }

    public boolean isValidRequest(HttpServletRequest request, HttpServletResponse response) {
        boolean valid = !this.isProtectedPageAndMethod(request);
        HttpSession session = request.getSession(true);
        String tokenFromSession = (String)session.getAttribute(this.getSessionKey());
        if (tokenFromSession != null && !valid) {
            try {
                if (this.isAjaxEnabled() && this.isAjaxRequest(request)) {
                    this.verifyAjaxToken(request);
                } else if (this.isTokenPerPageEnabled()) {
                    this.verifyPageToken(request);
                } else {
                    this.verifySessionToken(request);
                }
                valid = true;
            }
            catch (CsrfGuardException csrfe) {
                this.callActionsOnError(request, response, csrfe);
            }
            if (!this.isAjaxRequest(request) && this.isRotateEnabled()) {
                this.rotateTokens(request);
            }
        } else if (tokenFromSession == null && !valid) {
            try {
                throw new CsrfGuardException("CsrfGuard expects the token to exist in session at this point");
            }
            catch (CsrfGuardException csrfe) {
                this.callActionsOnError(request, response, csrfe);
            }
        }
        return valid;
    }

    private void callActionsOnError(HttpServletRequest request, HttpServletResponse response, CsrfGuardException csrfe) {
        for (IAction action : this.getActions()) {
            try {
                action.execute(request, response, csrfe, this);
            }
            catch (CsrfGuardException exception) {
                this.getLogger().log(LogLevel.Error, exception);
            }
        }
    }

    public void updateToken(HttpSession session) {
        String tokenValue = (String)session.getAttribute(this.getSessionKey());
        if (tokenValue == null) {
            try {
                tokenValue = RandomGenerator.generateRandomId(this.getPrng(), this.getTokenLength());
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("unable to generate the random token - %s", e.getLocalizedMessage()), e);
            }
            session.setAttribute(this.getSessionKey(), (Object)tokenValue);
        }
    }

    public void updateTokens(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            this.updateToken(session);
            if (this.isTokenPerPageEnabled()) {
                HashMap<String, String> pageTokens = (HashMap<String, String>)session.getAttribute(PAGE_TOKENS_KEY);
                if (pageTokens == null) {
                    pageTokens = new HashMap<String, String>();
                    session.setAttribute(PAGE_TOKENS_KEY, pageTokens);
                }
                if (this.isProtectedPageAndMethod(request)) {
                    this.createPageToken(pageTokens, request.getRequestURI());
                }
            }
        }
    }

    private void createPageToken(Map<String, String> pageTokens, String uri) {
        if (pageTokens == null) {
            return;
        }
        if (pageTokens.containsKey(uri)) {
            return;
        }
        try {
            pageTokens.put(uri, RandomGenerator.generateRandomId(this.getPrng(), this.getTokenLength()));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("unable to generate the random token - %s", e.getLocalizedMessage()), e);
        }
    }

    public void writeLandingPage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        StringBuilder sb;
        String landingPage = this.getNewTokenLandingPage();
        if (landingPage == null) {
            sb = new StringBuilder();
            sb.append(request.getContextPath());
            sb.append(request.getServletPath());
            landingPage = sb.toString();
        }
        sb = new StringBuilder();
        sb.append("<html>\r\n");
        sb.append("<head>\r\n");
        sb.append("<title>OWASP CSRFGuard Project - New Token Landing Page</title>\r\n");
        sb.append("</head>\r\n");
        sb.append("<body>\r\n");
        sb.append("<script type=\"text/javascript\">\r\n");
        sb.append("var form = document.createElement(\"form\");\r\n");
        sb.append("form.setAttribute(\"method\", \"post\");\r\n");
        sb.append("form.setAttribute(\"action\", \"");
        sb.append(landingPage);
        sb.append("\");\r\n");
        if (this.isProtectedPage(landingPage)) {
            sb.append("var hiddenField = document.createElement(\"input\");\r\n");
            sb.append("hiddenField.setAttribute(\"type\", \"hidden\");\r\n");
            sb.append("hiddenField.setAttribute(\"name\", \"");
            sb.append(this.getTokenName());
            sb.append("\");\r\n");
            sb.append("hiddenField.setAttribute(\"value\", \"");
            sb.append(this.getTokenValue(request, landingPage));
            sb.append("\");\r\n");
            sb.append("form.appendChild(hiddenField);\r\n");
        }
        sb.append("document.body.appendChild(form);\r\n");
        sb.append("form.submit();\r\n");
        sb.append("</script>\r\n");
        sb.append("</body>\r\n");
        sb.append("</html>\r\n");
        String code = sb.toString();
        response.setContentType("text/html");
        response.setContentLength(code.length());
        response.getWriter().write(code);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\r\n*****************************************************\r\n");
        sb.append("* Owasp.CsrfGuard Properties\r\n");
        sb.append("*\r\n");
        sb.append(String.format("* Logger: %s\r\n", this.getLogger().getClass().getName()));
        sb.append(String.format("* NewTokenLandingPage: %s\r\n", this.getNewTokenLandingPage()));
        sb.append(String.format("* PRNG: %s\r\n", this.getPrng().getAlgorithm()));
        sb.append(String.format("* SessionKey: %s\r\n", this.getSessionKey()));
        sb.append(String.format("* TokenLength: %s\r\n", this.getTokenLength()));
        sb.append(String.format("* TokenName: %s\r\n", this.getTokenName()));
        sb.append(String.format("* Ajax: %s\r\n", this.isAjaxEnabled()));
        sb.append(String.format("* Rotate: %s\r\n", this.isRotateEnabled()));
        sb.append(String.format("* Javascript cache control: %s\r\n", this.getJavascriptCacheControl()));
        sb.append(String.format("* Javascript domain strict: %s\r\n", this.isJavascriptDomainStrict()));
        sb.append(String.format("* Javascript inject attributes: %s\r\n", this.isJavascriptInjectIntoAttributes()));
        sb.append(String.format("* Javascript inject forms: %s\r\n", this.isJavascriptInjectIntoForms()));
        sb.append(String.format("* Javascript referer pattern: %s\r\n", this.getJavascriptRefererPattern()));
        sb.append(String.format("* Javascript referer match domain: %s\r\n", this.isJavascriptRefererMatchDomain()));
        sb.append(String.format("* Javascript source file: %s\r\n", this.getJavascriptSourceFile()));
        sb.append(String.format("* Javascript X requested with: %s\r\n", this.getJavascriptXrequestedWith()));
        sb.append(String.format("* Protected methods: %s\r\n", CsrfGuardUtils.toStringForLog(this.getProtectedMethods())));
        sb.append(String.format("* Protected pages size: %s\r\n", CsrfGuardUtils.length(this.getProtectedPages())));
        sb.append(String.format("* Unprotected methods: %s\r\n", CsrfGuardUtils.toStringForLog(this.getUnprotectedMethods())));
        sb.append(String.format("* Unprotected pages size: %s\r\n", CsrfGuardUtils.length(this.getUnprotectedPages())));
        sb.append(String.format("* TokenPerPage: %s\r\n", this.isTokenPerPageEnabled()));
        sb.append(String.format("* Enabled: %s\r\n", this.isEnabled()));
        sb.append(String.format("* ValidateWhenNoSessionExists: %s\r\n", this.isValidateWhenNoSessionExists()));
        for (IAction action : this.getActions()) {
            sb.append(String.format("* Action: %s\r\n", action.getClass().getName()));
            for (String name : action.getParameterMap().keySet()) {
                String value = action.getParameter(name);
                sb.append(String.format("*\tParameter: %s = %s\r\n", name, value));
            }
        }
        sb.append("*****************************************************\r\n");
        return sb.toString();
    }

    private boolean isAjaxRequest(HttpServletRequest request) {
        return request.getHeader("X-Requested-With") != null;
    }

    private void verifyAjaxToken(HttpServletRequest request) throws CsrfGuardException {
        HttpSession session = request.getSession(true);
        String tokenFromSession = (String)session.getAttribute(this.getSessionKey());
        String tokenFromRequest = request.getHeader(this.getTokenName());
        if (tokenFromRequest == null) {
            throw new CsrfGuardException("required token is missing from the request");
        }
        if (!tokenFromSession.equals(tokenFromRequest)) {
            if (tokenFromRequest.contains(",")) {
                tokenFromRequest = tokenFromRequest.substring(0, tokenFromRequest.indexOf(44)).trim();
            }
            if (!tokenFromSession.equals(tokenFromRequest)) {
                throw new CsrfGuardException("request token does not match session token");
            }
        }
    }

    private void verifyPageToken(HttpServletRequest request) throws CsrfGuardException {
        HttpSession session = request.getSession(true);
        Map pageTokens = (Map)session.getAttribute(PAGE_TOKENS_KEY);
        String tokenFromPages = pageTokens != null ? (String)pageTokens.get(request.getRequestURI()) : null;
        String tokenFromSession = (String)session.getAttribute(this.getSessionKey());
        String tokenFromRequest = request.getParameter(this.getTokenName());
        if (tokenFromRequest == null) {
            throw new CsrfGuardException("required token is missing from the request");
        }
        if (tokenFromPages != null) {
            if (!tokenFromPages.equals(tokenFromRequest)) {
                throw new CsrfGuardException("request token does not match page token");
            }
        } else if (!tokenFromSession.equals(tokenFromRequest)) {
            throw new CsrfGuardException("request token does not match session token");
        }
    }

    private void verifySessionToken(HttpServletRequest request) throws CsrfGuardException {
        HttpSession session = request.getSession(true);
        String tokenFromSession = (String)session.getAttribute(this.getSessionKey());
        String tokenFromRequest = request.getParameter(this.getTokenName());
        if (tokenFromRequest == null) {
            throw new CsrfGuardException("required token is missing from the request");
        }
        if (!tokenFromSession.equals(tokenFromRequest)) {
            throw new CsrfGuardException("request token does not match session token");
        }
    }

    private void rotateTokens(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        String tokenFromSession = null;
        try {
            tokenFromSession = RandomGenerator.generateRandomId(this.getPrng(), this.getTokenLength());
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("unable to generate the random token - %s", e.getLocalizedMessage()), e);
        }
        session.setAttribute(this.getSessionKey(), (Object)tokenFromSession);
        if (this.isTokenPerPageEnabled()) {
            Map pageTokens = (Map)session.getAttribute(PAGE_TOKENS_KEY);
            try {
                pageTokens.put(request.getRequestURI(), RandomGenerator.generateRandomId(this.getPrng(), this.getTokenLength()));
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("unable to generate the random token - %s", e.getLocalizedMessage()), e);
            }
        }
    }

    public boolean isProtectedPage(String uri) {
        if (JavaScriptServlet.getJavascriptUris().contains(uri)) {
            return false;
        }
        boolean retval = !this.isProtectEnabled();
        for (String protectedPage : this.getProtectedPages()) {
            if (this.isUriExactMatch(protectedPage, uri)) {
                return true;
            }
            if (!this.isUriMatch(protectedPage, uri)) continue;
            retval = true;
        }
        for (String unprotectedPage : this.getUnprotectedPages()) {
            if (this.isUriExactMatch(unprotectedPage, uri)) {
                return false;
            }
            if (!this.isUriMatch(unprotectedPage, uri)) continue;
            retval = false;
        }
        return retval;
    }

    public boolean isProtectedMethod(String method) {
        Set<String> theUnprotectedMethods;
        boolean isProtected = true;
        Set<String> theProtectedMethods = this.getProtectedMethods();
        if (!theProtectedMethods.isEmpty() && !theProtectedMethods.contains(method)) {
            isProtected = false;
        }
        if (!(theUnprotectedMethods = this.getUnprotectedMethods()).isEmpty() && theUnprotectedMethods.contains(method)) {
            isProtected = false;
        }
        return isProtected;
    }

    public boolean isProtectedPageAndMethod(String page, String method) {
        return this.isProtectedPage(page) && this.isProtectedMethod(method);
    }

    public boolean isProtectedPageAndMethod(HttpServletRequest request) {
        return this.isProtectedPageAndMethod(request.getRequestURI(), request.getMethod());
    }

    public boolean isPrintConfig() {
        return this.config().isPrintConfig();
    }

    private boolean isUriMatch(String testPath, String requestPath) {
        if (CsrfGuard.isTestPathRegex(testPath)) {
            Pattern pattern = this.regexPatternCache.get(testPath);
            if (pattern == null) {
                pattern = Pattern.compile(testPath);
                this.regexPatternCache.put(testPath, pattern);
            }
            return pattern.matcher(requestPath).matches();
        }
        boolean retval = false;
        if (testPath.equals(requestPath)) {
            retval = true;
        }
        if (testPath.equals("/*")) {
            retval = true;
        }
        if (testPath.endsWith("/*") && testPath.regionMatches(0, requestPath, 0, testPath.length() - 2)) {
            if (requestPath.length() == testPath.length() - 2) {
                retval = true;
            } else if ('/' == requestPath.charAt(testPath.length() - 2)) {
                retval = true;
            }
        }
        if (testPath.startsWith("*.")) {
            int slash = requestPath.lastIndexOf(47);
            int period = requestPath.lastIndexOf(46);
            if (slash >= 0 && period > slash && period != requestPath.length() - 1 && requestPath.length() - period == testPath.length() - 1) {
                retval = testPath.regionMatches(2, requestPath, period + 1, testPath.length() - 2);
            }
        }
        return retval;
    }

    private static boolean isTestPathRegex(String testPath) {
        return testPath != null && testPath.startsWith("^") && testPath.endsWith("$");
    }

    private boolean isUriExactMatch(String testPath, String requestPath) {
        if (CsrfGuard.isTestPathRegex(testPath)) {
            return false;
        }
        boolean retval = false;
        if (testPath.equals(requestPath)) {
            retval = true;
        }
        return retval;
    }

    public Set<String> getUnprotectedMethods() {
        return this.config().getUnprotectedMethods();
    }

    private static class SingletonHolder {
        public static final CsrfGuard instance = new CsrfGuard();

        private SingletonHolder() {
        }
    }
}

