/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard.config;

import java.security.SecureRandom;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.owasp.csrfguard.action.IAction;
import org.owasp.csrfguard.log.ILogger;

public interface ConfigurationProvider {
    public boolean isCacheable();

    public boolean isPrintConfig();

    public ILogger getLogger();

    public String getTokenName();

    public boolean isValidateWhenNoSessionExists();

    public int getTokenLength();

    public boolean isRotateEnabled();

    public boolean isTokenPerPageEnabled();

    public boolean isTokenPerPagePrecreateEnabled();

    public SecureRandom getPrng();

    public String getNewTokenLandingPage();

    public boolean isUseNewTokenLandingPage();

    public boolean isAjaxEnabled();

    public boolean isProtectEnabled();

    public String getSessionKey();

    public Set<String> getProtectedPages();

    public Set<String> getUnprotectedPages();

    public Set<String> getProtectedMethods();

    public Set<String> getUnprotectedMethods();

    public boolean isEnabled();

    public List<IAction> getActions();

    public String getJavascriptSourceFile();

    public boolean isJavascriptDomainStrict();

    public String getJavascriptCacheControl();

    public Pattern getJavascriptRefererPattern();

    public boolean isJavascriptInjectGetForms();

    public boolean isJavascriptInjectFormAttributes();

    public boolean isJavascriptInjectIntoForms();

    public boolean isJavascriptRefererMatchDomain();

    public boolean isJavascriptInjectIntoAttributes();

    public String getJavascriptXrequestedWith();

    public String getJavascriptTemplateCode();
}

