/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard.config.overlay;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.owasp.csrfguard.config.overlay.ConfigPropertiesCascadeUtils;
import org.owasp.csrfguard.log.ILogger;
import org.owasp.csrfguard.log.LogLevel;
import org.owasp.csrfguard.util.CsrfGuardUtils;

public abstract class ConfigPropertiesCascadeBase {
    private static final String EL_CONFIG_SUFFIX = ".elConfig";
    private static Map<Class<? extends ConfigPropertiesCascadeBase>, ConfigPropertiesCascadeBase> configSingletonFromClass = null;
    private static ThreadLocal<Map<Class<? extends ConfigPropertiesCascadeBase>, Map<String, String>>> propertiesThreadLocalOverrideMap = null;
    private static Map<Class<? extends ConfigPropertiesCascadeBase>, Map<String, String>> propertiesOverrideMap = null;
    private Properties properties = new Properties();
    private long createdTime = System.currentTimeMillis();
    private long lastCheckedTime = System.currentTimeMillis();
    private Integer timeToCheckConfigSeconds = null;
    private static Map<Class<? extends ConfigPropertiesCascadeBase>, ConfigPropertiesCascadeBase> configFileCache = null;
    private List<ConfigFile> configFiles = null;

    protected Properties internalProperties() {
        return this.properties;
    }

    protected static <T extends ConfigPropertiesCascadeBase> T retrieveConfig(Class<T> configClass) {
        ConfigPropertiesCascadeBase configPropertiesCascadeBase;
        if (configSingletonFromClass == null) {
            configSingletonFromClass = new HashMap<Class<? extends ConfigPropertiesCascadeBase>, ConfigPropertiesCascadeBase>();
        }
        if ((configPropertiesCascadeBase = configSingletonFromClass.get(configClass)) == null) {
            configPropertiesCascadeBase = (ConfigPropertiesCascadeBase)ConfigPropertiesCascadeUtils.newInstance(configClass, true);
            configSingletonFromClass.put(configClass, configPropertiesCascadeBase);
        }
        return (T)configPropertiesCascadeBase.retrieveFromConfigFileOrCache();
    }

    protected Class<?> getClassInSiblingJar() {
        return null;
    }

    protected abstract String getSecondsToCheckConfigKey();

    public abstract void clearCachedCalculatedValues();

    public Map<String, String> propertiesThreadLocalOverrideMap() {
        Map<String, String> propertiesOverrideMapLocal;
        Map<Class<? extends ConfigPropertiesCascadeBase>, Map<String, String>> overrideMap;
        if (propertiesThreadLocalOverrideMap == null) {
            propertiesThreadLocalOverrideMap = new ThreadLocal();
        }
        if ((overrideMap = propertiesThreadLocalOverrideMap.get()) == null) {
            overrideMap = new HashMap<Class<? extends ConfigPropertiesCascadeBase>, Map<String, String>>();
            propertiesThreadLocalOverrideMap.set(overrideMap);
        }
        if ((propertiesOverrideMapLocal = overrideMap.get(this.getClass())) == null) {
            propertiesOverrideMapLocal = new HashMap<String, String>();
            overrideMap.put(this.getClass(), propertiesOverrideMapLocal);
        }
        return propertiesOverrideMapLocal;
    }

    public Set<String> propertyNames() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.addAll(this.propertiesHelper(false).keySet());
        return result;
    }

    public Map<String, String> propertiesOverrideMap() {
        Map<String, String> overrideMap;
        if (propertiesOverrideMap == null) {
            propertiesOverrideMap = new LinkedHashMap<Class<? extends ConfigPropertiesCascadeBase>, Map<String, String>>();
        }
        if ((overrideMap = propertiesOverrideMap.get(this.getClass())) == null) {
            overrideMap = new LinkedHashMap<String, String>();
            propertiesOverrideMap.put(this.getClass(), overrideMap);
        }
        return overrideMap;
    }

    public Properties properties() {
        return this.propertiesHelper(true);
    }

    /*
     * WARNING - void declaration
     */
    protected Properties propertiesHelper(boolean setValues) {
        Properties tempResult = new Properties();
        tempResult.putAll((Map<?, ?>)this.properties);
        Map<String, String> localPropertiesOverrideMap = this.propertiesOverrideMap();
        for (String key : localPropertiesOverrideMap.keySet()) {
            tempResult.put(key, ConfigPropertiesCascadeUtils.defaultString(localPropertiesOverrideMap.get(key)));
        }
        localPropertiesOverrideMap = this.propertiesThreadLocalOverrideMap();
        for (String key : localPropertiesOverrideMap.keySet()) {
            tempResult.put(key, ConfigPropertiesCascadeUtils.defaultString(localPropertiesOverrideMap.get(key)));
        }
        Properties result = new Properties();
        for (String string : tempResult.keySet()) {
            void var6_6;
            String value;
            String string2 = value = setValues ? this.properties.getProperty(string) : "";
            if (string.endsWith(EL_CONFIG_SUFFIX)) {
                if (setValues) {
                    value = ConfigPropertiesCascadeUtils.substituteExpressionLanguage(value, null, true, true, true, false);
                }
                String string3 = string.substring(0, string.length() - EL_CONFIG_SUFFIX.length());
            }
            result.put((Object)var6_6, ConfigPropertiesCascadeUtils.defaultString(value));
        }
        return result;
    }

    public String propertyValueStringRequired(String key) {
        return this.propertyValueString(key, null, true).getTheValue();
    }

    public String propertyValueString(String key, String defaultValue) {
        return this.propertyValueString(key, defaultValue, false).getTheValue();
    }

    public String propertyValueString(String key) {
        return this.propertyValueString(key, null, false).getTheValue();
    }

    protected PropertyValueResult propertyValueString(String key, String defaultValue, boolean required) {
        if (key.endsWith(EL_CONFIG_SUFFIX)) {
            throw new RuntimeException("Why does key end in suffix??? .elConfig, " + key);
        }
        return this.propertyValueStringHelper(key, defaultValue, required);
    }

    protected PropertyValueResult propertyValueStringHelper(String key, String defaultValue, boolean required) {
        String value;
        PropertyValueResult elPropertyValueResult;
        if (!key.endsWith(EL_CONFIG_SUFFIX) && (elPropertyValueResult = this.propertyValueStringHelper(key + EL_CONFIG_SUFFIX, null, false)).isHasKey()) {
            String result = ConfigPropertiesCascadeUtils.substituteExpressionLanguage(elPropertyValueResult.getTheValue(), null, true, true, true, false);
            PropertyValueResult propertyValueResult = new PropertyValueResult(result, true);
            return propertyValueResult;
        }
        boolean hasKey = false;
        Map<String, String> overrideMap = this.propertiesThreadLocalOverrideMap();
        hasKey = overrideMap == null ? false : overrideMap.containsKey(key);
        String string = value = hasKey ? overrideMap.get(key) : null;
        if (!hasKey) {
            overrideMap = this.propertiesOverrideMap();
            hasKey = overrideMap == null ? null : Boolean.valueOf(overrideMap.containsKey(key));
            String string2 = value = hasKey ? overrideMap.get(key) : null;
        }
        if (!hasKey) {
            hasKey = this.properties.containsKey(key);
            String string3 = value = hasKey ? this.properties.getProperty(key) : null;
        }
        if (!required && !hasKey) {
            return new PropertyValueResult(defaultValue, false);
        }
        if (required && !hasKey) {
            String error = "Cant find property: " + key + " in properties file: " + this.getMainConfigClasspath() + ", it is required";
            throw new RuntimeException(error);
        }
        value = ConfigPropertiesCascadeUtils.trim(value);
        value = ConfigPropertiesCascadeBase.substituteCommonVars(value);
        if (!required && ConfigPropertiesCascadeUtils.isBlank(value)) {
            return new PropertyValueResult(null, true);
        }
        if (required && ConfigPropertiesCascadeUtils.isBlank(value)) {
            String error = "Property " + key + " in properties file: " + this.getMainConfigClasspath() + ", has a blank value, it is required";
            throw new RuntimeException(error);
        }
        return new PropertyValueResult(value, true);
    }

    protected static String substituteCommonVars(String string) {
        if (string == null) {
            return string;
        }
        if (string.indexOf(36) < 0) {
            return string;
        }
        string = ConfigPropertiesCascadeUtils.replace(string, "$space$", " ");
        string = ConfigPropertiesCascadeUtils.replace(string, "$newline$", "\n");
        return string;
    }

    long getCreatedTime() {
        return this.createdTime;
    }

    long getLastCheckedTime() {
        return this.lastCheckedTime;
    }

    protected Integer getTimeToCheckConfigSeconds() {
        return this.timeToCheckConfigSeconds;
    }

    protected ConfigPropertiesCascadeBase retrieveFromConfigFiles() {
        Properties mainExampleConfigFile;
        Properties mainConfigFile = ConfigPropertiesCascadeBase.propertiesFromResourceName(this.getMainConfigClasspath(), false);
        String secondsToCheckConfigString = null;
        String overrideFullConfig = null;
        if (mainConfigFile != null) {
            overrideFullConfig = mainConfigFile.getProperty(this.getHierarchyConfigKey());
            secondsToCheckConfigString = mainConfigFile.getProperty(this.getSecondsToCheckConfigKey());
        }
        if ((ConfigPropertiesCascadeUtils.isBlank(overrideFullConfig) || ConfigPropertiesCascadeUtils.isBlank(secondsToCheckConfigString)) && (mainExampleConfigFile = ConfigPropertiesCascadeBase.propertiesFromResourceName(this.getMainExampleConfigClasspath(), false)) != null) {
            if (ConfigPropertiesCascadeUtils.isBlank(overrideFullConfig)) {
                overrideFullConfig = mainExampleConfigFile.getProperty(this.getHierarchyConfigKey());
            }
            if (ConfigPropertiesCascadeUtils.isBlank(secondsToCheckConfigString)) {
                secondsToCheckConfigString = mainExampleConfigFile.getProperty(this.getSecondsToCheckConfigKey());
            }
        }
        if (ConfigPropertiesCascadeUtils.isBlank(overrideFullConfig)) {
            throw new RuntimeException("Cant find the hierarchy config key: " + this.getHierarchyConfigKey() + " in config files: " + this.getMainConfigClasspath() + " or " + this.getMainExampleConfigClasspath());
        }
        if (ConfigPropertiesCascadeUtils.isBlank(secondsToCheckConfigString)) {
            throw new RuntimeException("Cant find the seconds to check config key: " + this.getSecondsToCheckConfigKey() + " in config files: " + this.getMainConfigClasspath() + " or " + this.getMainExampleConfigClasspath());
        }
        ConfigPropertiesCascadeBase result = (ConfigPropertiesCascadeBase)ConfigPropertiesCascadeUtils.newInstance(this.getClass(), true);
        try {
            result.timeToCheckConfigSeconds = ConfigPropertiesCascadeUtils.intValue(secondsToCheckConfigString);
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid integer seconds to check config config value: " + secondsToCheckConfigString + ", key: " + this.getSecondsToCheckConfigKey() + " in config files: " + this.getMainConfigClasspath() + " or " + this.getMainExampleConfigClasspath());
        }
        List<String> overrideConfigStringList = ConfigPropertiesCascadeUtils.splitTrimToList(overrideFullConfig, ",");
        result.configFiles = new ArrayList<ConfigFile>();
        for (String overrideConfigString : overrideConfigStringList) {
            ConfigFile configFile = new ConfigFile(overrideConfigString);
            result.configFiles.add(configFile);
            try {
                String configFileContents = configFile.retrieveContents(this);
                configFile.setContents(configFileContents);
                result.properties.load(new StringReader(configFileContents));
            }
            catch (Exception e) {
                throw new RuntimeException("Problem loading properties: " + overrideConfigString, e);
            }
        }
        return result;
    }

    private static ILogger iLogger() {
        return null;
    }

    protected static void logInfo(String logMessage, Exception t) {
        ILogger iLogger = ConfigPropertiesCascadeBase.iLogger();
        if (iLogger != null) {
            if (!ConfigPropertiesCascadeUtils.isBlank(logMessage)) {
                iLogger.log(LogLevel.Info, logMessage);
            }
            if (t != null) {
                iLogger.log(LogLevel.Info, t);
            }
        }
    }

    protected static void logError(String logMessage, Exception t) {
        ILogger iLogger = ConfigPropertiesCascadeBase.iLogger();
        if (iLogger != null) {
            if (!ConfigPropertiesCascadeUtils.isBlank(logMessage)) {
                iLogger.log(LogLevel.Info, logMessage);
            }
            if (t != null) {
                iLogger.log(LogLevel.Info, t);
            }
        } else {
            System.err.println("ERROR: " + logMessage);
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConfigPropertiesCascadeBase retrieveFromConfigFileOrCache() {
        LinkedHashMap<String, Object> debugMap = new LinkedHashMap<String, Object>();
        try {
            ConfigPropertiesCascadeBase configPropertiesCascadeBase;
            ConfigPropertiesCascadeBase configObject;
            if (configFileCache == null) {
                debugMap.put("configFileCache", null);
                configFileCache = new HashMap<Class<? extends ConfigPropertiesCascadeBase>, ConfigPropertiesCascadeBase>();
            }
            if ((configObject = configFileCache.get(this.getClass())) == null) {
                debugMap.put("mainConfigClasspath", this.getMainConfigClasspath());
                configObject = this.retrieveFromConfigFiles();
                configFileCache.put(this.getClass(), configObject);
            } else if (configObject.needToCheckIfFilesNeedReloading()) {
                debugMap.put("needToCheckIfFilesNeedReloading", true);
                configPropertiesCascadeBase = configObject;
                synchronized (configPropertiesCascadeBase) {
                    configObject = configFileCache.get(this.getClass());
                    if (configObject.needToCheckIfFilesNeedReloading()) {
                        debugMap.put("needToCheckIfFilesNeedReloading2", true);
                        if (configObject.filesNeedReloadingBasedOnContents()) {
                            debugMap.put("filesNeedReloadingBasedOnContents", true);
                            configObject = this.retrieveFromConfigFiles();
                            configFileCache.put(this.getClass(), configObject);
                        }
                    }
                }
            }
            debugMap.put("configObjectPropertyCount", configObject == null ? null : (configObject.properties() == null ? "propertiesNull" : Integer.valueOf(configObject.properties().size())));
            configPropertiesCascadeBase = configObject;
            return configPropertiesCascadeBase;
        }
        finally {
            ILogger iLogger = ConfigPropertiesCascadeBase.iLogger();
            if (iLogger != null) {
                iLogger.log(LogLevel.Debug, ConfigPropertiesCascadeUtils.mapToString(debugMap));
            }
        }
    }

    protected boolean needToCheckIfFilesNeedReloading() {
        long lastCheckedTimeLocal = this.getLastCheckedTime();
        int timeToCheckSeconds = this.getTimeToCheckConfigSeconds();
        if (timeToCheckSeconds < 0) {
            return false;
        }
        return System.currentTimeMillis() - lastCheckedTimeLocal > (long)(timeToCheckSeconds * 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean filesNeedReloadingBasedOnContents() {
        try {
            for (ConfigFile configFile : this.configFiles) {
                if (ConfigPropertiesCascadeUtils.equals(configFile.getContents(), configFile.retrieveContents(this))) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            ConfigPropertiesCascadeBase.logError("Error checking for changes in configs (will use previous version): " + this.getMainConfigClasspath(), e);
        }
        finally {
            this.lastCheckedTime = System.currentTimeMillis();
        }
        return false;
    }

    protected abstract String getMainConfigClasspath();

    protected abstract String getHierarchyConfigKey();

    protected abstract String getMainExampleConfigClasspath();

    public boolean propertyValueBoolean(String key, boolean defaultValue) {
        return this.propertyValueBoolean(key, defaultValue, false);
    }

    public boolean containsKey(String key) {
        return this.propertyValueString(key, null, false).isHasKey();
    }

    public Boolean propertyValueBoolean(String key) {
        return this.propertyValueBoolean(key, null, false);
    }

    protected Boolean propertyValueBoolean(String key, Boolean defaultValue, boolean required) {
        String value = this.propertyValueString(key, null, false).getTheValue();
        if (ConfigPropertiesCascadeUtils.isBlank(value) && !required) {
            return defaultValue;
        }
        if (ConfigPropertiesCascadeUtils.isBlank(value) && required) {
            throw new RuntimeException("Cant find boolean property " + key + " in properties file: " + this.getMainConfigClasspath() + ", it is required, expecting true or false");
        }
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        if ("t".equalsIgnoreCase(value)) {
            return true;
        }
        if ("f".equalsIgnoreCase(value)) {
            return false;
        }
        if ("yes".equalsIgnoreCase(value)) {
            return true;
        }
        if ("no".equalsIgnoreCase(value)) {
            return false;
        }
        if ("y".equalsIgnoreCase(value)) {
            return true;
        }
        if ("n".equalsIgnoreCase(value)) {
            return false;
        }
        throw new RuntimeException("Invalid boolean value: '" + value + "' for property: " + key + " in properties file: " + this.getMainConfigClasspath() + ", expecting true or false");
    }

    protected Integer propertyValueInt(String key, Integer defaultValue, boolean required) {
        String value = this.propertyValueString(key, null, false).getTheValue();
        if (ConfigPropertiesCascadeUtils.isBlank(value) && !required) {
            return defaultValue;
        }
        if (ConfigPropertiesCascadeUtils.isBlank(value) && required) {
            throw new RuntimeException("Cant find integer property " + key + " in config file: " + this.getMainConfigClasspath() + ", it is required");
        }
        try {
            return ConfigPropertiesCascadeUtils.intValue(value);
        }
        catch (Exception exception) {
            throw new RuntimeException("Invalid integer value: '" + value + "' for property: " + key + " in config file: " + this.getMainConfigClasspath() + " in properties file");
        }
    }

    public boolean propertyValueBooleanRequired(String key) {
        return this.propertyValueBoolean(key, false, true);
    }

    public int propertyValueIntRequired(String key) {
        return this.propertyValueInt(key, -1, true);
    }

    public int propertyValueInt(String key, int defaultValue) {
        return this.propertyValueInt(key, defaultValue, false);
    }

    public Integer propertyValueInt(String key) {
        return this.propertyValueInt(key, null, false);
    }

    protected static Properties propertiesFromResourceName(String resourceName, boolean exceptionIfNotExist) {
        Properties properties = new Properties();
        URL url = null;
        try {
            url = ConfigPropertiesCascadeUtils.computeUrl(resourceName, true);
        }
        catch (Exception e) {
            ConfigPropertiesCascadeBase.logInfo("Problem loading config file: " + resourceName, e);
        }
        if (url == null && exceptionIfNotExist) {
            throw new RuntimeException("Problem loading config file: " + resourceName);
        }
        if (url == null) {
            return null;
        }
        InputStream inputStream = null;
        try {
            inputStream = url.openStream();
            properties.load(inputStream);
        }
        catch (Exception e) {
            throw new RuntimeException("Problem loading config file: " + resourceName, e);
        }
        return properties;
    }

    public boolean assertPropertyValueRequired(String key) {
        String value = this.propertyValueString(key);
        if (!ConfigPropertiesCascadeUtils.isBlank(value)) {
            return true;
        }
        String error = "Cant find property " + key + " in resource: " + this.getMainConfigClasspath() + ", it is required";
        System.err.println("CSRF guard error: " + error);
        ILogger iLogger = ConfigPropertiesCascadeBase.iLogger();
        if (iLogger != null) {
            iLogger.log(LogLevel.Error, error);
        }
        return false;
    }

    public boolean assertPropertyValueBoolean(String key, boolean required) {
        if (required && !this.assertPropertyValueRequired(key)) {
            return false;
        }
        String value = this.propertyValueString(key);
        if (!required && ConfigPropertiesCascadeUtils.isBlank(value)) {
            return true;
        }
        try {
            ConfigPropertiesCascadeUtils.booleanValue(value);
            return true;
        }
        catch (Exception exception) {
            String error = "Expecting true or false property " + key + " in resource: " + this.getMainConfigClasspath() + ", but is '" + value + "'";
            System.err.println("csrf guard error: " + error);
            ILogger iLogger = ConfigPropertiesCascadeBase.iLogger();
            if (iLogger != null) {
                iLogger.log(LogLevel.Error, error);
            }
            return false;
        }
    }

    public boolean assertPropertyValueClass(String key, Class<?> classType, boolean required) {
        if (required && !this.assertPropertyValueRequired(key)) {
            return false;
        }
        String value = this.propertyValueString(key);
        if (!required && ConfigPropertiesCascadeUtils.isBlank(value)) {
            return true;
        }
        String extraError = "";
        try {
            Class theClass = ConfigPropertiesCascadeUtils.forName(value);
            if (classType.isAssignableFrom(theClass)) {
                return true;
            }
            extraError = " does not derive from class: " + classType.getSimpleName();
        }
        catch (Exception e) {
            extraError = ", " + ConfigPropertiesCascadeUtils.getFullStackTrace(e);
        }
        String error = "Cant process property " + key + " in resource: " + this.getMainConfigClasspath() + ", the current value is '" + value + "', which should be of type: " + classType.getName() + extraError;
        System.err.println("csrf guard error: " + error);
        ILogger iLogger = ConfigPropertiesCascadeBase.iLogger();
        if (iLogger != null) {
            iLogger.log(LogLevel.Error, error);
        }
        return false;
    }

    public Map<String, String> propertiesMap(Pattern pattern) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String key : this.propertyNames()) {
            if (!pattern.matcher(key).matches()) continue;
            result.put(key, this.propertyValueString(key));
        }
        return result;
    }

    protected static class ConfigFile {
        private String originalConfig;
        private String contents = null;
        private ConfigFileType configFileType;
        private String configFileTypeConfig;

        public String getOriginalConfig() {
            return this.originalConfig;
        }

        public String getContents() {
            return this.contents;
        }

        public void setContents(String contents1) {
            this.contents = contents1;
        }

        public String retrieveContents(ConfigPropertiesCascadeBase configPropertiesCascadeBase) {
            String string;
            InputStream inputStream = null;
            try {
                inputStream = this.configFileType.inputStream(this.configFileTypeConfig, configPropertiesCascadeBase);
                string = ConfigPropertiesCascadeUtils.toString(inputStream, "UTF-8");
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException("Problem reading config: '" + this.originalConfig + "'", e);
                }
                catch (Throwable throwable) {
                    CsrfGuardUtils.closeQuietly(inputStream);
                    throw throwable;
                }
            }
            CsrfGuardUtils.closeQuietly(inputStream);
            return string;
        }

        public ConfigFile(String configFileFullConfig) {
            this.originalConfig = configFileFullConfig;
            int colonIndex = configFileFullConfig.indexOf(58);
            if (colonIndex == -1) {
                throw new RuntimeException("Config file spec needs the type of config and a colon, e.g. file:/some/path/config.properties  '" + configFileFullConfig + "'");
            }
            String configFileTypeString = ConfigPropertiesCascadeUtils.trim(ConfigPropertiesCascadeUtils.prefixOrSuffix(configFileFullConfig, ":", true));
            if (ConfigPropertiesCascadeUtils.isBlank(configFileTypeString)) {
                throw new RuntimeException("Config file spec needs the type of config and a colon, e.g. file:/some/path/config.properties  '" + configFileFullConfig + "'");
            }
            try {
                this.configFileType = ConfigFileType.valueOfIgnoreCase(configFileTypeString);
            }
            catch (Exception e) {
                throw new RuntimeException("Config file spec needs the type of config and a colon, e.g. file:/some/path/config.properties  '" + configFileFullConfig + "', " + e.getMessage(), e);
            }
            this.configFileTypeConfig = ConfigPropertiesCascadeUtils.trim(ConfigPropertiesCascadeUtils.prefixOrSuffix(configFileFullConfig, ":", false));
        }

        public ConfigFileType getConfigFileType() {
            return this.configFileType;
        }

        public String getConfigFileTypeConfig() {
            return this.configFileTypeConfig;
        }
    }

    protected static enum ConfigFileType {
        FILE{

            @Override
            public InputStream inputStream(String configFileTypeConfig, ConfigPropertiesCascadeBase configPropertiesCascadeBase) {
                File file = new File(configFileTypeConfig);
                if (!file.exists() || !file.isFile()) {
                    throw new RuntimeException("Cant find config file from filesystem path: " + configFileTypeConfig);
                }
                try {
                    return new FileInputStream(file);
                }
                catch (Exception e) {
                    throw new RuntimeException("Problem reading config file from filesystem path: " + file.getAbsolutePath(), e);
                }
            }
        }
        ,
        CLASSPATH{

            @Override
            public InputStream inputStream(String configFileTypeConfig, ConfigPropertiesCascadeBase configPropertiesCascadeBase) {
                Class<?> classInJar;
                URL url = ConfigPropertiesCascadeUtils.computeUrl(configFileTypeConfig, true);
                Exception exception = null;
                if (url != null) {
                    try {
                        return url.openStream();
                    }
                    catch (Exception e) {
                        exception = e;
                    }
                }
                if ((classInJar = configPropertiesCascadeBase.getClassInSiblingJar()) != null) {
                    File configFile;
                    File jarFile = classInJar == null ? null : ConfigPropertiesCascadeUtils.jarFile(classInJar);
                    File parentDir = jarFile == null ? null : jarFile.getParentFile();
                    String fileName = parentDir == null ? null : ConfigPropertiesCascadeUtils.stripLastSlashIfExists(ConfigPropertiesCascadeUtils.fileCanonicalPath(parentDir)) + File.separator + configFileTypeConfig;
                    File file = configFile = fileName == null ? null : new File(fileName);
                    if (configFile != null && configFile.exists() && configFile.isFile()) {
                        try {
                            return new FileInputStream(configFile);
                        }
                        catch (Exception e) {
                            ConfigPropertiesCascadeBase.logError("Cant read config file: " + configFile.getAbsolutePath(), e);
                        }
                    }
                }
                throw new RuntimeException("Cant find config file from classpath: " + configFileTypeConfig, exception);
            }
        };


        public abstract InputStream inputStream(String var1, ConfigPropertiesCascadeBase var2);

        public static ConfigFileType valueOfIgnoreCase(String string) {
            return ConfigPropertiesCascadeUtils.enumValueOfIgnoreCase(ConfigFileType.class, string, false);
        }
    }

    static class PropertyValueResult {
        private String theValue;
        private boolean hasKey;

        public PropertyValueResult(String theValue1, boolean hasKey1) {
            this.theValue = theValue1;
            this.hasKey = hasKey1;
        }

        public String getTheValue() {
            return this.theValue;
        }

        public void setTheValue(String theValue1) {
            this.theValue = theValue1;
        }

        public boolean isHasKey() {
            return this.hasKey;
        }

        public void setHasKey(boolean hasKey1) {
            this.hasKey = hasKey1;
        }
    }
}

