/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard.config.overlay;

import java.io.InputStream;
import org.owasp.csrfguard.CsrfGuardServletContextListener;
import org.owasp.csrfguard.config.overlay.ConfigPropertiesCascadeBase;
import org.owasp.csrfguard.config.overlay.ConfigPropertiesCascadeUtils;
import org.owasp.csrfguard.util.CsrfGuardUtils;

public class ConfigurationOverlayProvider
extends ConfigPropertiesCascadeBase {
    public static final String META_INF_CSRFGUARD_PROPERTIES = "META-INF/csrfguard.properties";
    public static final String OWASP_CSRF_GUARD_PROPERTIES = "Owasp.CsrfGuard.properties";
    public static final String OWASP_CSRF_GUARD_OVERLAY_PROPERTIES = "Owasp.CsrfGuard.overlay.properties";
    private static String mainExampleConfigClasspath = null;

    public static ConfigurationOverlayProvider retrieveConfig() {
        return ConfigurationOverlayProvider.retrieveConfig(ConfigurationOverlayProvider.class);
    }

    @Override
    protected String getSecondsToCheckConfigKey() {
        return "org.owasp.csrfguard.configOverlay.secondsBetweenUpdateChecks";
    }

    @Override
    public void clearCachedCalculatedValues() {
    }

    @Override
    protected String getMainConfigClasspath() {
        return OWASP_CSRF_GUARD_OVERLAY_PROPERTIES;
    }

    @Override
    protected String getHierarchyConfigKey() {
        return "org.owasp.csrfguard.configOverlay.hierarchy";
    }

    @Override
    protected String getMainExampleConfigClasspath() {
        if (mainExampleConfigClasspath == null) {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(OWASP_CSRF_GUARD_PROPERTIES);
            if (inputStream != null) {
                mainExampleConfigClasspath = OWASP_CSRF_GUARD_PROPERTIES;
                CsrfGuardUtils.closeQuietly(inputStream);
            } else {
                inputStream = this.getClass().getClassLoader().getResourceAsStream(META_INF_CSRFGUARD_PROPERTIES);
                if (inputStream != null) {
                    mainExampleConfigClasspath = META_INF_CSRFGUARD_PROPERTIES;
                    CsrfGuardUtils.closeQuietly(inputStream);
                } else {
                    mainExampleConfigClasspath = OWASP_CSRF_GUARD_PROPERTIES;
                }
            }
        }
        return ConfigPropertiesCascadeUtils.defaultIfBlank(CsrfGuardServletContextListener.getConfigFileName(), mainExampleConfigClasspath);
    }
}

