/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard.http;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.owasp.csrfguard.CsrfGuard;

public class InterceptRedirectResponse
extends HttpServletResponseWrapper {
    private HttpServletResponse response = null;
    private CsrfGuard csrfGuard;
    private HttpServletRequest request;

    public InterceptRedirectResponse(HttpServletResponse response, HttpServletRequest request, CsrfGuard csrfGuard) {
        super(response);
        this.response = response;
        this.request = request;
        this.csrfGuard = csrfGuard;
    }

    public void sendRedirect(String location) throws IOException {
        String sanitizedLocation = location.replaceAll("(\\r|\\n|%0D|%0A|%0a|%0d)", "");
        if (!sanitizedLocation.contains("://") && this.csrfGuard.isProtectedPageAndMethod(sanitizedLocation, "GET")) {
            this.csrfGuard.updateTokens(this.request);
            StringBuilder sb = new StringBuilder();
            if (!sanitizedLocation.startsWith("/")) {
                sb.append(this.request.getContextPath() + "/" + sanitizedLocation);
            } else {
                sb.append(sanitizedLocation);
            }
            if (sanitizedLocation.contains("?")) {
                sb.append('&');
            } else {
                sb.append('?');
            }
            String locationUri = sanitizedLocation.split("\\?", 2)[0];
            sb.append(this.csrfGuard.getTokenName());
            sb.append('=');
            sb.append(this.csrfGuard.getTokenValue(this.request, locationUri));
            this.response.sendRedirect(sb.toString());
        } else {
            this.response.sendRedirect(sanitizedLocation);
        }
    }
}

