/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard.servlet;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.owasp.csrfguard.CsrfGuard;
import org.owasp.csrfguard.CsrfGuardServletContextListener;
import org.owasp.csrfguard.log.LogLevel;
import org.owasp.csrfguard.util.CsrfGuardUtils;

public final class JavaScriptServlet
extends HttpServlet {
    private static final long serialVersionUID = -1459584282530150483L;
    private static final String TOKEN_NAME_IDENTIFIER = "%TOKEN_NAME%";
    private static final String TOKEN_VALUE_IDENTIFIER = "%TOKEN_VALUE%";
    private static final String DOMAIN_ORIGIN_IDENTIFIER = "%DOMAIN_ORIGIN%";
    private static final String DOMAIN_STRICT_IDENTIFIER = "%DOMAIN_STRICT%";
    private static final String INJECT_INTO_XHR_IDENTIFIER = "%INJECT_XHR%";
    private static final String INJECT_INTO_FORMS_IDENTIFIER = "%INJECT_FORMS%";
    private static final String INJECT_GET_FORMS_IDENTIFIER = "%INJECT_GET_FORMS%";
    private static final String INJECT_FORM_ATTRIBUTES_IDENTIFIER = "%INJECT_FORM_ATTRIBUTES%";
    private static final String INJECT_INTO_ATTRIBUTES_IDENTIFIER = "%INJECT_ATTRIBUTES%";
    private static final String CONTEXT_PATH_IDENTIFIER = "%CONTEXT_PATH%";
    private static final String CONTEXT_PATH_PARAM = "contextPath";
    private static final String SERVLET_PATH_IDENTIFIER = "%SERVLET_PATH%";
    private static final String X_REQUESTED_WITH_IDENTIFIER = "%X_REQUESTED_WITH%";
    private static final String TOKENS_PER_PAGE_IDENTIFIER = "%TOKENS_PER_PAGE%";
    private static ServletConfig servletConfig = null;
    private static Set<String> javascriptUris = new HashSet<String>();

    public static ServletConfig getStaticServletConfig() {
        return servletConfig;
    }

    public void init(ServletConfig theServletConfig) {
        servletConfig = theServletConfig;
        CsrfGuardServletContextListener.printConfigIfConfigured(servletConfig.getServletContext(), "Printing properties after Javascript servlet, note, the javascript properties have now been initialized: ");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String refererHeader = request.getHeader("referer");
        boolean hasError = false;
        Pattern javascriptRefererPattern = CsrfGuard.getInstance().getJavascriptRefererPattern();
        if (refererHeader != null && !javascriptRefererPattern.matcher(refererHeader).matches()) {
            CsrfGuard.getInstance().getLogger().log(LogLevel.Error, "Referer domain " + refererHeader + " does not match regex: " + javascriptRefererPattern.pattern());
            response.sendError(404);
            hasError = true;
        }
        if (refererHeader != null && CsrfGuard.getInstance().isJavascriptRefererMatchDomain()) {
            String url = request.getRequestURL().toString();
            String requestProtocolAndDomain = CsrfGuardUtils.httpProtocolAndDomain(url);
            String refererProtocolAndDomain = CsrfGuardUtils.httpProtocolAndDomain(refererHeader);
            if (!refererProtocolAndDomain.equals(requestProtocolAndDomain)) {
                CsrfGuard.getInstance().getLogger().log(LogLevel.Error, "Referer domain " + refererHeader + " does not match request domain: " + url);
                hasError = true;
                response.sendError(404);
            }
        }
        if (!hasError) {
            String javascriptPath = request.getContextPath() + request.getServletPath();
            if (javascriptUris.size() < 100) {
                javascriptUris.add(javascriptPath);
            }
            this.writeJavaScript(request, response);
        }
    }

    public static Set<String> getJavascriptUris() {
        return javascriptUris;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        CsrfGuard csrfGuard = CsrfGuard.getInstance();
        String isFetchCsrfToken = request.getHeader("FETCH-CSRF-TOKEN");
        if (csrfGuard != null && isFetchCsrfToken != null) {
            this.fetchCsrfToken(request, response);
        } else if (csrfGuard != null && csrfGuard.isTokenPerPageEnabled()) {
            this.writePageTokens(request, response);
        } else {
            response.sendError(404);
        }
    }

    private void fetchCsrfToken(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession(true);
        CsrfGuard csrfGuard = CsrfGuard.getInstance();
        String token_name = csrfGuard.getTokenName();
        String token_value = (String)session.getAttribute(csrfGuard.getSessionKey());
        String token_pair = token_name + ":" + token_value;
        response.setContentType("text/plain");
        response.getWriter().write(token_pair);
    }

    private void writePageTokens(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession(true);
        Map pageTokens = (Map)session.getAttribute("Owasp_CsrfGuard_Pages_Tokens_Key");
        String pageTokensString = pageTokens != null ? this.parsePageTokens(pageTokens) : "";
        response.setContentType("text/plain");
        response.setContentLength(pageTokensString.length());
        response.getWriter().write(pageTokensString);
    }

    private void writeJavaScript(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession(true);
        CsrfGuard csrfGuard = CsrfGuard.getInstance();
        if (csrfGuard.isRotateEnabled() || csrfGuard.isTokenPerPageEnabled()) {
            response.setHeader("Cache-Control", "no-cache, no-store");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Expires", "0");
        } else {
            response.setHeader("Cache-Control", CsrfGuard.getInstance().getJavascriptCacheControl());
        }
        response.setContentType("text/javascript");
        String code = CsrfGuard.getInstance().getJavascriptTemplateCode();
        String contextPath = servletConfig.getServletContext().getInitParameter(CONTEXT_PATH_PARAM);
        if (contextPath != null && contextPath != "") {
            if (contextPath.trim().charAt(0) != '/') {
                contextPath = "/" + contextPath;
            }
            if (contextPath.trim().charAt(contextPath.length() - 1) == '/') {
                contextPath = contextPath.substring(0, contextPath.length() - 1);
            }
            contextPath = contextPath.trim();
        } else {
            contextPath = request.getContextPath();
        }
        code = code.replace(TOKEN_NAME_IDENTIFIER, CsrfGuardUtils.defaultString(csrfGuard.getTokenName()));
        code = code.replace(TOKEN_VALUE_IDENTIFIER, CsrfGuardUtils.defaultString((String)session.getAttribute(csrfGuard.getSessionKey())));
        code = code.replace(INJECT_INTO_FORMS_IDENTIFIER, Boolean.toString(csrfGuard.isJavascriptInjectIntoForms()));
        code = code.replace(INJECT_GET_FORMS_IDENTIFIER, Boolean.toString(csrfGuard.isJavascriptInjectGetForms()));
        code = code.replace(INJECT_FORM_ATTRIBUTES_IDENTIFIER, Boolean.toString(csrfGuard.isJavascriptInjectFormAttributes()));
        code = code.replace(INJECT_INTO_ATTRIBUTES_IDENTIFIER, Boolean.toString(csrfGuard.isJavascriptInjectIntoAttributes()));
        code = code.replace(INJECT_INTO_XHR_IDENTIFIER, String.valueOf(csrfGuard.isAjaxEnabled()));
        code = code.replace(TOKENS_PER_PAGE_IDENTIFIER, String.valueOf(csrfGuard.isTokenPerPageEnabled()));
        code = code.replace(DOMAIN_ORIGIN_IDENTIFIER, CsrfGuardUtils.defaultString(this.parseDomain(request.getRequestURL())));
        code = code.replace(DOMAIN_STRICT_IDENTIFIER, Boolean.toString(csrfGuard.isJavascriptDomainStrict()));
        code = code.replace(CONTEXT_PATH_IDENTIFIER, CsrfGuardUtils.defaultString(request.getContextPath()));
        code = code.replace(SERVLET_PATH_IDENTIFIER, CsrfGuardUtils.defaultString(contextPath + request.getServletPath()));
        code = code.replace(X_REQUESTED_WITH_IDENTIFIER, CsrfGuardUtils.defaultString(csrfGuard.getJavascriptXrequestedWith()));
        response.getWriter().write(code);
    }

    private String parsePageTokens(Map<String, String> pageTokens) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> keys = pageTokens.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next();
            String value = pageTokens.get(key);
            sb.append(key);
            sb.append(':');
            sb.append(value);
            if (!keys.hasNext()) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    private String parseDomain(StringBuffer url) {
        char character;
        String token = "://";
        int index = url.indexOf(token);
        String part = url.substring(index + token.length());
        StringBuilder domain = new StringBuilder();
        for (int i = 0; i < part.length() && (character = part.charAt(i)) != '/' && character != ':'; ++i) {
            domain.append(character);
        }
        return domain.toString();
    }
}

