/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import COSE.CoseException;
import com.upokecenter.cbor.CBORObject;
import com.yubico.internal.util.CollectionUtil;
import com.yubico.internal.util.ExceptionUtil;
import com.yubico.webauthn.AndroidSafetynetAttestationStatementVerifier;
import com.yubico.webauthn.AppleAttestationStatementVerifier;
import com.yubico.webauthn.AttestationStatementVerifier;
import com.yubico.webauthn.AttestationTrustResolver;
import com.yubico.webauthn.CredentialRepository;
import com.yubico.webauthn.Crypto;
import com.yubico.webauthn.ExtensionsValidation;
import com.yubico.webauthn.FidoU2fAttestationStatementVerifier;
import com.yubico.webauthn.KnownX509TrustAnchorsTrustResolver;
import com.yubico.webauthn.NoneAttestationStatementVerifier;
import com.yubico.webauthn.OriginMatcher;
import com.yubico.webauthn.PackedAttestationStatementVerifier;
import com.yubico.webauthn.RegistrationResult;
import com.yubico.webauthn.TokenBindingValidator;
import com.yubico.webauthn.WebAuthnCodecs;
import com.yubico.webauthn.X5cAttestationStatementVerifier;
import com.yubico.webauthn.attestation.Attestation;
import com.yubico.webauthn.attestation.MetadataService;
import com.yubico.webauthn.data.AttestationObject;
import com.yubico.webauthn.data.AttestationType;
import com.yubico.webauthn.data.AuthenticatorAttestationResponse;
import com.yubico.webauthn.data.AuthenticatorSelectionCriteria;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.ClientRegistrationExtensionOutputs;
import com.yubico.webauthn.data.CollectedClientData;
import com.yubico.webauthn.data.PublicKeyCredential;
import com.yubico.webauthn.data.PublicKeyCredentialCreationOptions;
import com.yubico.webauthn.data.PublicKeyCredentialDescriptor;
import com.yubico.webauthn.data.UserVerificationRequirement;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FinishRegistrationSteps {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FinishRegistrationSteps.class);
    private static final String CLIENT_DATA_TYPE = "webauthn.create";
    private final PublicKeyCredentialCreationOptions request;
    private final PublicKeyCredential<AuthenticatorAttestationResponse, ClientRegistrationExtensionOutputs> response;
    private final Optional<ByteArray> callerTokenBindingId;
    private final Set<String> origins;
    private final String rpId;
    private final boolean allowUntrustedAttestation;
    private final Optional<MetadataService> metadataService;
    private final CredentialRepository credentialRepository;
    private final boolean allowOriginPort;
    private final boolean allowOriginSubdomain;
    private final boolean allowUnrequestedExtensions;

    public Step1 begin() {
        return new Step1();
    }

    public RegistrationResult run() {
        return this.begin().run();
    }

    @Generated
    private static boolean $default$allowOriginPort() {
        return false;
    }

    @Generated
    private static boolean $default$allowOriginSubdomain() {
        return false;
    }

    @Generated
    private static boolean $default$allowUnrequestedExtensions() {
        return false;
    }

    @Generated
    FinishRegistrationSteps(PublicKeyCredentialCreationOptions request, PublicKeyCredential<AuthenticatorAttestationResponse, ClientRegistrationExtensionOutputs> response, Optional<ByteArray> callerTokenBindingId, Set<String> origins, String rpId, boolean allowUntrustedAttestation, Optional<MetadataService> metadataService, CredentialRepository credentialRepository, boolean allowOriginPort, boolean allowOriginSubdomain, boolean allowUnrequestedExtensions) {
        this.request = request;
        this.response = response;
        this.callerTokenBindingId = callerTokenBindingId;
        this.origins = origins;
        this.rpId = rpId;
        this.allowUntrustedAttestation = allowUntrustedAttestation;
        this.metadataService = metadataService;
        this.credentialRepository = credentialRepository;
        this.allowOriginPort = allowOriginPort;
        this.allowOriginSubdomain = allowOriginSubdomain;
        this.allowUnrequestedExtensions = allowUnrequestedExtensions;
    }

    @Generated
    public static FinishRegistrationStepsBuilder builder() {
        return new FinishRegistrationStepsBuilder();
    }

    @Generated
    public static class FinishRegistrationStepsBuilder {
        @Generated
        private PublicKeyCredentialCreationOptions request;
        @Generated
        private PublicKeyCredential<AuthenticatorAttestationResponse, ClientRegistrationExtensionOutputs> response;
        @Generated
        private Optional<ByteArray> callerTokenBindingId;
        @Generated
        private Set<String> origins;
        @Generated
        private String rpId;
        @Generated
        private boolean allowUntrustedAttestation;
        @Generated
        private Optional<MetadataService> metadataService;
        @Generated
        private CredentialRepository credentialRepository;
        @Generated
        private boolean allowOriginPort$set;
        @Generated
        private boolean allowOriginPort$value;
        @Generated
        private boolean allowOriginSubdomain$set;
        @Generated
        private boolean allowOriginSubdomain$value;
        @Generated
        private boolean allowUnrequestedExtensions$set;
        @Generated
        private boolean allowUnrequestedExtensions$value;

        @Generated
        FinishRegistrationStepsBuilder() {
        }

        @Generated
        public FinishRegistrationStepsBuilder request(PublicKeyCredentialCreationOptions request) {
            this.request = request;
            return this;
        }

        @Generated
        public FinishRegistrationStepsBuilder response(PublicKeyCredential<AuthenticatorAttestationResponse, ClientRegistrationExtensionOutputs> response) {
            this.response = response;
            return this;
        }

        @Generated
        public FinishRegistrationStepsBuilder callerTokenBindingId(Optional<ByteArray> callerTokenBindingId) {
            this.callerTokenBindingId = callerTokenBindingId;
            return this;
        }

        @Generated
        public FinishRegistrationStepsBuilder origins(Set<String> origins) {
            this.origins = origins;
            return this;
        }

        @Generated
        public FinishRegistrationStepsBuilder rpId(String rpId) {
            this.rpId = rpId;
            return this;
        }

        @Generated
        public FinishRegistrationStepsBuilder allowUntrustedAttestation(boolean allowUntrustedAttestation) {
            this.allowUntrustedAttestation = allowUntrustedAttestation;
            return this;
        }

        @Generated
        public FinishRegistrationStepsBuilder metadataService(Optional<MetadataService> metadataService) {
            this.metadataService = metadataService;
            return this;
        }

        @Generated
        public FinishRegistrationStepsBuilder credentialRepository(CredentialRepository credentialRepository) {
            this.credentialRepository = credentialRepository;
            return this;
        }

        @Generated
        public FinishRegistrationStepsBuilder allowOriginPort(boolean allowOriginPort) {
            this.allowOriginPort$value = allowOriginPort;
            this.allowOriginPort$set = true;
            return this;
        }

        @Generated
        public FinishRegistrationStepsBuilder allowOriginSubdomain(boolean allowOriginSubdomain) {
            this.allowOriginSubdomain$value = allowOriginSubdomain;
            this.allowOriginSubdomain$set = true;
            return this;
        }

        @Generated
        public FinishRegistrationStepsBuilder allowUnrequestedExtensions(boolean allowUnrequestedExtensions) {
            this.allowUnrequestedExtensions$value = allowUnrequestedExtensions;
            this.allowUnrequestedExtensions$set = true;
            return this;
        }

        @Generated
        public FinishRegistrationSteps build() {
            boolean allowOriginPort$value = this.allowOriginPort$value;
            if (!this.allowOriginPort$set) {
                allowOriginPort$value = FinishRegistrationSteps.$default$allowOriginPort();
            }
            boolean allowOriginSubdomain$value = this.allowOriginSubdomain$value;
            if (!this.allowOriginSubdomain$set) {
                allowOriginSubdomain$value = FinishRegistrationSteps.$default$allowOriginSubdomain();
            }
            boolean allowUnrequestedExtensions$value = this.allowUnrequestedExtensions$value;
            if (!this.allowUnrequestedExtensions$set) {
                allowUnrequestedExtensions$value = FinishRegistrationSteps.$default$allowUnrequestedExtensions();
            }
            return new FinishRegistrationSteps(this.request, this.response, this.callerTokenBindingId, this.origins, this.rpId, this.allowUntrustedAttestation, this.metadataService, this.credentialRepository, allowOriginPort$value, allowOriginSubdomain$value, allowUnrequestedExtensions$value);
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.FinishRegistrationStepsBuilder(request=" + this.request + ", response=" + this.response + ", callerTokenBindingId=" + this.callerTokenBindingId + ", origins=" + this.origins + ", rpId=" + this.rpId + ", allowUntrustedAttestation=" + this.allowUntrustedAttestation + ", metadataService=" + this.metadataService + ", credentialRepository=" + this.credentialRepository + ", allowOriginPort$value=" + this.allowOriginPort$value + ", allowOriginSubdomain$value=" + this.allowOriginSubdomain$value + ", allowUnrequestedExtensions$value=" + this.allowUnrequestedExtensions$value + ")";
        }
    }

    final class Finished
    implements Step<Finished> {
        private final AttestationType attestationType;
        private final Optional<Attestation> attestationMetadata;
        private final boolean attestationTrusted;
        private final List<String> prevWarnings;

        @Override
        public void validate() {
        }

        @Override
        public Finished nextStep() {
            return this;
        }

        @Override
        public Optional<RegistrationResult> result() {
            return Optional.of(RegistrationResult.builder().keyId(this.keyId()).attestationTrusted(this.attestationTrusted).attestationType(this.attestationType).publicKeyCose(((AuthenticatorAttestationResponse)FinishRegistrationSteps.this.response.getResponse()).getAttestation().getAuthenticatorData().getAttestedCredentialData().get().getCredentialPublicKey()).attestationMetadata(this.attestationMetadata).warnings(this.allWarnings()).build());
        }

        private PublicKeyCredentialDescriptor keyId() {
            return PublicKeyCredentialDescriptor.builder().id(FinishRegistrationSteps.this.response.getId()).type(FinishRegistrationSteps.this.response.getType()).build();
        }

        @Generated
        public Finished(AttestationType attestationType, Optional<Attestation> attestationMetadata, boolean attestationTrusted, List<String> prevWarnings) {
            this.attestationType = attestationType;
            this.attestationMetadata = attestationMetadata;
            this.attestationTrusted = attestationTrusted;
            this.prevWarnings = prevWarnings;
        }

        @Generated
        public AttestationType getAttestationType() {
            return this.attestationType;
        }

        @Generated
        public Optional<Attestation> getAttestationMetadata() {
            return this.attestationMetadata;
        }

        @Generated
        public boolean isAttestationTrusted() {
            return this.attestationTrusted;
        }

        @Override
        @Generated
        public List<String> getPrevWarnings() {
            return this.prevWarnings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Finished)) {
                return false;
            }
            Finished other = (Finished)o;
            if (this.isAttestationTrusted() != other.isAttestationTrusted()) {
                return false;
            }
            AttestationType this$attestationType = this.getAttestationType();
            AttestationType other$attestationType = other.getAttestationType();
            if (this$attestationType == null ? other$attestationType != null : !((Object)((Object)this$attestationType)).equals((Object)other$attestationType)) {
                return false;
            }
            Optional<Attestation> this$attestationMetadata = this.getAttestationMetadata();
            Optional<Attestation> other$attestationMetadata = other.getAttestationMetadata();
            if (this$attestationMetadata == null ? other$attestationMetadata != null : !((Object)this$attestationMetadata).equals(other$attestationMetadata)) {
                return false;
            }
            List<String> this$prevWarnings = this.getPrevWarnings();
            List<String> other$prevWarnings = other.getPrevWarnings();
            return !(this$prevWarnings == null ? other$prevWarnings != null : !((Object)this$prevWarnings).equals(other$prevWarnings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAttestationTrusted() ? 79 : 97);
            AttestationType $attestationType = this.getAttestationType();
            result = result * 59 + ($attestationType == null ? 43 : ((Object)((Object)$attestationType)).hashCode());
            Optional<Attestation> $attestationMetadata = this.getAttestationMetadata();
            result = result * 59 + ($attestationMetadata == null ? 43 : ((Object)$attestationMetadata).hashCode());
            List<String> $prevWarnings = this.getPrevWarnings();
            result = result * 59 + ($prevWarnings == null ? 43 : ((Object)$prevWarnings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Finished(attestationType=" + (Object)((Object)this.getAttestationType()) + ", attestationMetadata=" + this.getAttestationMetadata() + ", attestationTrusted=" + this.isAttestationTrusted() + ", prevWarnings=" + this.getPrevWarnings() + ")";
        }
    }

    final class CustomLastStep
    implements Step<Finished> {
        private final AttestationType attestationType;
        private final Optional<Attestation> attestationMetadata;
        private final boolean attestationTrusted;
        private final List<String> prevWarnings;

        @Override
        public void validate() {
            ByteArray publicKeyCose = ((AuthenticatorAttestationResponse)FinishRegistrationSteps.this.response.getResponse()).getAttestation().getAuthenticatorData().getAttestedCredentialData().get().getCredentialPublicKey();
            CBORObject publicKeyCbor = CBORObject.DecodeFromBytes((byte[])publicKeyCose.getBytes());
            int alg = publicKeyCbor.get(CBORObject.FromObject((int)3)).AsInt32();
            ExceptionUtil.assure(FinishRegistrationSteps.this.request.getPubKeyCredParams().stream().anyMatch(pkcparam -> pkcparam.getAlg().getId() == (long)alg), "Unrequested credential key algorithm: got %d, expected one of: %s", alg, FinishRegistrationSteps.this.request.getPubKeyCredParams().stream().map(pkcparam -> pkcparam.getAlg()).collect(Collectors.toList()));
            try {
                WebAuthnCodecs.importCosePublicKey(publicKeyCose);
            }
            catch (CoseException | IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
                throw ExceptionUtil.wrapAndLog(log, "Failed to parse credential public key", e);
            }
        }

        @Override
        public Finished nextStep() {
            return new Finished(this.attestationType, this.attestationMetadata, this.attestationTrusted, this.allWarnings());
        }

        @Generated
        public CustomLastStep(AttestationType attestationType, Optional<Attestation> attestationMetadata, boolean attestationTrusted, List<String> prevWarnings) {
            this.attestationType = attestationType;
            this.attestationMetadata = attestationMetadata;
            this.attestationTrusted = attestationTrusted;
            this.prevWarnings = prevWarnings;
        }

        @Generated
        public AttestationType getAttestationType() {
            return this.attestationType;
        }

        @Generated
        public Optional<Attestation> getAttestationMetadata() {
            return this.attestationMetadata;
        }

        @Generated
        public boolean isAttestationTrusted() {
            return this.attestationTrusted;
        }

        @Override
        @Generated
        public List<String> getPrevWarnings() {
            return this.prevWarnings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomLastStep)) {
                return false;
            }
            CustomLastStep other = (CustomLastStep)o;
            if (this.isAttestationTrusted() != other.isAttestationTrusted()) {
                return false;
            }
            AttestationType this$attestationType = this.getAttestationType();
            AttestationType other$attestationType = other.getAttestationType();
            if (this$attestationType == null ? other$attestationType != null : !((Object)((Object)this$attestationType)).equals((Object)other$attestationType)) {
                return false;
            }
            Optional<Attestation> this$attestationMetadata = this.getAttestationMetadata();
            Optional<Attestation> other$attestationMetadata = other.getAttestationMetadata();
            if (this$attestationMetadata == null ? other$attestationMetadata != null : !((Object)this$attestationMetadata).equals(other$attestationMetadata)) {
                return false;
            }
            List<String> this$prevWarnings = this.getPrevWarnings();
            List<String> other$prevWarnings = other.getPrevWarnings();
            return !(this$prevWarnings == null ? other$prevWarnings != null : !((Object)this$prevWarnings).equals(other$prevWarnings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAttestationTrusted() ? 79 : 97);
            AttestationType $attestationType = this.getAttestationType();
            result = result * 59 + ($attestationType == null ? 43 : ((Object)((Object)$attestationType)).hashCode());
            Optional<Attestation> $attestationMetadata = this.getAttestationMetadata();
            result = result * 59 + ($attestationMetadata == null ? 43 : ((Object)$attestationMetadata).hashCode());
            List<String> $prevWarnings = this.getPrevWarnings();
            result = result * 59 + ($prevWarnings == null ? 43 : ((Object)$prevWarnings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.CustomLastStep(attestationType=" + (Object)((Object)this.getAttestationType()) + ", attestationMetadata=" + this.getAttestationMetadata() + ", attestationTrusted=" + this.isAttestationTrusted() + ", prevWarnings=" + this.getPrevWarnings() + ")";
        }
    }

    final class Step19
    implements Step<CustomLastStep> {
        private final AttestationType attestationType;
        private final Optional<Attestation> attestationMetadata;
        private final boolean attestationTrusted;
        private final List<String> prevWarnings;

        @Override
        public void validate() {
        }

        @Override
        public CustomLastStep nextStep() {
            return new CustomLastStep(this.attestationType, this.attestationMetadata, this.attestationTrusted, this.allWarnings());
        }

        @Generated
        public Step19(AttestationType attestationType, Optional<Attestation> attestationMetadata, boolean attestationTrusted, List<String> prevWarnings) {
            this.attestationType = attestationType;
            this.attestationMetadata = attestationMetadata;
            this.attestationTrusted = attestationTrusted;
            this.prevWarnings = prevWarnings;
        }

        @Generated
        public AttestationType getAttestationType() {
            return this.attestationType;
        }

        @Generated
        public Optional<Attestation> getAttestationMetadata() {
            return this.attestationMetadata;
        }

        @Generated
        public boolean isAttestationTrusted() {
            return this.attestationTrusted;
        }

        @Override
        @Generated
        public List<String> getPrevWarnings() {
            return this.prevWarnings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step19)) {
                return false;
            }
            Step19 other = (Step19)o;
            if (this.isAttestationTrusted() != other.isAttestationTrusted()) {
                return false;
            }
            AttestationType this$attestationType = this.getAttestationType();
            AttestationType other$attestationType = other.getAttestationType();
            if (this$attestationType == null ? other$attestationType != null : !((Object)((Object)this$attestationType)).equals((Object)other$attestationType)) {
                return false;
            }
            Optional<Attestation> this$attestationMetadata = this.getAttestationMetadata();
            Optional<Attestation> other$attestationMetadata = other.getAttestationMetadata();
            if (this$attestationMetadata == null ? other$attestationMetadata != null : !((Object)this$attestationMetadata).equals(other$attestationMetadata)) {
                return false;
            }
            List<String> this$prevWarnings = this.getPrevWarnings();
            List<String> other$prevWarnings = other.getPrevWarnings();
            return !(this$prevWarnings == null ? other$prevWarnings != null : !((Object)this$prevWarnings).equals(other$prevWarnings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAttestationTrusted() ? 79 : 97);
            AttestationType $attestationType = this.getAttestationType();
            result = result * 59 + ($attestationType == null ? 43 : ((Object)((Object)$attestationType)).hashCode());
            Optional<Attestation> $attestationMetadata = this.getAttestationMetadata();
            result = result * 59 + ($attestationMetadata == null ? 43 : ((Object)$attestationMetadata).hashCode());
            List<String> $prevWarnings = this.getPrevWarnings();
            result = result * 59 + ($prevWarnings == null ? 43 : ((Object)$prevWarnings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Step19(attestationType=" + (Object)((Object)this.getAttestationType()) + ", attestationMetadata=" + this.getAttestationMetadata() + ", attestationTrusted=" + this.isAttestationTrusted() + ", prevWarnings=" + this.getPrevWarnings() + ")";
        }
    }

    final class Step18
    implements Step<Step19> {
        private final AttestationType attestationType;
        private final Optional<Attestation> attestationMetadata;
        private final boolean attestationTrusted;
        private final List<String> prevWarnings;

        @Override
        public void validate() {
        }

        @Override
        public Step19 nextStep() {
            return new Step19(this.attestationType, this.attestationMetadata, this.attestationTrusted, this.allWarnings());
        }

        @Generated
        public Step18(AttestationType attestationType, Optional<Attestation> attestationMetadata, boolean attestationTrusted, List<String> prevWarnings) {
            this.attestationType = attestationType;
            this.attestationMetadata = attestationMetadata;
            this.attestationTrusted = attestationTrusted;
            this.prevWarnings = prevWarnings;
        }

        @Generated
        public AttestationType getAttestationType() {
            return this.attestationType;
        }

        @Generated
        public Optional<Attestation> getAttestationMetadata() {
            return this.attestationMetadata;
        }

        @Generated
        public boolean isAttestationTrusted() {
            return this.attestationTrusted;
        }

        @Override
        @Generated
        public List<String> getPrevWarnings() {
            return this.prevWarnings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step18)) {
                return false;
            }
            Step18 other = (Step18)o;
            if (this.isAttestationTrusted() != other.isAttestationTrusted()) {
                return false;
            }
            AttestationType this$attestationType = this.getAttestationType();
            AttestationType other$attestationType = other.getAttestationType();
            if (this$attestationType == null ? other$attestationType != null : !((Object)((Object)this$attestationType)).equals((Object)other$attestationType)) {
                return false;
            }
            Optional<Attestation> this$attestationMetadata = this.getAttestationMetadata();
            Optional<Attestation> other$attestationMetadata = other.getAttestationMetadata();
            if (this$attestationMetadata == null ? other$attestationMetadata != null : !((Object)this$attestationMetadata).equals(other$attestationMetadata)) {
                return false;
            }
            List<String> this$prevWarnings = this.getPrevWarnings();
            List<String> other$prevWarnings = other.getPrevWarnings();
            return !(this$prevWarnings == null ? other$prevWarnings != null : !((Object)this$prevWarnings).equals(other$prevWarnings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAttestationTrusted() ? 79 : 97);
            AttestationType $attestationType = this.getAttestationType();
            result = result * 59 + ($attestationType == null ? 43 : ((Object)((Object)$attestationType)).hashCode());
            Optional<Attestation> $attestationMetadata = this.getAttestationMetadata();
            result = result * 59 + ($attestationMetadata == null ? 43 : ((Object)$attestationMetadata).hashCode());
            List<String> $prevWarnings = this.getPrevWarnings();
            result = result * 59 + ($prevWarnings == null ? 43 : ((Object)$prevWarnings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Step18(attestationType=" + (Object)((Object)this.getAttestationType()) + ", attestationMetadata=" + this.getAttestationMetadata() + ", attestationTrusted=" + this.isAttestationTrusted() + ", prevWarnings=" + this.getPrevWarnings() + ")";
        }
    }

    final class Step17
    implements Step<Step18> {
        private final AttestationType attestationType;
        private final Optional<Attestation> attestationMetadata;
        private final boolean attestationTrusted;
        private final List<String> prevWarnings;

        @Override
        public void validate() {
            ExceptionUtil.assure(FinishRegistrationSteps.this.credentialRepository.lookupAll(FinishRegistrationSteps.this.response.getId()).isEmpty(), "Credential ID is already registered: %s", FinishRegistrationSteps.this.response.getId());
        }

        @Override
        public Step18 nextStep() {
            return new Step18(this.attestationType, this.attestationMetadata, this.attestationTrusted, this.allWarnings());
        }

        @Generated
        public Step17(AttestationType attestationType, Optional<Attestation> attestationMetadata, boolean attestationTrusted, List<String> prevWarnings) {
            this.attestationType = attestationType;
            this.attestationMetadata = attestationMetadata;
            this.attestationTrusted = attestationTrusted;
            this.prevWarnings = prevWarnings;
        }

        @Generated
        public AttestationType getAttestationType() {
            return this.attestationType;
        }

        @Generated
        public Optional<Attestation> getAttestationMetadata() {
            return this.attestationMetadata;
        }

        @Generated
        public boolean isAttestationTrusted() {
            return this.attestationTrusted;
        }

        @Override
        @Generated
        public List<String> getPrevWarnings() {
            return this.prevWarnings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step17)) {
                return false;
            }
            Step17 other = (Step17)o;
            if (this.isAttestationTrusted() != other.isAttestationTrusted()) {
                return false;
            }
            AttestationType this$attestationType = this.getAttestationType();
            AttestationType other$attestationType = other.getAttestationType();
            if (this$attestationType == null ? other$attestationType != null : !((Object)((Object)this$attestationType)).equals((Object)other$attestationType)) {
                return false;
            }
            Optional<Attestation> this$attestationMetadata = this.getAttestationMetadata();
            Optional<Attestation> other$attestationMetadata = other.getAttestationMetadata();
            if (this$attestationMetadata == null ? other$attestationMetadata != null : !((Object)this$attestationMetadata).equals(other$attestationMetadata)) {
                return false;
            }
            List<String> this$prevWarnings = this.getPrevWarnings();
            List<String> other$prevWarnings = other.getPrevWarnings();
            return !(this$prevWarnings == null ? other$prevWarnings != null : !((Object)this$prevWarnings).equals(other$prevWarnings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAttestationTrusted() ? 79 : 97);
            AttestationType $attestationType = this.getAttestationType();
            result = result * 59 + ($attestationType == null ? 43 : ((Object)((Object)$attestationType)).hashCode());
            Optional<Attestation> $attestationMetadata = this.getAttestationMetadata();
            result = result * 59 + ($attestationMetadata == null ? 43 : ((Object)$attestationMetadata).hashCode());
            List<String> $prevWarnings = this.getPrevWarnings();
            result = result * 59 + ($prevWarnings == null ? 43 : ((Object)$prevWarnings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Step17(attestationType=" + (Object)((Object)this.getAttestationType()) + ", attestationMetadata=" + this.getAttestationMetadata() + ", attestationTrusted=" + this.isAttestationTrusted() + ", prevWarnings=" + this.getPrevWarnings() + ")";
        }
    }

    final class Step16
    implements Step<Step17> {
        private final AttestationObject attestation;
        private final AttestationType attestationType;
        private final Optional<List<X509Certificate>> attestationTrustPath;
        private final Optional<AttestationTrustResolver> trustResolver;
        private final List<String> prevWarnings;

        @Override
        public void validate() {
            ExceptionUtil.assure(this.trustResolver.isPresent() || FinishRegistrationSteps.this.allowUntrustedAttestation, "Failed to obtain attestation trust anchors.", new Object[0]);
            switch (this.attestationType) {
                case SELF_ATTESTATION: {
                    ExceptionUtil.assure(FinishRegistrationSteps.this.allowUntrustedAttestation, "Self attestation is not allowed.", new Object[0]);
                    break;
                }
                case ANONYMIZATION_CA: 
                case ATTESTATION_CA: 
                case BASIC: {
                    ExceptionUtil.assure(FinishRegistrationSteps.this.allowUntrustedAttestation || this.attestationTrusted(), "Failed to derive trust for attestation key.", new Object[0]);
                    break;
                }
                case NONE: {
                    ExceptionUtil.assure(FinishRegistrationSteps.this.allowUntrustedAttestation, "No attestation is not allowed.", new Object[0]);
                    break;
                }
                case UNKNOWN: {
                    ExceptionUtil.assure(FinishRegistrationSteps.this.allowUntrustedAttestation, "Unknown attestation statement formats are not allowed.", new Object[0]);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Attestation type not implemented: " + (Object)((Object)this.attestationType));
                }
            }
        }

        @Override
        public Step17 nextStep() {
            return new Step17(this.attestationType, this.attestationMetadata(), this.attestationTrusted(), this.allWarnings());
        }

        public boolean attestationTrusted() {
            switch (this.attestationType) {
                case NONE: 
                case SELF_ATTESTATION: 
                case UNKNOWN: {
                    return false;
                }
                case ANONYMIZATION_CA: 
                case ATTESTATION_CA: 
                case BASIC: {
                    return this.attestationMetadata().filter(Attestation::isTrusted).isPresent();
                }
            }
            throw new UnsupportedOperationException("Attestation type not implemented: " + (Object)((Object)this.attestationType));
        }

        public Optional<Attestation> attestationMetadata() {
            return this.trustResolver.flatMap(tr -> {
                try {
                    return Optional.of(tr.resolveTrustAnchor(this.attestationTrustPath.orElseGet(Collections::emptyList)));
                }
                catch (CertificateEncodingException e) {
                    log.debug("Failed to resolve trust anchor for attestation: {}", (Object)this.attestation, (Object)e);
                    return Optional.empty();
                }
            });
        }

        @Override
        public List<String> getWarnings() {
            return this.trustResolver.map(tr -> {
                try {
                    tr.resolveTrustAnchor(this.attestationTrustPath.orElseGet(Collections::emptyList));
                    return Collections.emptyList();
                }
                catch (CertificateEncodingException e) {
                    return Collections.singletonList("Failed to resolve trust anchor: " + e);
                }
            }).orElseGet(Collections::emptyList);
        }

        @Generated
        public Step16(AttestationObject attestation, AttestationType attestationType, Optional<List<X509Certificate>> attestationTrustPath, Optional<AttestationTrustResolver> trustResolver, List<String> prevWarnings) {
            this.attestation = attestation;
            this.attestationType = attestationType;
            this.attestationTrustPath = attestationTrustPath;
            this.trustResolver = trustResolver;
            this.prevWarnings = prevWarnings;
        }

        @Generated
        public AttestationObject getAttestation() {
            return this.attestation;
        }

        @Generated
        public AttestationType getAttestationType() {
            return this.attestationType;
        }

        @Generated
        public Optional<List<X509Certificate>> getAttestationTrustPath() {
            return this.attestationTrustPath;
        }

        @Generated
        public Optional<AttestationTrustResolver> getTrustResolver() {
            return this.trustResolver;
        }

        @Override
        @Generated
        public List<String> getPrevWarnings() {
            return this.prevWarnings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step16)) {
                return false;
            }
            Step16 other = (Step16)o;
            AttestationObject this$attestation = this.getAttestation();
            AttestationObject other$attestation = other.getAttestation();
            if (this$attestation == null ? other$attestation != null : !((Object)this$attestation).equals(other$attestation)) {
                return false;
            }
            AttestationType this$attestationType = this.getAttestationType();
            AttestationType other$attestationType = other.getAttestationType();
            if (this$attestationType == null ? other$attestationType != null : !((Object)((Object)this$attestationType)).equals((Object)other$attestationType)) {
                return false;
            }
            Optional<List<X509Certificate>> this$attestationTrustPath = this.getAttestationTrustPath();
            Optional<List<X509Certificate>> other$attestationTrustPath = other.getAttestationTrustPath();
            if (this$attestationTrustPath == null ? other$attestationTrustPath != null : !((Object)this$attestationTrustPath).equals(other$attestationTrustPath)) {
                return false;
            }
            Optional<AttestationTrustResolver> this$trustResolver = this.getTrustResolver();
            Optional<AttestationTrustResolver> other$trustResolver = other.getTrustResolver();
            if (this$trustResolver == null ? other$trustResolver != null : !((Object)this$trustResolver).equals(other$trustResolver)) {
                return false;
            }
            List<String> this$prevWarnings = this.getPrevWarnings();
            List<String> other$prevWarnings = other.getPrevWarnings();
            return !(this$prevWarnings == null ? other$prevWarnings != null : !((Object)this$prevWarnings).equals(other$prevWarnings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AttestationObject $attestation = this.getAttestation();
            result = result * 59 + ($attestation == null ? 43 : ((Object)$attestation).hashCode());
            AttestationType $attestationType = this.getAttestationType();
            result = result * 59 + ($attestationType == null ? 43 : ((Object)((Object)$attestationType)).hashCode());
            Optional<List<X509Certificate>> $attestationTrustPath = this.getAttestationTrustPath();
            result = result * 59 + ($attestationTrustPath == null ? 43 : ((Object)$attestationTrustPath).hashCode());
            Optional<AttestationTrustResolver> $trustResolver = this.getTrustResolver();
            result = result * 59 + ($trustResolver == null ? 43 : ((Object)$trustResolver).hashCode());
            List<String> $prevWarnings = this.getPrevWarnings();
            result = result * 59 + ($prevWarnings == null ? 43 : ((Object)$prevWarnings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Step16(attestation=" + this.getAttestation() + ", attestationType=" + (Object)((Object)this.getAttestationType()) + ", attestationTrustPath=" + this.getAttestationTrustPath() + ", trustResolver=" + this.getTrustResolver() + ", prevWarnings=" + this.getPrevWarnings() + ")";
        }
    }

    final class Step15
    implements Step<Step16> {
        private final AttestationObject attestation;
        private final AttestationType attestationType;
        private final Optional<List<X509Certificate>> attestationTrustPath;
        private final List<String> prevWarnings;

        @Override
        public void validate() {
        }

        @Override
        public Step16 nextStep() {
            return new Step16(this.attestation, this.attestationType, this.attestationTrustPath, this.trustResolver(), this.allWarnings());
        }

        public Optional<AttestationTrustResolver> trustResolver() {
            switch (this.attestationType) {
                case NONE: 
                case SELF_ATTESTATION: 
                case UNKNOWN: {
                    return Optional.empty();
                }
                case ANONYMIZATION_CA: 
                case ATTESTATION_CA: 
                case BASIC: {
                    switch (this.attestation.getFormat()) {
                        case "android-key": 
                        case "android-safetynet": 
                        case "apple": 
                        case "fido-u2f": 
                        case "packed": 
                        case "tpm": {
                            return FinishRegistrationSteps.this.metadataService.map(KnownX509TrustAnchorsTrustResolver::new);
                        }
                    }
                    throw new UnsupportedOperationException(String.format("Attestation type %s is not supported for attestation statement format \"%s\".", new Object[]{this.attestationType, this.attestation.getFormat()}));
                }
            }
            throw new UnsupportedOperationException("Attestation type not implemented: " + (Object)((Object)this.attestationType));
        }

        @Generated
        public Step15(AttestationObject attestation, AttestationType attestationType, Optional<List<X509Certificate>> attestationTrustPath, List<String> prevWarnings) {
            this.attestation = attestation;
            this.attestationType = attestationType;
            this.attestationTrustPath = attestationTrustPath;
            this.prevWarnings = prevWarnings;
        }

        @Generated
        public AttestationObject getAttestation() {
            return this.attestation;
        }

        @Generated
        public AttestationType getAttestationType() {
            return this.attestationType;
        }

        @Generated
        public Optional<List<X509Certificate>> getAttestationTrustPath() {
            return this.attestationTrustPath;
        }

        @Override
        @Generated
        public List<String> getPrevWarnings() {
            return this.prevWarnings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step15)) {
                return false;
            }
            Step15 other = (Step15)o;
            AttestationObject this$attestation = this.getAttestation();
            AttestationObject other$attestation = other.getAttestation();
            if (this$attestation == null ? other$attestation != null : !((Object)this$attestation).equals(other$attestation)) {
                return false;
            }
            AttestationType this$attestationType = this.getAttestationType();
            AttestationType other$attestationType = other.getAttestationType();
            if (this$attestationType == null ? other$attestationType != null : !((Object)((Object)this$attestationType)).equals((Object)other$attestationType)) {
                return false;
            }
            Optional<List<X509Certificate>> this$attestationTrustPath = this.getAttestationTrustPath();
            Optional<List<X509Certificate>> other$attestationTrustPath = other.getAttestationTrustPath();
            if (this$attestationTrustPath == null ? other$attestationTrustPath != null : !((Object)this$attestationTrustPath).equals(other$attestationTrustPath)) {
                return false;
            }
            List<String> this$prevWarnings = this.getPrevWarnings();
            List<String> other$prevWarnings = other.getPrevWarnings();
            return !(this$prevWarnings == null ? other$prevWarnings != null : !((Object)this$prevWarnings).equals(other$prevWarnings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AttestationObject $attestation = this.getAttestation();
            result = result * 59 + ($attestation == null ? 43 : ((Object)$attestation).hashCode());
            AttestationType $attestationType = this.getAttestationType();
            result = result * 59 + ($attestationType == null ? 43 : ((Object)((Object)$attestationType)).hashCode());
            Optional<List<X509Certificate>> $attestationTrustPath = this.getAttestationTrustPath();
            result = result * 59 + ($attestationTrustPath == null ? 43 : ((Object)$attestationTrustPath).hashCode());
            List<String> $prevWarnings = this.getPrevWarnings();
            result = result * 59 + ($prevWarnings == null ? 43 : ((Object)$prevWarnings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Step15(attestation=" + this.getAttestation() + ", attestationType=" + (Object)((Object)this.getAttestationType()) + ", attestationTrustPath=" + this.getAttestationTrustPath() + ", prevWarnings=" + this.getPrevWarnings() + ")";
        }
    }

    final class Step14
    implements Step<Step15> {
        private final ByteArray clientDataJsonHash;
        private final AttestationObject attestation;
        private final Optional<AttestationStatementVerifier> attestationStatementVerifier;
        private final List<String> prevWarnings;

        @Override
        public void validate() {
            this.attestationStatementVerifier.ifPresent(verifier -> ExceptionUtil.assure(verifier.verifyAttestationSignature(this.attestation, this.clientDataJsonHash), "Invalid attestation signature.", new Object[0]));
            ExceptionUtil.assure(this.attestationType() != null, "Failed to determine attestation type", new Object[0]);
        }

        @Override
        public Step15 nextStep() {
            return new Step15(this.attestation, this.attestationType(), this.attestationTrustPath(), this.allWarnings());
        }

        public AttestationType attestationType() {
            try {
                if (this.attestationStatementVerifier.isPresent()) {
                    return this.attestationStatementVerifier.get().getAttestationType(this.attestation);
                }
                switch (this.attestation.getFormat()) {
                    case "android-key": {
                        return AttestationType.BASIC;
                    }
                    case "tpm": {
                        if (this.attestation.getAttestationStatement().has("x5c")) {
                            return AttestationType.ATTESTATION_CA;
                        }
                        return AttestationType.ECDAA;
                    }
                }
                return AttestationType.UNKNOWN;
            }
            catch (CoseException | IOException | CertificateException e) {
                throw new IllegalArgumentException("Failed to resolve attestation type.", e);
            }
        }

        public Optional<List<X509Certificate>> attestationTrustPath() {
            if (this.attestationStatementVerifier.isPresent()) {
                AttestationStatementVerifier verifier = this.attestationStatementVerifier.get();
                if (verifier instanceof X5cAttestationStatementVerifier) {
                    try {
                        return ((X5cAttestationStatementVerifier)((Object)verifier)).getAttestationTrustPath(this.attestation);
                    }
                    catch (CertificateException e) {
                        throw new IllegalArgumentException("Failed to resolve attestation trust path.", e);
                    }
                }
                return Optional.empty();
            }
            return Optional.empty();
        }

        @Generated
        public Step14(ByteArray clientDataJsonHash, AttestationObject attestation, Optional<AttestationStatementVerifier> attestationStatementVerifier, List<String> prevWarnings) {
            this.clientDataJsonHash = clientDataJsonHash;
            this.attestation = attestation;
            this.attestationStatementVerifier = attestationStatementVerifier;
            this.prevWarnings = prevWarnings;
        }

        @Generated
        public ByteArray getClientDataJsonHash() {
            return this.clientDataJsonHash;
        }

        @Generated
        public AttestationObject getAttestation() {
            return this.attestation;
        }

        @Generated
        public Optional<AttestationStatementVerifier> getAttestationStatementVerifier() {
            return this.attestationStatementVerifier;
        }

        @Override
        @Generated
        public List<String> getPrevWarnings() {
            return this.prevWarnings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step14)) {
                return false;
            }
            Step14 other = (Step14)o;
            ByteArray this$clientDataJsonHash = this.getClientDataJsonHash();
            ByteArray other$clientDataJsonHash = other.getClientDataJsonHash();
            if (this$clientDataJsonHash == null ? other$clientDataJsonHash != null : !((Object)this$clientDataJsonHash).equals(other$clientDataJsonHash)) {
                return false;
            }
            AttestationObject this$attestation = this.getAttestation();
            AttestationObject other$attestation = other.getAttestation();
            if (this$attestation == null ? other$attestation != null : !((Object)this$attestation).equals(other$attestation)) {
                return false;
            }
            Optional<AttestationStatementVerifier> this$attestationStatementVerifier = this.getAttestationStatementVerifier();
            Optional<AttestationStatementVerifier> other$attestationStatementVerifier = other.getAttestationStatementVerifier();
            if (this$attestationStatementVerifier == null ? other$attestationStatementVerifier != null : !((Object)this$attestationStatementVerifier).equals(other$attestationStatementVerifier)) {
                return false;
            }
            List<String> this$prevWarnings = this.getPrevWarnings();
            List<String> other$prevWarnings = other.getPrevWarnings();
            return !(this$prevWarnings == null ? other$prevWarnings != null : !((Object)this$prevWarnings).equals(other$prevWarnings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ByteArray $clientDataJsonHash = this.getClientDataJsonHash();
            result = result * 59 + ($clientDataJsonHash == null ? 43 : ((Object)$clientDataJsonHash).hashCode());
            AttestationObject $attestation = this.getAttestation();
            result = result * 59 + ($attestation == null ? 43 : ((Object)$attestation).hashCode());
            Optional<AttestationStatementVerifier> $attestationStatementVerifier = this.getAttestationStatementVerifier();
            result = result * 59 + ($attestationStatementVerifier == null ? 43 : ((Object)$attestationStatementVerifier).hashCode());
            List<String> $prevWarnings = this.getPrevWarnings();
            result = result * 59 + ($prevWarnings == null ? 43 : ((Object)$prevWarnings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Step14(clientDataJsonHash=" + this.getClientDataJsonHash() + ", attestation=" + this.getAttestation() + ", attestationStatementVerifier=" + this.getAttestationStatementVerifier() + ", prevWarnings=" + this.getPrevWarnings() + ")";
        }
    }

    final class Step13
    implements Step<Step14> {
        private final ByteArray clientDataJsonHash;
        private final AttestationObject attestation;
        private final List<String> prevWarnings;

        @Override
        public void validate() {
        }

        @Override
        public Step14 nextStep() {
            return new Step14(this.clientDataJsonHash, this.attestation, this.attestationStatementVerifier(), this.allWarnings());
        }

        public String format() {
            return this.attestation.getFormat();
        }

        public Optional<AttestationStatementVerifier> attestationStatementVerifier() {
            switch (this.format()) {
                case "fido-u2f": {
                    return Optional.of(new FidoU2fAttestationStatementVerifier());
                }
                case "none": {
                    return Optional.of(new NoneAttestationStatementVerifier());
                }
                case "packed": {
                    return Optional.of(new PackedAttestationStatementVerifier());
                }
                case "android-safetynet": {
                    return Optional.of(new AndroidSafetynetAttestationStatementVerifier());
                }
                case "apple": {
                    return Optional.of(new AppleAttestationStatementVerifier());
                }
            }
            return Optional.empty();
        }

        @Generated
        public Step13(ByteArray clientDataJsonHash, AttestationObject attestation, List<String> prevWarnings) {
            this.clientDataJsonHash = clientDataJsonHash;
            this.attestation = attestation;
            this.prevWarnings = prevWarnings;
        }

        @Generated
        public ByteArray getClientDataJsonHash() {
            return this.clientDataJsonHash;
        }

        @Generated
        public AttestationObject getAttestation() {
            return this.attestation;
        }

        @Override
        @Generated
        public List<String> getPrevWarnings() {
            return this.prevWarnings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step13)) {
                return false;
            }
            Step13 other = (Step13)o;
            ByteArray this$clientDataJsonHash = this.getClientDataJsonHash();
            ByteArray other$clientDataJsonHash = other.getClientDataJsonHash();
            if (this$clientDataJsonHash == null ? other$clientDataJsonHash != null : !((Object)this$clientDataJsonHash).equals(other$clientDataJsonHash)) {
                return false;
            }
            AttestationObject this$attestation = this.getAttestation();
            AttestationObject other$attestation = other.getAttestation();
            if (this$attestation == null ? other$attestation != null : !((Object)this$attestation).equals(other$attestation)) {
                return false;
            }
            List<String> this$prevWarnings = this.getPrevWarnings();
            List<String> other$prevWarnings = other.getPrevWarnings();
            return !(this$prevWarnings == null ? other$prevWarnings != null : !((Object)this$prevWarnings).equals(other$prevWarnings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ByteArray $clientDataJsonHash = this.getClientDataJsonHash();
            result = result * 59 + ($clientDataJsonHash == null ? 43 : ((Object)$clientDataJsonHash).hashCode());
            AttestationObject $attestation = this.getAttestation();
            result = result * 59 + ($attestation == null ? 43 : ((Object)$attestation).hashCode());
            List<String> $prevWarnings = this.getPrevWarnings();
            result = result * 59 + ($prevWarnings == null ? 43 : ((Object)$prevWarnings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Step13(clientDataJsonHash=" + this.getClientDataJsonHash() + ", attestation=" + this.getAttestation() + ", prevWarnings=" + this.getPrevWarnings() + ")";
        }
    }

    final class Step12
    implements Step<Step13> {
        private final ByteArray clientDataJsonHash;
        private final AttestationObject attestation;
        private final List<String> prevWarnings;

        @Override
        public void validate() {
            if (!FinishRegistrationSteps.this.allowUnrequestedExtensions) {
                ExtensionsValidation.validate(FinishRegistrationSteps.this.request.getExtensions(), FinishRegistrationSteps.this.response);
            }
        }

        @Override
        public List<String> getWarnings() {
            try {
                ExtensionsValidation.validate(FinishRegistrationSteps.this.request.getExtensions(), FinishRegistrationSteps.this.response);
                return Collections.emptyList();
            }
            catch (Exception e) {
                return Collections.singletonList(e.getMessage());
            }
        }

        @Override
        public Step13 nextStep() {
            return new Step13(this.clientDataJsonHash, this.attestation, this.allWarnings());
        }

        @Generated
        public Step12(ByteArray clientDataJsonHash, AttestationObject attestation, List<String> prevWarnings) {
            this.clientDataJsonHash = clientDataJsonHash;
            this.attestation = attestation;
            this.prevWarnings = prevWarnings;
        }

        @Generated
        public ByteArray getClientDataJsonHash() {
            return this.clientDataJsonHash;
        }

        @Generated
        public AttestationObject getAttestation() {
            return this.attestation;
        }

        @Override
        @Generated
        public List<String> getPrevWarnings() {
            return this.prevWarnings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step12)) {
                return false;
            }
            Step12 other = (Step12)o;
            ByteArray this$clientDataJsonHash = this.getClientDataJsonHash();
            ByteArray other$clientDataJsonHash = other.getClientDataJsonHash();
            if (this$clientDataJsonHash == null ? other$clientDataJsonHash != null : !((Object)this$clientDataJsonHash).equals(other$clientDataJsonHash)) {
                return false;
            }
            AttestationObject this$attestation = this.getAttestation();
            AttestationObject other$attestation = other.getAttestation();
            if (this$attestation == null ? other$attestation != null : !((Object)this$attestation).equals(other$attestation)) {
                return false;
            }
            List<String> this$prevWarnings = this.getPrevWarnings();
            List<String> other$prevWarnings = other.getPrevWarnings();
            return !(this$prevWarnings == null ? other$prevWarnings != null : !((Object)this$prevWarnings).equals(other$prevWarnings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ByteArray $clientDataJsonHash = this.getClientDataJsonHash();
            result = result * 59 + ($clientDataJsonHash == null ? 43 : ((Object)$clientDataJsonHash).hashCode());
            AttestationObject $attestation = this.getAttestation();
            result = result * 59 + ($attestation == null ? 43 : ((Object)$attestation).hashCode());
            List<String> $prevWarnings = this.getPrevWarnings();
            result = result * 59 + ($prevWarnings == null ? 43 : ((Object)$prevWarnings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Step12(clientDataJsonHash=" + this.getClientDataJsonHash() + ", attestation=" + this.getAttestation() + ", prevWarnings=" + this.getPrevWarnings() + ")";
        }
    }

    final class Step11
    implements Step<Step12> {
        private final ByteArray clientDataJsonHash;
        private final AttestationObject attestation;
        private final List<String> prevWarnings;

        @Override
        public void validate() {
            if (FinishRegistrationSteps.this.request.getAuthenticatorSelection().map(AuthenticatorSelectionCriteria::getUserVerification).orElse(UserVerificationRequirement.PREFERRED) == UserVerificationRequirement.REQUIRED) {
                ExceptionUtil.assure(((AuthenticatorAttestationResponse)((FinishRegistrationSteps)FinishRegistrationSteps.this).response.getResponse()).getParsedAuthenticatorData().getFlags().UV, "User Verification is required.", new Object[0]);
            }
        }

        @Override
        public Step12 nextStep() {
            return new Step12(this.clientDataJsonHash, this.attestation, this.allWarnings());
        }

        @Generated
        public Step11(ByteArray clientDataJsonHash, AttestationObject attestation, List<String> prevWarnings) {
            this.clientDataJsonHash = clientDataJsonHash;
            this.attestation = attestation;
            this.prevWarnings = prevWarnings;
        }

        @Generated
        public ByteArray getClientDataJsonHash() {
            return this.clientDataJsonHash;
        }

        @Generated
        public AttestationObject getAttestation() {
            return this.attestation;
        }

        @Override
        @Generated
        public List<String> getPrevWarnings() {
            return this.prevWarnings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step11)) {
                return false;
            }
            Step11 other = (Step11)o;
            ByteArray this$clientDataJsonHash = this.getClientDataJsonHash();
            ByteArray other$clientDataJsonHash = other.getClientDataJsonHash();
            if (this$clientDataJsonHash == null ? other$clientDataJsonHash != null : !((Object)this$clientDataJsonHash).equals(other$clientDataJsonHash)) {
                return false;
            }
            AttestationObject this$attestation = this.getAttestation();
            AttestationObject other$attestation = other.getAttestation();
            if (this$attestation == null ? other$attestation != null : !((Object)this$attestation).equals(other$attestation)) {
                return false;
            }
            List<String> this$prevWarnings = this.getPrevWarnings();
            List<String> other$prevWarnings = other.getPrevWarnings();
            return !(this$prevWarnings == null ? other$prevWarnings != null : !((Object)this$prevWarnings).equals(other$prevWarnings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ByteArray $clientDataJsonHash = this.getClientDataJsonHash();
            result = result * 59 + ($clientDataJsonHash == null ? 43 : ((Object)$clientDataJsonHash).hashCode());
            AttestationObject $attestation = this.getAttestation();
            result = result * 59 + ($attestation == null ? 43 : ((Object)$attestation).hashCode());
            List<String> $prevWarnings = this.getPrevWarnings();
            result = result * 59 + ($prevWarnings == null ? 43 : ((Object)$prevWarnings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Step11(clientDataJsonHash=" + this.getClientDataJsonHash() + ", attestation=" + this.getAttestation() + ", prevWarnings=" + this.getPrevWarnings() + ")";
        }
    }

    final class Step10
    implements Step<Step11> {
        private final ByteArray clientDataJsonHash;
        private final AttestationObject attestation;
        private final List<String> prevWarnings;

        @Override
        public void validate() {
            ExceptionUtil.assure(((AuthenticatorAttestationResponse)((FinishRegistrationSteps)FinishRegistrationSteps.this).response.getResponse()).getParsedAuthenticatorData().getFlags().UP, "User Presence is required.", new Object[0]);
        }

        @Override
        public Step11 nextStep() {
            return new Step11(this.clientDataJsonHash, this.attestation, this.allWarnings());
        }

        @Generated
        public Step10(ByteArray clientDataJsonHash, AttestationObject attestation, List<String> prevWarnings) {
            this.clientDataJsonHash = clientDataJsonHash;
            this.attestation = attestation;
            this.prevWarnings = prevWarnings;
        }

        @Generated
        public ByteArray getClientDataJsonHash() {
            return this.clientDataJsonHash;
        }

        @Generated
        public AttestationObject getAttestation() {
            return this.attestation;
        }

        @Override
        @Generated
        public List<String> getPrevWarnings() {
            return this.prevWarnings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step10)) {
                return false;
            }
            Step10 other = (Step10)o;
            ByteArray this$clientDataJsonHash = this.getClientDataJsonHash();
            ByteArray other$clientDataJsonHash = other.getClientDataJsonHash();
            if (this$clientDataJsonHash == null ? other$clientDataJsonHash != null : !((Object)this$clientDataJsonHash).equals(other$clientDataJsonHash)) {
                return false;
            }
            AttestationObject this$attestation = this.getAttestation();
            AttestationObject other$attestation = other.getAttestation();
            if (this$attestation == null ? other$attestation != null : !((Object)this$attestation).equals(other$attestation)) {
                return false;
            }
            List<String> this$prevWarnings = this.getPrevWarnings();
            List<String> other$prevWarnings = other.getPrevWarnings();
            return !(this$prevWarnings == null ? other$prevWarnings != null : !((Object)this$prevWarnings).equals(other$prevWarnings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ByteArray $clientDataJsonHash = this.getClientDataJsonHash();
            result = result * 59 + ($clientDataJsonHash == null ? 43 : ((Object)$clientDataJsonHash).hashCode());
            AttestationObject $attestation = this.getAttestation();
            result = result * 59 + ($attestation == null ? 43 : ((Object)$attestation).hashCode());
            List<String> $prevWarnings = this.getPrevWarnings();
            result = result * 59 + ($prevWarnings == null ? 43 : ((Object)$prevWarnings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Step10(clientDataJsonHash=" + this.getClientDataJsonHash() + ", attestation=" + this.getAttestation() + ", prevWarnings=" + this.getPrevWarnings() + ")";
        }
    }

    final class Step9
    implements Step<Step10> {
        private final ByteArray clientDataJsonHash;
        private final AttestationObject attestation;
        private final List<String> prevWarnings;

        @Override
        public void validate() {
            ExceptionUtil.assure(Crypto.sha256(FinishRegistrationSteps.this.rpId).equals(((AuthenticatorAttestationResponse)FinishRegistrationSteps.this.response.getResponse()).getAttestation().getAuthenticatorData().getRpIdHash()), "Wrong RP ID hash.", new Object[0]);
        }

        @Override
        public Step10 nextStep() {
            return new Step10(this.clientDataJsonHash, this.attestation, this.allWarnings());
        }

        @Generated
        public Step9(ByteArray clientDataJsonHash, AttestationObject attestation, List<String> prevWarnings) {
            this.clientDataJsonHash = clientDataJsonHash;
            this.attestation = attestation;
            this.prevWarnings = prevWarnings;
        }

        @Generated
        public ByteArray getClientDataJsonHash() {
            return this.clientDataJsonHash;
        }

        @Generated
        public AttestationObject getAttestation() {
            return this.attestation;
        }

        @Override
        @Generated
        public List<String> getPrevWarnings() {
            return this.prevWarnings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step9)) {
                return false;
            }
            Step9 other = (Step9)o;
            ByteArray this$clientDataJsonHash = this.getClientDataJsonHash();
            ByteArray other$clientDataJsonHash = other.getClientDataJsonHash();
            if (this$clientDataJsonHash == null ? other$clientDataJsonHash != null : !((Object)this$clientDataJsonHash).equals(other$clientDataJsonHash)) {
                return false;
            }
            AttestationObject this$attestation = this.getAttestation();
            AttestationObject other$attestation = other.getAttestation();
            if (this$attestation == null ? other$attestation != null : !((Object)this$attestation).equals(other$attestation)) {
                return false;
            }
            List<String> this$prevWarnings = this.getPrevWarnings();
            List<String> other$prevWarnings = other.getPrevWarnings();
            return !(this$prevWarnings == null ? other$prevWarnings != null : !((Object)this$prevWarnings).equals(other$prevWarnings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ByteArray $clientDataJsonHash = this.getClientDataJsonHash();
            result = result * 59 + ($clientDataJsonHash == null ? 43 : ((Object)$clientDataJsonHash).hashCode());
            AttestationObject $attestation = this.getAttestation();
            result = result * 59 + ($attestation == null ? 43 : ((Object)$attestation).hashCode());
            List<String> $prevWarnings = this.getPrevWarnings();
            result = result * 59 + ($prevWarnings == null ? 43 : ((Object)$prevWarnings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Step9(clientDataJsonHash=" + this.getClientDataJsonHash() + ", attestation=" + this.getAttestation() + ", prevWarnings=" + this.getPrevWarnings() + ")";
        }
    }

    final class Step8
    implements Step<Step9> {
        private final ByteArray clientDataJsonHash;
        private final List<String> prevWarnings;

        @Override
        public void validate() {
            ExceptionUtil.assure(this.attestation() != null, "Malformed attestation object.", new Object[0]);
        }

        @Override
        public Step9 nextStep() {
            return new Step9(this.clientDataJsonHash, this.attestation(), this.allWarnings());
        }

        public AttestationObject attestation() {
            return ((AuthenticatorAttestationResponse)FinishRegistrationSteps.this.response.getResponse()).getAttestation();
        }

        @Generated
        public Step8(ByteArray clientDataJsonHash, List<String> prevWarnings) {
            this.clientDataJsonHash = clientDataJsonHash;
            this.prevWarnings = prevWarnings;
        }

        @Generated
        public ByteArray getClientDataJsonHash() {
            return this.clientDataJsonHash;
        }

        @Override
        @Generated
        public List<String> getPrevWarnings() {
            return this.prevWarnings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step8)) {
                return false;
            }
            Step8 other = (Step8)o;
            ByteArray this$clientDataJsonHash = this.getClientDataJsonHash();
            ByteArray other$clientDataJsonHash = other.getClientDataJsonHash();
            if (this$clientDataJsonHash == null ? other$clientDataJsonHash != null : !((Object)this$clientDataJsonHash).equals(other$clientDataJsonHash)) {
                return false;
            }
            List<String> this$prevWarnings = this.getPrevWarnings();
            List<String> other$prevWarnings = other.getPrevWarnings();
            return !(this$prevWarnings == null ? other$prevWarnings != null : !((Object)this$prevWarnings).equals(other$prevWarnings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ByteArray $clientDataJsonHash = this.getClientDataJsonHash();
            result = result * 59 + ($clientDataJsonHash == null ? 43 : ((Object)$clientDataJsonHash).hashCode());
            List<String> $prevWarnings = this.getPrevWarnings();
            result = result * 59 + ($prevWarnings == null ? 43 : ((Object)$prevWarnings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Step8(clientDataJsonHash=" + this.getClientDataJsonHash() + ", prevWarnings=" + this.getPrevWarnings() + ")";
        }
    }

    final class Step7
    implements Step<Step8> {
        private final List<String> prevWarnings;

        @Override
        public void validate() {
            ExceptionUtil.assure(this.clientDataJsonHash().size() == 32, "Failed to compute hash of client data", new Object[0]);
        }

        @Override
        public Step8 nextStep() {
            return new Step8(this.clientDataJsonHash(), this.allWarnings());
        }

        public ByteArray clientDataJsonHash() {
            return Crypto.sha256(((AuthenticatorAttestationResponse)FinishRegistrationSteps.this.response.getResponse()).getClientDataJSON());
        }

        @Generated
        public Step7(List<String> prevWarnings) {
            this.prevWarnings = prevWarnings;
        }

        @Override
        @Generated
        public List<String> getPrevWarnings() {
            return this.prevWarnings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step7)) {
                return false;
            }
            Step7 other = (Step7)o;
            List<String> this$prevWarnings = this.getPrevWarnings();
            List<String> other$prevWarnings = other.getPrevWarnings();
            return !(this$prevWarnings == null ? other$prevWarnings != null : !((Object)this$prevWarnings).equals(other$prevWarnings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $prevWarnings = this.getPrevWarnings();
            result = result * 59 + ($prevWarnings == null ? 43 : ((Object)$prevWarnings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Step7(prevWarnings=" + this.getPrevWarnings() + ")";
        }
    }

    final class Step6
    implements Step<Step7> {
        private final CollectedClientData clientData;
        private final List<String> prevWarnings;

        @Override
        public void validate() {
            TokenBindingValidator.validate(this.clientData.getTokenBinding(), FinishRegistrationSteps.this.callerTokenBindingId);
        }

        @Override
        public Step7 nextStep() {
            return new Step7(this.allWarnings());
        }

        @Generated
        public Step6(CollectedClientData clientData, List<String> prevWarnings) {
            this.clientData = clientData;
            this.prevWarnings = prevWarnings;
        }

        @Generated
        public CollectedClientData getClientData() {
            return this.clientData;
        }

        @Override
        @Generated
        public List<String> getPrevWarnings() {
            return this.prevWarnings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step6)) {
                return false;
            }
            Step6 other = (Step6)o;
            CollectedClientData this$clientData = this.getClientData();
            CollectedClientData other$clientData = other.getClientData();
            if (this$clientData == null ? other$clientData != null : !((Object)this$clientData).equals(other$clientData)) {
                return false;
            }
            List<String> this$prevWarnings = this.getPrevWarnings();
            List<String> other$prevWarnings = other.getPrevWarnings();
            return !(this$prevWarnings == null ? other$prevWarnings != null : !((Object)this$prevWarnings).equals(other$prevWarnings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CollectedClientData $clientData = this.getClientData();
            result = result * 59 + ($clientData == null ? 43 : ((Object)$clientData).hashCode());
            List<String> $prevWarnings = this.getPrevWarnings();
            result = result * 59 + ($prevWarnings == null ? 43 : ((Object)$prevWarnings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Step6(clientData=" + this.getClientData() + ", prevWarnings=" + this.getPrevWarnings() + ")";
        }
    }

    final class Step5
    implements Step<Step6> {
        private final CollectedClientData clientData;
        private final List<String> prevWarnings;

        @Override
        public void validate() {
            String responseOrigin = this.clientData.getOrigin();
            ExceptionUtil.assure(OriginMatcher.isAllowed(responseOrigin, FinishRegistrationSteps.this.origins, FinishRegistrationSteps.this.allowOriginPort, FinishRegistrationSteps.this.allowOriginSubdomain), "Incorrect origin: " + responseOrigin, new Object[0]);
        }

        @Override
        public Step6 nextStep() {
            return new Step6(this.clientData, this.allWarnings());
        }

        @Generated
        public Step5(CollectedClientData clientData, List<String> prevWarnings) {
            this.clientData = clientData;
            this.prevWarnings = prevWarnings;
        }

        @Generated
        public CollectedClientData getClientData() {
            return this.clientData;
        }

        @Override
        @Generated
        public List<String> getPrevWarnings() {
            return this.prevWarnings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step5)) {
                return false;
            }
            Step5 other = (Step5)o;
            CollectedClientData this$clientData = this.getClientData();
            CollectedClientData other$clientData = other.getClientData();
            if (this$clientData == null ? other$clientData != null : !((Object)this$clientData).equals(other$clientData)) {
                return false;
            }
            List<String> this$prevWarnings = this.getPrevWarnings();
            List<String> other$prevWarnings = other.getPrevWarnings();
            return !(this$prevWarnings == null ? other$prevWarnings != null : !((Object)this$prevWarnings).equals(other$prevWarnings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CollectedClientData $clientData = this.getClientData();
            result = result * 59 + ($clientData == null ? 43 : ((Object)$clientData).hashCode());
            List<String> $prevWarnings = this.getPrevWarnings();
            result = result * 59 + ($prevWarnings == null ? 43 : ((Object)$prevWarnings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Step5(clientData=" + this.getClientData() + ", prevWarnings=" + this.getPrevWarnings() + ")";
        }
    }

    final class Step4
    implements Step<Step5> {
        private final CollectedClientData clientData;
        private final List<String> prevWarnings;

        @Override
        public void validate() {
            ExceptionUtil.assure(FinishRegistrationSteps.this.request.getChallenge().equals(this.clientData.getChallenge()), "Incorrect challenge.", new Object[0]);
        }

        @Override
        public Step5 nextStep() {
            return new Step5(this.clientData, this.allWarnings());
        }

        @Generated
        public Step4(CollectedClientData clientData, List<String> prevWarnings) {
            this.clientData = clientData;
            this.prevWarnings = prevWarnings;
        }

        @Generated
        public CollectedClientData getClientData() {
            return this.clientData;
        }

        @Override
        @Generated
        public List<String> getPrevWarnings() {
            return this.prevWarnings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step4)) {
                return false;
            }
            Step4 other = (Step4)o;
            CollectedClientData this$clientData = this.getClientData();
            CollectedClientData other$clientData = other.getClientData();
            if (this$clientData == null ? other$clientData != null : !((Object)this$clientData).equals(other$clientData)) {
                return false;
            }
            List<String> this$prevWarnings = this.getPrevWarnings();
            List<String> other$prevWarnings = other.getPrevWarnings();
            return !(this$prevWarnings == null ? other$prevWarnings != null : !((Object)this$prevWarnings).equals(other$prevWarnings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CollectedClientData $clientData = this.getClientData();
            result = result * 59 + ($clientData == null ? 43 : ((Object)$clientData).hashCode());
            List<String> $prevWarnings = this.getPrevWarnings();
            result = result * 59 + ($prevWarnings == null ? 43 : ((Object)$prevWarnings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Step4(clientData=" + this.getClientData() + ", prevWarnings=" + this.getPrevWarnings() + ")";
        }
    }

    final class Step3
    implements Step<Step4> {
        private final CollectedClientData clientData;
        private final List<String> warnings = new ArrayList<String>(0);

        @Override
        public void validate() {
            ExceptionUtil.assure(FinishRegistrationSteps.CLIENT_DATA_TYPE.equals(this.clientData.getType()), "The \"type\" in the client data must be exactly \"%s\", was: %s", FinishRegistrationSteps.CLIENT_DATA_TYPE, this.clientData.getType());
        }

        @Override
        public Step4 nextStep() {
            return new Step4(this.clientData, this.allWarnings());
        }

        @Override
        public List<String> getPrevWarnings() {
            return Collections.emptyList();
        }

        @Override
        public List<String> getWarnings() {
            return CollectionUtil.immutableList(this.warnings);
        }

        @Generated
        public Step3(CollectedClientData clientData) {
            this.clientData = clientData;
        }

        @Generated
        public CollectedClientData getClientData() {
            return this.clientData;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step3)) {
                return false;
            }
            Step3 other = (Step3)o;
            CollectedClientData this$clientData = this.getClientData();
            CollectedClientData other$clientData = other.getClientData();
            if (this$clientData == null ? other$clientData != null : !((Object)this$clientData).equals(other$clientData)) {
                return false;
            }
            List<String> this$warnings = this.getWarnings();
            List<String> other$warnings = other.getWarnings();
            return !(this$warnings == null ? other$warnings != null : !((Object)this$warnings).equals(other$warnings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CollectedClientData $clientData = this.getClientData();
            result = result * 59 + ($clientData == null ? 43 : ((Object)$clientData).hashCode());
            List<String> $warnings = this.getWarnings();
            result = result * 59 + ($warnings == null ? 43 : ((Object)$warnings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Step3(clientData=" + this.getClientData() + ", warnings=" + this.getWarnings() + ")";
        }
    }

    final class Step2
    implements Step<Step3> {
        @Override
        public void validate() {
            ExceptionUtil.assure(this.clientData() != null, "Client data must not be null.", new Object[0]);
        }

        @Override
        public Step3 nextStep() {
            return new Step3(this.clientData());
        }

        @Override
        public List<String> getPrevWarnings() {
            return Collections.emptyList();
        }

        public CollectedClientData clientData() {
            return ((AuthenticatorAttestationResponse)FinishRegistrationSteps.this.response.getResponse()).getClientData();
        }

        @Generated
        public Step2() {
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof Step2;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Step2()";
        }
    }

    final class Step1
    implements Step<Step2> {
        @Override
        public void validate() {
        }

        @Override
        public Step2 nextStep() {
            return new Step2();
        }

        @Override
        public List<String> getPrevWarnings() {
            return Collections.emptyList();
        }

        @Generated
        public Step1() {
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof Step1;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Step1()";
        }
    }

    static interface Step<Next extends Step<?>> {
        public Next nextStep();

        public void validate();

        public List<String> getPrevWarnings();

        default public Optional<RegistrationResult> result() {
            return Optional.empty();
        }

        default public List<String> getWarnings() {
            return Collections.emptyList();
        }

        default public List<String> allWarnings() {
            ArrayList<String> result = new ArrayList<String>(this.getPrevWarnings().size() + this.getWarnings().size());
            result.addAll(this.getPrevWarnings());
            result.addAll(this.getWarnings());
            return CollectionUtil.immutableList(result);
        }

        default public Next next() {
            this.validate();
            return this.nextStep();
        }

        default public RegistrationResult run() {
            if (this.result().isPresent()) {
                return this.result().get();
            }
            return this.next().run();
        }
    }
}

