/*
 * Decompiled with CFR 0.152.
 */
package COSE;

import COSE.CoseException;
import COSE.MacCommon;
import COSE.MessageTag;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;

public class MAC0Message
extends MacCommon {
    public MAC0Message() {
        this.strContext = "MAC0";
        this.messageTag = MessageTag.MAC0;
    }

    @Override
    public void DecodeFromCBORObject(CBORObject obj) throws CoseException {
        if (obj.size() != 4) {
            throw new CoseException("Invalid MAC0 structure");
        }
        if (obj.get(0).getType() == CBORType.ByteString) {
            this.objProtected = obj.get(0).GetByteString().length == 0 ? CBORObject.NewMap() : CBORObject.DecodeFromBytes(obj.get(0).GetByteString());
        } else {
            throw new CoseException("Invalid MAC0 structure");
        }
        if (obj.get(1).getType() != CBORType.Map) {
            throw new CoseException("Invalid MAC0 structure");
        }
        this.objUnprotected = obj.get(1);
        if (obj.get(2).getType() == CBORType.ByteString) {
            this.rgbContent = obj.get(2).GetByteString();
        } else if (!obj.get(2).isNull()) {
            throw new CoseException("Invalid MAC0 structure");
        }
        if (obj.get(3).getType() != CBORType.ByteString) {
            throw new CoseException("Invalid MAC0 structure");
        }
        this.rgbTag = obj.get(3).GetByteString();
    }

    @Override
    protected CBORObject EncodeCBORObject() throws CoseException {
        if (this.rgbTag == null) {
            throw new CoseException("Compute function not called");
        }
        CBORObject obj = CBORObject.NewArray();
        if (this.objProtected.size() > 0) {
            obj.Add(this.objProtected.EncodeToBytes());
        } else {
            obj.Add(CBORObject.FromObject(new byte[0]));
        }
        obj.Add(this.objUnprotected);
        obj.Add(this.rgbContent);
        obj.Add(this.rgbTag);
        return obj;
    }

    public void Create(byte[] rgbKey) throws CoseException {
        super.CreateWithKey(rgbKey);
    }

    @Override
    public boolean Validate(byte[] rgbKey) throws CoseException {
        return super.Validate(rgbKey);
    }
}

