/*
 * Decompiled with CFR 0.152.
 */
package COSE;

import COSE.AlgorithmID;
import COSE.CoseException;
import COSE.Message;
import com.upokecenter.cbor.CBORObject;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class MacCommon
extends Message {
    protected byte[] rgbTag;
    protected String strContext;
    protected SecureRandom random = new SecureRandom();

    protected MacCommon() {
    }

    protected void CreateWithKey(byte[] rgbKey) throws CoseException {
        CBORObject algX = this.findAttribute(CBORObject.FromObject(1));
        AlgorithmID alg = AlgorithmID.FromCBOR(algX);
        if (this.rgbContent == null) {
            throw new CoseException("No Content Specified");
        }
        switch (alg) {
            case HMAC_SHA_256_64: 
            case HMAC_SHA_256: 
            case HMAC_SHA_384: 
            case HMAC_SHA_512: {
                this.rgbTag = this.HMAC(alg, rgbKey);
                break;
            }
            case AES_CBC_MAC_128_64: 
            case AES_CBC_MAC_256_64: 
            case AES_CBC_MAC_128_128: 
            case AES_CBC_MAC_256_128: {
                this.rgbTag = this.AES_CBC_MAC(alg, rgbKey);
                break;
            }
            default: {
                throw new CoseException("Unsupported MAC Algorithm");
            }
        }
        this.ProcessCounterSignatures();
    }

    protected boolean Validate(byte[] rgbKey) throws CoseException {
        byte[] rgbTest;
        CBORObject algX = this.findAttribute(CBORObject.FromObject(1));
        AlgorithmID alg = AlgorithmID.FromCBOR(algX);
        switch (alg) {
            case HMAC_SHA_256_64: 
            case HMAC_SHA_256: 
            case HMAC_SHA_384: 
            case HMAC_SHA_512: {
                rgbTest = this.HMAC(alg, rgbKey);
                break;
            }
            case AES_CBC_MAC_128_64: 
            case AES_CBC_MAC_256_64: 
            case AES_CBC_MAC_128_128: 
            case AES_CBC_MAC_256_128: {
                rgbTest = this.AES_CBC_MAC(alg, rgbKey);
                break;
            }
            default: {
                throw new CoseException("Unsupported MAC Algorithm");
            }
        }
        if (rgbTest.length != this.rgbTag.length) {
            return false;
        }
        boolean f = true;
        for (int i = 0; i < rgbTest.length; ++i) {
            f &= rgbTest[i] == this.rgbTag[i];
        }
        return f;
    }

    private byte[] BuildContentBytes() {
        CBORObject obj = CBORObject.NewArray();
        if (this.rgbProtected == null) {
            this.rgbProtected = this.objProtected.size() == 0 ? new byte[0] : this.objProtected.EncodeToBytes();
        }
        obj.Add(this.strContext);
        obj.Add(this.rgbProtected);
        if (this.externalData != null) {
            obj.Add(CBORObject.FromObject(this.externalData));
        } else {
            obj.Add(CBORObject.FromObject(new byte[0]));
        }
        obj.Add(this.rgbContent);
        return obj.EncodeToBytes();
    }

    protected byte[] AES_CBC_MAC(AlgorithmID alg, byte[] rgbKey) throws CoseException {
        if (rgbKey.length != alg.getKeySize() / 8) {
            throw new CoseException("Key is incorrectly sized");
        }
        byte[] IV = new byte[16];
        try {
            Cipher cbcmac = Cipher.getInstance("AES/CBC/NoPadding");
            cbcmac.init(1, (Key)new SecretKeySpec(rgbKey, "AES"), new IvParameterSpec(IV));
            byte[] val = this.BuildContentBytes();
            int blockLen = cbcmac.getBlockSize();
            int tagLen = alg.getTagSize() / 8;
            int dataLen = val.length;
            int dataPad = 16 - val.length % 16;
            if (dataPad != 16) {
                dataLen += dataPad;
            }
            ByteBuffer input = ByteBuffer.allocate(dataLen);
            input.put(val);
            input.put(IV, 0, input.remaining());
            input.flip();
            ByteBuffer output = ByteBuffer.allocate(dataLen);
            cbcmac.doFinal(input, output);
            val = new byte[alg.getTagSize() / 8];
            output.position(output.limit() - blockLen);
            output.get(val);
            return val;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CoseException("Algorithm not supported", ex);
        }
        catch (InvalidKeyException ex) {
            if (ex.getMessage() == "Illegal key size") {
                throw new CoseException("Unsupported key size", ex);
            }
            throw new CoseException("Mac failure", ex);
        }
        catch (Exception ex) {
            throw new CoseException("Mac failure", ex);
        }
    }

    private byte[] HMAC(AlgorithmID alg, byte[] rgbKey) throws CoseException {
        String algStr;
        switch (alg) {
            case HMAC_SHA_256_64: 
            case HMAC_SHA_256: {
                algStr = "HmacSHA256";
                break;
            }
            case HMAC_SHA_384: {
                algStr = "HmacSHA384";
                break;
            }
            case HMAC_SHA_512: {
                algStr = "HmacSHA512";
                break;
            }
            default: {
                throw new CoseException("Internal Error");
            }
        }
        if (rgbKey.length != alg.getKeySize() / 8) {
            throw new CoseException("Key is incorrect size");
        }
        try {
            Mac hmac = Mac.getInstance(algStr);
            hmac.init(new SecretKeySpec(rgbKey, algStr));
            byte[] val = this.BuildContentBytes();
            val = hmac.doFinal(val);
            val = Arrays.copyOfRange(val, 0, alg.getTagSize() / 8);
            return val;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CoseException("Algorithm not supported", ex);
        }
        catch (Exception ex) {
            throw new CoseException("Mac failure", ex);
        }
    }
}

