/*
 * Decompiled with CFR 0.152.
 */
package COSE;

import COSE.AlgorithmID;
import COSE.Attribute;
import COSE.CoseException;
import COSE.CounterSign;
import COSE.CounterSign1;
import COSE.HeaderKeys;
import COSE.KeyKeys;
import COSE.OneKey;
import COSE.SignCommon;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import java.util.ArrayList;
import java.util.List;

public class Signer
extends Attribute {
    protected byte[] rgbSignature;
    protected String contextString = "Signature";
    OneKey cnKey;
    List<CounterSign> counterSignList = new ArrayList<CounterSign>();
    CounterSign1 counterSign1;

    public Signer() {
    }

    public Signer(OneKey key) {
        this.cnKey = key;
    }

    public void clearKey() {
        this.cnKey = null;
    }

    public void setKey(OneKey keyIn) throws CoseException {
        this.setupKey(keyIn);
    }

    private void setupKey(OneKey key) throws CoseException {
        CBORObject cn2;
        this.cnKey = key;
        if (this.rgbSignature != null) {
            return;
        }
        CBORObject cn = key.get(KeyKeys.Algorithm);
        if (cn != null && (cn2 = this.findAttribute(HeaderKeys.Algorithm)) == null) {
            this.addAttribute(HeaderKeys.Algorithm, cn, 1);
        }
        if ((cn = key.get(KeyKeys.KeyId)) != null && (cn2 = this.findAttribute(HeaderKeys.KID)) == null) {
            this.addAttribute(HeaderKeys.KID, cn, 2);
        }
    }

    protected void DecodeFromCBORObject(CBORObject obj) throws CoseException {
        Signer cs;
        if (obj.getType() != CBORType.Array) {
            throw new CoseException("Invalid Signer structure");
        }
        if (obj.size() != 3) {
            throw new CoseException("Invalid Signer structure");
        }
        if (obj.get(0).getType() == CBORType.ByteString) {
            this.rgbProtected = obj.get(0).GetByteString();
            if (this.rgbProtected.length == 0) {
                this.objProtected = CBORObject.NewMap();
            } else {
                this.objProtected = CBORObject.DecodeFromBytes(this.rgbProtected);
                if (this.objProtected.size() == 0) {
                    this.rgbProtected = new byte[0];
                }
            }
        } else {
            throw new CoseException("Invalid Signer structure");
        }
        if (obj.get(1).getType() != CBORType.Map) {
            throw new CoseException("Invalid Signer structure");
        }
        this.objUnprotected = obj.get(1);
        if (obj.get(2).getType() == CBORType.ByteString) {
            this.rgbSignature = obj.get(2).GetByteString();
        } else if (!obj.get(2).isNull()) {
            throw new CoseException("Invalid Signer structure");
        }
        CBORObject countersignature = this.findAttribute(HeaderKeys.CounterSignature, 2);
        if (countersignature != null) {
            if (countersignature.getType() != CBORType.Array || countersignature.getValues().isEmpty()) {
                throw new CoseException("Invalid countersignature attribute");
            }
            if (countersignature.get(0).getType() == CBORType.Array) {
                for (CBORObject csObj : countersignature.getValues()) {
                    if (csObj.getType() != CBORType.Array) {
                        throw new CoseException("Invalid countersignature attribute");
                    }
                    CounterSign cs2 = new CounterSign(csObj);
                    cs2.setObject(this);
                    this.addCountersignature(cs2);
                }
            } else {
                cs = new CounterSign(countersignature);
                ((CounterSign)cs).setObject(this);
                this.addCountersignature((CounterSign)cs);
            }
        }
        if ((countersignature = this.findAttribute(HeaderKeys.CounterSignature0, 2)) != null) {
            if (countersignature.getType() != CBORType.ByteString) {
                throw new CoseException("Invalid Countersignature0 attribute");
            }
            cs = new CounterSign1(countersignature.GetByteString());
            ((CounterSign1)cs).setObject(this);
            this.counterSign1 = cs;
        }
    }

    protected CBORObject EncodeToCBORObject() throws CoseException {
        if (this.rgbSignature == null) {
            throw new CoseException("Message not yet signed");
        }
        if (this.rgbProtected == null) {
            throw new CoseException("Internal Error");
        }
        CBORObject obj = CBORObject.NewArray();
        obj.Add(this.rgbProtected);
        obj.Add(this.objUnprotected);
        obj.Add(this.rgbSignature);
        return obj;
    }

    public void sign(byte[] rgbBodyProtected, byte[] rgbContent) throws CoseException {
        if (this.rgbProtected == null) {
            this.rgbProtected = this.objProtected.size() == 0 ? new byte[0] : this.objProtected.EncodeToBytes();
        }
        CBORObject obj = CBORObject.NewArray();
        obj.Add(this.contextString);
        obj.Add(rgbBodyProtected);
        obj.Add(this.rgbProtected);
        obj.Add(this.externalData);
        obj.Add(rgbContent);
        AlgorithmID alg = AlgorithmID.FromCBOR(this.findAttribute(HeaderKeys.Algorithm));
        this.rgbSignature = SignCommon.computeSignature(alg, obj.EncodeToBytes(), this.cnKey);
        this.ProcessCounterSignatures();
    }

    public boolean validate(byte[] rgbBodyProtected, byte[] rgbContent) throws CoseException {
        CBORObject obj = CBORObject.NewArray();
        obj.Add(this.contextString);
        obj.Add(rgbBodyProtected);
        obj.Add(this.rgbProtected);
        obj.Add(this.externalData);
        obj.Add(rgbContent);
        AlgorithmID alg = AlgorithmID.FromCBOR(this.findAttribute(HeaderKeys.Algorithm));
        return SignCommon.validateSignature(alg, obj.EncodeToBytes(), this.rgbSignature, this.cnKey);
    }

    public void addCountersignature(CounterSign countersignature) {
        this.counterSignList.add(countersignature);
    }

    public List<CounterSign> getCountersignerList() {
        return this.counterSignList;
    }

    public CounterSign1 getCountersign1() {
        return this.counterSign1;
    }

    public void setCountersign1(CounterSign1 value) {
        this.counterSign1 = value;
    }

    protected void ProcessCounterSignatures() throws CoseException {
        if (!this.counterSignList.isEmpty()) {
            if (this.counterSignList.size() == 1) {
                this.counterSignList.get(0).sign(this.rgbProtected, this.rgbSignature);
                this.addAttribute(HeaderKeys.CounterSignature, this.counterSignList.get(0).EncodeToCBORObject(), 2);
            } else {
                CBORObject list = CBORObject.NewArray();
                for (CounterSign sig : this.counterSignList) {
                    sig.sign(this.rgbProtected, this.rgbSignature);
                    list.Add(sig.EncodeToCBORObject());
                }
                this.addAttribute(HeaderKeys.CounterSignature, list, 2);
            }
        }
        if (this.counterSign1 != null) {
            this.counterSign1.sign(this.rgbProtected, this.rgbSignature);
            this.addAttribute(HeaderKeys.CounterSignature0, this.counterSign1.EncodeToCBORObject(), 2);
        }
    }

    public boolean validate(CounterSign1 countersignature) throws CoseException {
        return countersignature.validate(this.rgbProtected, this.rgbSignature);
    }

    public boolean validate(CounterSign countersignature) throws CoseException {
        return countersignature.validate(this.rgbProtected, this.rgbSignature);
    }
}

