/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import com.yubico.internal.util.ExceptionUtil;
import com.yubico.webauthn.AttestationStatementVerifier;
import com.yubico.webauthn.Crypto;
import com.yubico.webauthn.WebAuthnCodecs;
import com.yubico.webauthn.X5cAttestationStatementVerifier;
import com.yubico.webauthn.data.AttestationObject;
import com.yubico.webauthn.data.AttestationType;
import com.yubico.webauthn.data.ByteArray;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AppleAttestationStatementVerifier
implements AttestationStatementVerifier,
X5cAttestationStatementVerifier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppleAttestationStatementVerifier.class);
    private static final String NONCE_EXTENSION_OID = "1.2.840.113635.100.8.2";

    AppleAttestationStatementVerifier() {
    }

    @Override
    public AttestationType getAttestationType(AttestationObject attestation) {
        return AttestationType.ANONYMIZATION_CA;
    }

    @Override
    public boolean verifyAttestationSignature(AttestationObject attestationObject, ByteArray clientDataJsonHash) {
        Optional<X509Certificate> attestationCert;
        try {
            attestationCert = this.getX5cAttestationCertificate(attestationObject);
        }
        catch (CertificateException e) {
            throw ExceptionUtil.wrapAndLog(log, String.format("Failed to parse X.509 certificate from attestation object: %s", attestationObject), e);
        }
        return attestationCert.map(attestationCertificate -> {
            PublicKey credentialPublicKey;
            ByteArray nonceToHash = attestationObject.getAuthenticatorData().getBytes().concat(clientDataJsonHash);
            ByteArray nonce = Crypto.sha256(nonceToHash);
            byte[] nonceExtension = attestationCertificate.getExtensionValue(NONCE_EXTENSION_OID);
            if (nonceExtension == null) {
                throw new IllegalArgumentException("Apple anonymous attestation certificate must contain extension OID: 1.2.840.113635.100.8.2");
            }
            ByteArray expectedExtensionValue = new ByteArray(new byte[]{4, 38, 48, 36, -95, 34, 4, 32}).concat(nonce);
            if (!expectedExtensionValue.equals(new ByteArray(nonceExtension))) {
                throw new IllegalArgumentException(String.format("Apple anonymous attestation certificate extension %s must equal nonceToHash. Expected: %s, was: %s", NONCE_EXTENSION_OID, expectedExtensionValue, new ByteArray(nonceExtension)));
            }
            try {
                credentialPublicKey = WebAuthnCodecs.importCosePublicKey(attestationObject.getAuthenticatorData().getAttestedCredentialData().get().getCredentialPublicKey());
            }
            catch (Exception e) {
                throw ExceptionUtil.wrapAndLog(log, "Failed to import credential public key", e);
            }
            PublicKey certPublicKey = attestationCertificate.getPublicKey();
            if (!credentialPublicKey.equals(certPublicKey)) {
                throw new IllegalArgumentException(String.format("Apple anonymous attestation certificate subject public key must equal credential public key. Expected: %s, was: %s", credentialPublicKey, certPublicKey));
            }
            return true;
        }).orElseThrow(() -> new IllegalArgumentException("Failed to parse attestation certificate from \"apple\" attestation statement."));
    }
}

