/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import COSE.CoseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.upokecenter.cbor.CBORObject;
import com.yubico.internal.util.CollectionUtil;
import com.yubico.internal.util.ExceptionUtil;
import com.yubico.webauthn.AttestationStatementVerifier;
import com.yubico.webauthn.Crypto;
import com.yubico.webauthn.WebAuthnCodecs;
import com.yubico.webauthn.X5cAttestationStatementVerifier;
import com.yubico.webauthn.data.AttestationObject;
import com.yubico.webauthn.data.AttestationType;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.COSEAlgorithmIdentifier;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PackedAttestationStatementVerifier
implements AttestationStatementVerifier,
X5cAttestationStatementVerifier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PackedAttestationStatementVerifier.class);

    PackedAttestationStatementVerifier() {
    }

    @Override
    public AttestationType getAttestationType(AttestationObject attestation) {
        if (attestation.getAttestationStatement().hasNonNull("x5c")) {
            return AttestationType.BASIC;
        }
        if (attestation.getAttestationStatement().hasNonNull("ecdaaKeyId")) {
            return AttestationType.ECDAA;
        }
        return AttestationType.SELF_ATTESTATION;
    }

    @Override
    public boolean verifyAttestationSignature(AttestationObject attestationObject, ByteArray clientDataJsonHash) {
        JsonNode signatureNode = attestationObject.getAttestationStatement().get("sig");
        if (signatureNode == null || !signatureNode.isBinary()) {
            throw new IllegalArgumentException("attStmt.sig must be set to a binary value.");
        }
        if (attestationObject.getAttestationStatement().has("x5c")) {
            return this.verifyX5cSignature(attestationObject, clientDataJsonHash);
        }
        if (attestationObject.getAttestationStatement().has("ecdaaKeyId")) {
            return this.verifyEcdaaSignature(attestationObject, clientDataJsonHash);
        }
        return this.verifySelfAttestationSignature(attestationObject, clientDataJsonHash);
    }

    private boolean verifyEcdaaSignature(AttestationObject attestationObject, ByteArray clientDataJsonHash) {
        throw new UnsupportedOperationException("ECDAA signature verification is not (yet) implemented.");
    }

    private boolean verifySelfAttestationSignature(AttestationObject attestationObject, ByteArray clientDataJsonHash) {
        ByteArray signature;
        PublicKey pubkey;
        try {
            pubkey = WebAuthnCodecs.importCosePublicKey(attestationObject.getAuthenticatorData().getAttestedCredentialData().get().getCredentialPublicKey());
        }
        catch (CoseException | IOException | InvalidKeySpecException e) {
            throw ExceptionUtil.wrapAndLog(log, String.format("Failed to parse public key from attestation data %s", attestationObject.getAuthenticatorData().getAttestedCredentialData()), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        Long keyAlgId = CBORObject.DecodeFromBytes(attestationObject.getAuthenticatorData().getAttestedCredentialData().get().getCredentialPublicKey().getBytes()).get(CBORObject.FromObject(3)).AsInt64();
        COSEAlgorithmIdentifier keyAlg = COSEAlgorithmIdentifier.fromId(keyAlgId).orElseThrow(() -> new IllegalArgumentException("Unsupported COSE algorithm identifier: " + keyAlgId));
        Long sigAlgId = attestationObject.getAttestationStatement().get("alg").asLong();
        COSEAlgorithmIdentifier sigAlg = COSEAlgorithmIdentifier.fromId(sigAlgId).orElseThrow(() -> new IllegalArgumentException("Unsupported COSE algorithm identifier: " + sigAlgId));
        if (!Objects.equals(keyAlg, sigAlg)) {
            throw new IllegalArgumentException(String.format("Key algorithm and signature algorithm must be equal, was: Key: %s, Sig: %s", keyAlg, sigAlg));
        }
        ByteArray signedData = attestationObject.getAuthenticatorData().getBytes().concat(clientDataJsonHash);
        try {
            signature = new ByteArray(attestationObject.getAttestationStatement().get("sig").binaryValue());
        }
        catch (IOException e) {
            throw ExceptionUtil.wrapAndLog(log, ".binaryValue() of \"sig\" failed", e);
        }
        return Crypto.verifySignature(pubkey, signedData, signature, keyAlg);
    }

    private boolean verifyX5cSignature(AttestationObject attestationObject, ByteArray clientDataHash) {
        Optional<X509Certificate> attestationCert;
        try {
            attestationCert = this.getX5cAttestationCertificate(attestationObject);
        }
        catch (CertificateException e) {
            throw ExceptionUtil.wrapAndLog(log, String.format("Failed to parse X.509 certificate from attestation object: %s", attestationObject), e);
        }
        return attestationCert.map(attestationCertificate -> {
            JsonNode signatureNode = attestationObject.getAttestationStatement().get("sig");
            if (signatureNode == null) {
                throw new IllegalArgumentException("Packed attestation statement must have field \"sig\".");
            }
            if (signatureNode.isBinary()) {
                Signature signatureVerifier;
                ByteArray signature;
                try {
                    signature = new ByteArray(signatureNode.binaryValue());
                }
                catch (IOException e) {
                    throw ExceptionUtil.wrapAndLog(log, "signatureNode.isBinary() was true but signatureNode.binaryValue() failed", e);
                }
                JsonNode algNode = attestationObject.getAttestationStatement().get("alg");
                if (algNode == null) {
                    throw new IllegalArgumentException("Packed attestation statement must have field \"alg\".");
                }
                ExceptionUtil.assure(algNode.isIntegralNumber(), "Field \"alg\" in packed attestation statement must be a COSEAlgorithmIdentifier.", new Object[0]);
                Long sigAlgId = algNode.asLong();
                COSEAlgorithmIdentifier sigAlg = COSEAlgorithmIdentifier.fromId(sigAlgId).orElseThrow(() -> new IllegalArgumentException("Unsupported COSE algorithm identifier: " + sigAlgId));
                ByteArray signedData = attestationObject.getAuthenticatorData().getBytes().concat(clientDataHash);
                String signatureAlgorithmName = WebAuthnCodecs.getJavaAlgorithmName(sigAlg);
                try {
                    signatureVerifier = Crypto.getSignature(signatureAlgorithmName);
                }
                catch (NoSuchAlgorithmException e) {
                    throw ExceptionUtil.wrapAndLog(log, "Failed to get a Signature instance for " + signatureAlgorithmName, e);
                }
                try {
                    signatureVerifier.initVerify(attestationCertificate.getPublicKey());
                }
                catch (InvalidKeyException e) {
                    throw ExceptionUtil.wrapAndLog(log, "Attestation key is invalid: " + attestationCertificate, e);
                }
                try {
                    signatureVerifier.update(signedData.getBytes());
                }
                catch (SignatureException e) {
                    throw ExceptionUtil.wrapAndLog(log, "Signature object in invalid state: " + signatureVerifier, e);
                }
                try {
                    return signatureVerifier.verify(signature.getBytes()) && this.verifyX5cRequirements((X509Certificate)attestationCertificate, attestationObject.getAuthenticatorData().getAttestedCredentialData().get().getAaguid());
                }
                catch (SignatureException e) {
                    throw ExceptionUtil.wrapAndLog(log, "Failed to verify signature: " + attestationObject, e);
                }
            }
            throw new IllegalArgumentException("Field \"sig\" in packed attestation statement must be a binary value.");
        }).orElseThrow(() -> new IllegalArgumentException("If \"x5c\" property is present in \"packed\" attestation format it must be an array containing at least one DER encoded X.509 cerficicate."));
    }

    private Optional<Object> getDnField(String field, X509Certificate cert) {
        LdapName ldap;
        try {
            ldap = new LdapName(cert.getSubjectX500Principal().getName());
        }
        catch (InvalidNameException e) {
            throw ExceptionUtil.wrapAndLog(log, "X500Principal name was not accepted as an LdapName: " + cert.getSubjectX500Principal().getName(), e);
        }
        return ldap.getRdns().stream().filter(rdn -> Objects.equals(rdn.getType(), field)).findAny().map(Rdn::getValue);
    }

    public boolean verifyX5cRequirements(X509Certificate cert, ByteArray aaguid) {
        if (cert.getVersion() != 3) {
            throw new IllegalArgumentException(String.format("Wrong attestation certificate X509 version: %s, expected: 3", cert.getVersion()));
        }
        String ouValue = "Authenticator Attestation";
        String idFidoGenCeAaguid = "1.3.6.1.4.1.45724.1.1.4";
        Set<String> countries = CollectionUtil.immutableSet(new HashSet<String>(Arrays.asList(Locale.getISOCountries())));
        ExceptionUtil.assure(this.getDnField("C", cert).filter(countries::contains).isPresent(), "Invalid attestation certificate country code: %s", this.getDnField("C", cert));
        ExceptionUtil.assure(this.getDnField("O", cert).filter(o -> !((String)o).isEmpty()).isPresent(), "Organization (O) field of attestation certificate DN must be present.", new Object[0]);
        ExceptionUtil.assure(this.getDnField("OU", cert).filter("Authenticator Attestation"::equals).isPresent(), "Organization Unit (OU) field of attestation certificate DN must be exactly \"%s\", was: %s", "Authenticator Attestation", this.getDnField("OU", cert));
        Optional.ofNullable(cert.getExtensionValue("1.3.6.1.4.1.45724.1.1.4")).map(ext -> new ByteArray(this.parseAaguid((byte[])ext))).ifPresent(value -> {
            ExceptionUtil.assure(value.equals(aaguid), "X.509 extension %s (id-fido-gen-ce-aaguid) is present but does not match the authenticator AAGUID.", "1.3.6.1.4.1.45724.1.1.4");
            ExceptionUtil.assure(!cert.getCriticalExtensionOIDs().contains("1.3.6.1.4.1.45724.1.1.4"), "X.509 extension %s (id-fido-gen-ce-aaguid) must not be marked critical.", "1.3.6.1.4.1.45724.1.1.4");
        });
        ExceptionUtil.assure(cert.getBasicConstraints() == -1, "Attestation certificate must not be a CA certificate.", new Object[0]);
        return true;
    }

    private byte[] parseAaguid(byte[] bytes) {
        ByteBuffer buffer;
        if (bytes != null && bytes.length == 20 && (buffer = ByteBuffer.wrap(bytes)).get() == 4 && buffer.get() == 18 && buffer.get() == 4 && buffer.get() == 16) {
            byte[] aaguidBytes = new byte[16];
            buffer.get(aaguidBytes);
            return aaguidBytes;
        }
        throw new IllegalArgumentException("X.509 extension 1.3.6.1.4.1.45724.1.1.4 (id-fido-gen-ce-aaguid) is not valid.");
    }
}

