/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.attestation;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;

public enum Transport {
    BT_CLASSIC(1),
    BLE(2),
    USB(4),
    NFC(8),
    LIGHTNING(16);

    private final int bitpos;

    private Transport(int bitpos) {
        this.bitpos = bitpos;
    }

    public static Set<Transport> fromInt(int bits) {
        EnumSet<Transport> transports = EnumSet.noneOf(Transport.class);
        for (Transport transport : Transport.values()) {
            if ((transport.bitpos & bits) == 0) continue;
            transports.add(transport);
        }
        return transports;
    }

    public static int toInt(Iterable<Transport> transports) {
        int transportsInt = 0;
        for (Transport transport : transports) {
            transportsInt |= transport.bitpos;
        }
        return transportsInt;
    }

    public static int toInt(Transport ... transports) {
        return Transport.toInt(Arrays.asList(transports));
    }
}

