/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yubico.internal.util.CollectionUtil;
import com.yubico.internal.util.ComparableUtil;
import com.yubico.webauthn.data.AuthenticatorTransport;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.PublicKeyCredentialType;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;
import lombok.NonNull;

public final class PublicKeyCredentialDescriptor
implements Comparable<PublicKeyCredentialDescriptor> {
    @NonNull
    private final PublicKeyCredentialType type;
    @NonNull
    private final ByteArray id;
    private final SortedSet<AuthenticatorTransport> transports;

    @JsonCreator
    private PublicKeyCredentialDescriptor(@JsonProperty(value="type") @NonNull PublicKeyCredentialType type, @JsonProperty(value="id") @NonNull ByteArray id, @JsonProperty(value="transports") Set<AuthenticatorTransport> transports) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.type = type;
        this.id = id;
        this.transports = transports == null ? null : CollectionUtil.immutableSortedSet(new TreeSet<AuthenticatorTransport>(transports));
    }

    @Override
    public int compareTo(PublicKeyCredentialDescriptor other) {
        int transportsComparison;
        int idComparison = this.id.compareTo(other.id);
        if (idComparison != 0) {
            return idComparison;
        }
        if (this.type.compareTo(other.type) != 0) {
            return this.type.compareTo(other.type);
        }
        if (!this.getTransports().isPresent() && other.getTransports().isPresent()) {
            return -1;
        }
        if (this.getTransports().isPresent() && !other.getTransports().isPresent()) {
            return 1;
        }
        if (this.getTransports().isPresent() && other.getTransports().isPresent() && (transportsComparison = ComparableUtil.compareComparableSets(this.getTransports().get(), other.getTransports().get())) != 0) {
            return transportsComparison;
        }
        return 0;
    }

    public static PublicKeyCredentialDescriptorBuilder.MandatoryStages builder() {
        return new PublicKeyCredentialDescriptorBuilder.MandatoryStages();
    }

    public Optional<SortedSet<AuthenticatorTransport>> getTransports() {
        return Optional.ofNullable(this.transports);
    }

    @Generated
    private static PublicKeyCredentialType $default$type() {
        return PublicKeyCredentialType.PUBLIC_KEY;
    }

    @Generated
    public PublicKeyCredentialDescriptorBuilder toBuilder() {
        return new PublicKeyCredentialDescriptorBuilder().type(this.type).id(this.id).transports(this.transports);
    }

    @NonNull
    @Generated
    public PublicKeyCredentialType getType() {
        return this.type;
    }

    @NonNull
    @Generated
    public ByteArray getId() {
        return this.id;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PublicKeyCredentialDescriptor)) {
            return false;
        }
        PublicKeyCredentialDescriptor other = (PublicKeyCredentialDescriptor)o;
        PublicKeyCredentialType this$type = this.getType();
        PublicKeyCredentialType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        ByteArray this$id = this.getId();
        ByteArray other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Optional<SortedSet<AuthenticatorTransport>> this$transports = this.getTransports();
        Optional<SortedSet<AuthenticatorTransport>> other$transports = other.getTransports();
        return !(this$transports == null ? other$transports != null : !((Object)this$transports).equals(other$transports));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PublicKeyCredentialType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        ByteArray $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Optional<SortedSet<AuthenticatorTransport>> $transports = this.getTransports();
        result = result * 59 + ($transports == null ? 43 : ((Object)$transports).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PublicKeyCredentialDescriptor(type=" + this.getType() + ", id=" + this.getId() + ", transports=" + this.getTransports() + ")";
    }

    public static class PublicKeyCredentialDescriptorBuilder {
        @Generated
        private boolean type$set;
        @Generated
        private PublicKeyCredentialType type$value;
        @Generated
        private ByteArray id;
        private Set<AuthenticatorTransport> transports = null;

        public PublicKeyCredentialDescriptorBuilder transports(@NonNull Optional<Set<AuthenticatorTransport>> transports) {
            if (transports == null) {
                throw new NullPointerException("transports is marked non-null but is null");
            }
            return this.transports((Set<AuthenticatorTransport>)transports.orElse(null));
        }

        public PublicKeyCredentialDescriptorBuilder transports(Set<AuthenticatorTransport> transports) {
            this.transports = transports;
            return this;
        }

        @Generated
        PublicKeyCredentialDescriptorBuilder() {
        }

        @Generated
        public PublicKeyCredentialDescriptorBuilder type(@NonNull PublicKeyCredentialType type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type$value = type;
            this.type$set = true;
            return this;
        }

        @Generated
        public PublicKeyCredentialDescriptorBuilder id(@NonNull ByteArray id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this;
        }

        @Generated
        public PublicKeyCredentialDescriptor build() {
            PublicKeyCredentialType type$value = this.type$value;
            if (!this.type$set) {
                type$value = PublicKeyCredentialDescriptor.$default$type();
            }
            return new PublicKeyCredentialDescriptor(type$value, this.id, this.transports);
        }

        @Generated
        public String toString() {
            return "PublicKeyCredentialDescriptor.PublicKeyCredentialDescriptorBuilder(type$value=" + this.type$value + ", id=" + this.id + ", transports=" + this.transports + ")";
        }

        public static class MandatoryStages {
            private PublicKeyCredentialDescriptorBuilder builder = new PublicKeyCredentialDescriptorBuilder();

            public PublicKeyCredentialDescriptorBuilder id(ByteArray id) {
                return this.builder.id(id);
            }
        }
    }
}

