/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.yubico.internal.util.json.JsonStringSerializable;
import com.yubico.internal.util.json.JsonStringSerializer;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;

@JsonSerialize(using=JsonStringSerializer.class)
public enum PublicKeyCredentialType implements JsonStringSerializable
{
    PUBLIC_KEY("public-key");

    @NonNull
    private final String id;

    private static Optional<PublicKeyCredentialType> fromString(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked @NonNull but is null");
        }
        return Stream.of(PublicKeyCredentialType.values()).filter(v -> v.id.equals(id)).findAny();
    }

    @JsonCreator
    private static PublicKeyCredentialType fromJsonString(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked @NonNull but is null");
        }
        return PublicKeyCredentialType.fromString(id).orElseThrow(() -> new IllegalArgumentException(String.format("Unknown %s value: %s", PublicKeyCredentialType.class.getSimpleName(), id)));
    }

    @Override
    public String toJsonString() {
        return this.id;
    }

    @Generated
    private PublicKeyCredentialType(String id) {
        if (id == null) {
            throw new NullPointerException("id is marked @NonNull but is null");
        }
        this.id = id;
    }
}

