/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yubico.internal.util.ExceptionUtil;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.TokenBindingStatus;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public final class TokenBindingInfo {
    @NonNull
    private final TokenBindingStatus status;
    @NonNull
    private final Optional<ByteArray> id;

    TokenBindingInfo(@NonNull TokenBindingStatus status, @NonNull Optional<ByteArray> id) {
        if (status == null) {
            throw new NullPointerException("status is marked @NonNull but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked @NonNull but is null");
        }
        if (status == TokenBindingStatus.PRESENT) {
            ExceptionUtil.assure(id.isPresent(), "Token binding ID must be present if status is \"%s\".", TokenBindingStatus.PRESENT);
        } else {
            ExceptionUtil.assure(!id.isPresent(), "Token binding ID must not be present if status is not \"%s\".", TokenBindingStatus.PRESENT);
        }
        this.status = status;
        this.id = id;
    }

    @JsonCreator
    private TokenBindingInfo(@JsonProperty(value="status") @NonNull TokenBindingStatus status, @JsonProperty(value="id") ByteArray id) {
        this(status, Optional.ofNullable(id));
        if (status == null) {
            throw new NullPointerException("status is marked @NonNull but is null");
        }
    }

    public static TokenBindingInfo present(@NonNull ByteArray id) {
        if (id == null) {
            throw new NullPointerException("id is marked @NonNull but is null");
        }
        return new TokenBindingInfo(TokenBindingStatus.PRESENT, Optional.of(id));
    }

    public static TokenBindingInfo supported() {
        return new TokenBindingInfo(TokenBindingStatus.SUPPORTED, Optional.empty());
    }

    @NonNull
    @Generated
    public TokenBindingStatus getStatus() {
        return this.status;
    }

    @NonNull
    @Generated
    public Optional<ByteArray> getId() {
        return this.id;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TokenBindingInfo)) {
            return false;
        }
        TokenBindingInfo other = (TokenBindingInfo)o;
        TokenBindingStatus this$status = this.getStatus();
        TokenBindingStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Optional<ByteArray> this$id = this.getId();
        Optional<ByteArray> other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TokenBindingStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        Optional<ByteArray> $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TokenBindingInfo(status=" + this.getStatus() + ", id=" + this.getId() + ")";
    }
}

