/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.yubico.internal.util.ExceptionUtil;
import com.yubico.internal.util.WebAuthnCodecs;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.TokenBindingInfo;
import com.yubico.webauthn.data.TokenBindingStatus;
import com.yubico.webauthn.data.exception.Base64UrlException;
import java.io.IOException;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

@JsonSerialize(using=JsonSerializer.class)
public final class CollectedClientData {
    @NonNull
    private final ByteArray clientDataJson;
    @NonNull
    private final transient ObjectNode clientData;
    @NonNull
    private final transient ByteArray challenge;
    @NonNull
    private final transient String origin;
    @NonNull
    private final transient String type;

    @JsonCreator
    public CollectedClientData(@NonNull ByteArray clientDataJSON) throws IOException, Base64UrlException {
        if (clientDataJSON == null) {
            throw new NullPointerException("clientDataJSON is marked @NonNull but is null");
        }
        JsonNode clientData = WebAuthnCodecs.json().readTree(clientDataJSON.getBytes());
        ExceptionUtil.assure(clientData != null && clientData.isObject(), "Collected client data must be JSON object.", new Object[0]);
        this.clientDataJson = clientDataJSON;
        this.clientData = (ObjectNode)clientData;
        try {
            this.challenge = ByteArray.fromBase64Url(clientData.get("challenge").textValue());
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Missing field: \"challenge\"");
        }
        catch (Base64UrlException e) {
            throw new Base64UrlException("Invalid \"challenge\" value", e);
        }
        try {
            this.origin = clientData.get("origin").textValue();
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Missing field: \"origin\"");
        }
        try {
            this.type = clientData.get("type").textValue();
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Missing field: \"type\"");
        }
        JsonNode authenticatorExtensions = clientData.get("authenticatorExtensions");
        if (authenticatorExtensions != null && !authenticatorExtensions.isObject()) {
            throw new IllegalArgumentException("Field \"authenticatorExtensions\" must be an object if present.");
        }
        JsonNode clientExtensions = clientData.get("clientExtensions");
        if (clientExtensions != null && !clientExtensions.isObject()) {
            throw new IllegalArgumentException("Field \"clientExtensions\" must be an object if present.");
        }
    }

    public final Optional<TokenBindingInfo> getTokenBinding() {
        return Optional.ofNullable(this.clientData.get("tokenBinding")).map(tb -> {
            if (tb.isObject()) {
                String status = tb.get("status").textValue();
                return new TokenBindingInfo(TokenBindingStatus.fromJsonString(status), Optional.ofNullable(tb.get("id")).map(JsonNode::textValue).map(id -> {
                    try {
                        return ByteArray.fromBase64Url(id);
                    }
                    catch (Base64UrlException e) {
                        throw new IllegalArgumentException("Property \"id\" is not valid Base64Url data", e);
                    }
                }));
            }
            throw new IllegalArgumentException("Property \"tokenBinding\" missing from client data.");
        });
    }

    @NonNull
    @Generated
    public ByteArray getChallenge() {
        return this.challenge;
    }

    @NonNull
    @Generated
    public String getOrigin() {
        return this.origin;
    }

    @NonNull
    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CollectedClientData)) {
            return false;
        }
        CollectedClientData other = (CollectedClientData)o;
        ByteArray this$clientDataJson = this.clientDataJson;
        ByteArray other$clientDataJson = other.clientDataJson;
        return !(this$clientDataJson == null ? other$clientDataJson != null : !((Object)this$clientDataJson).equals(other$clientDataJson));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ByteArray $clientDataJson = this.clientDataJson;
        result = result * 59 + ($clientDataJson == null ? 43 : ((Object)$clientDataJson).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CollectedClientData(clientDataJson=" + this.clientDataJson + ", clientData=" + this.clientData + ", challenge=" + this.getChallenge() + ", origin=" + this.getOrigin() + ", type=" + this.getType() + ")";
    }

    static class JsonSerializer
    extends com.fasterxml.jackson.databind.JsonSerializer<CollectedClientData> {
        JsonSerializer() {
        }

        public void serialize(CollectedClientData value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(value.clientDataJson.getBase64Url());
        }
    }
}

