/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.yubico.internal.util.WebAuthnCodecs;
import com.yubico.webauthn.data.AuthenticatorAssertionResponse;
import com.yubico.webauthn.data.AuthenticatorAttestationResponse;
import com.yubico.webauthn.data.AuthenticatorResponse;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.ClientAssertionExtensionOutputs;
import com.yubico.webauthn.data.ClientExtensionOutputs;
import com.yubico.webauthn.data.ClientRegistrationExtensionOutputs;
import com.yubico.webauthn.data.PublicKeyCredential;
import com.yubico.webauthn.data.PublicKeyCredentialType;
import java.io.IOException;
import lombok.Generated;
import lombok.NonNull;

public final class PublicKeyCredential<A extends AuthenticatorResponse, B extends ClientExtensionOutputs> {
    @NonNull
    private final ByteArray id;
    @NonNull
    private final A response;
    @NonNull
    private final B clientExtensionResults;
    @NonNull
    private final PublicKeyCredentialType type;

    @JsonCreator
    private PublicKeyCredential(@JsonProperty(value="id") @NonNull ByteArray id, @JsonProperty(value="response") @NonNull A response, @JsonProperty(value="clientExtensionResults") @NonNull B clientExtensionResults, @JsonProperty(value="type") @NonNull PublicKeyCredentialType type) {
        if (id == null) {
            throw new NullPointerException("id is marked @NonNull but is null");
        }
        if (response == null) {
            throw new NullPointerException("response is marked @NonNull but is null");
        }
        if (clientExtensionResults == null) {
            throw new NullPointerException("clientExtensionResults is marked @NonNull but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked @NonNull but is null");
        }
        this.id = id;
        this.response = response;
        this.clientExtensionResults = clientExtensionResults;
        this.type = type;
    }

    public static <A extends AuthenticatorResponse, B extends ClientExtensionOutputs> PublicKeyCredentialBuilder.MandatoryStages builder() {
        return new PublicKeyCredentialBuilder().start();
    }

    public static PublicKeyCredential<AuthenticatorAttestationResponse, ClientRegistrationExtensionOutputs> parseRegistrationResponseJson(String json) throws IOException {
        return (PublicKeyCredential)WebAuthnCodecs.json().readValue(json, (TypeReference)new TypeReference<PublicKeyCredential<AuthenticatorAttestationResponse, ClientRegistrationExtensionOutputs>>(){});
    }

    public static PublicKeyCredential<AuthenticatorAssertionResponse, ClientAssertionExtensionOutputs> parseAssertionResponseJson(String json) throws IOException {
        return (PublicKeyCredential)WebAuthnCodecs.json().readValue(json, (TypeReference)new TypeReference<PublicKeyCredential<AuthenticatorAssertionResponse, ClientAssertionExtensionOutputs>>(){});
    }

    @Generated
    private static <A extends AuthenticatorResponse, B extends ClientExtensionOutputs> PublicKeyCredentialType $default$type() {
        return PublicKeyCredentialType.PUBLIC_KEY;
    }

    @Generated
    public PublicKeyCredentialBuilder<A, B> toBuilder() {
        return new PublicKeyCredentialBuilder().id(this.id).response(this.response).clientExtensionResults(this.clientExtensionResults).type(this.type);
    }

    @NonNull
    @Generated
    public ByteArray getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public A getResponse() {
        return this.response;
    }

    @NonNull
    @Generated
    public B getClientExtensionResults() {
        return this.clientExtensionResults;
    }

    @NonNull
    @Generated
    public PublicKeyCredentialType getType() {
        return this.type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PublicKeyCredential)) {
            return false;
        }
        PublicKeyCredential other = (PublicKeyCredential)o;
        ByteArray this$id = this.getId();
        ByteArray other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        A this$response = this.getResponse();
        A other$response = other.getResponse();
        if (this$response == null ? other$response != null : !this$response.equals(other$response)) {
            return false;
        }
        B this$clientExtensionResults = this.getClientExtensionResults();
        B other$clientExtensionResults = other.getClientExtensionResults();
        if (this$clientExtensionResults == null ? other$clientExtensionResults != null : !this$clientExtensionResults.equals(other$clientExtensionResults)) {
            return false;
        }
        PublicKeyCredentialType this$type = this.getType();
        PublicKeyCredentialType other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ByteArray $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        A $response = this.getResponse();
        result = result * 59 + ($response == null ? 43 : $response.hashCode());
        B $clientExtensionResults = this.getClientExtensionResults();
        result = result * 59 + ($clientExtensionResults == null ? 43 : $clientExtensionResults.hashCode());
        PublicKeyCredentialType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PublicKeyCredential(id=" + this.getId() + ", response=" + this.getResponse() + ", clientExtensionResults=" + this.getClientExtensionResults() + ", type=" + this.getType() + ")";
    }

    /* synthetic */ PublicKeyCredential(ByteArray x0, AuthenticatorResponse x1, ClientExtensionOutputs x2, PublicKeyCredentialType x3, 1 x4) {
        this(x0, x1, x2, x3);
    }

    public static class PublicKeyCredentialBuilder<A extends AuthenticatorResponse, B extends ClientExtensionOutputs> {
        @Generated
        private ByteArray id;
        @Generated
        private A response;
        @Generated
        private B clientExtensionResults;
        @Generated
        private boolean type$set;
        @Generated
        private PublicKeyCredentialType type;

        private MandatoryStages start() {
            return new MandatoryStages(this);
        }

        @Generated
        PublicKeyCredentialBuilder() {
        }

        @Generated
        public PublicKeyCredentialBuilder<A, B> id(@NonNull ByteArray id) {
            if (id == null) {
                throw new NullPointerException("id is marked @NonNull but is null");
            }
            this.id = id;
            return this;
        }

        @Generated
        public PublicKeyCredentialBuilder<A, B> response(@NonNull A response) {
            if (response == null) {
                throw new NullPointerException("response is marked @NonNull but is null");
            }
            this.response = response;
            return this;
        }

        @Generated
        public PublicKeyCredentialBuilder<A, B> clientExtensionResults(@NonNull B clientExtensionResults) {
            if (clientExtensionResults == null) {
                throw new NullPointerException("clientExtensionResults is marked @NonNull but is null");
            }
            this.clientExtensionResults = clientExtensionResults;
            return this;
        }

        @Generated
        public PublicKeyCredentialBuilder<A, B> type(@NonNull PublicKeyCredentialType type) {
            if (type == null) {
                throw new NullPointerException("type is marked @NonNull but is null");
            }
            this.type = type;
            this.type$set = true;
            return this;
        }

        @Generated
        public PublicKeyCredential<A, B> build() {
            PublicKeyCredentialType type = this.type;
            if (!this.type$set) {
                type = PublicKeyCredential.$default$type();
            }
            return new PublicKeyCredential(this.id, (AuthenticatorResponse)this.response, (ClientExtensionOutputs)this.clientExtensionResults, type, null);
        }

        @Generated
        public String toString() {
            return "PublicKeyCredential.PublicKeyCredentialBuilder(id=" + this.id + ", response=" + this.response + ", clientExtensionResults=" + this.clientExtensionResults + ", type=" + this.type + ")";
        }

        public class MandatoryStages {
            private final PublicKeyCredentialBuilder<A, B> builder;

            public com.yubico.webauthn.data.PublicKeyCredential$PublicKeyCredentialBuilder$MandatoryStages.Step2 id(ByteArray id) {
                this.builder.id(id);
                return new Step2();
            }

            @Generated
            public MandatoryStages(PublicKeyCredentialBuilder<A, B> builder) {
                this.builder = builder;
            }

            public class Step3 {
                public PublicKeyCredentialBuilder<A, B> clientExtensionResults(B clientExtensionResults) {
                    return MandatoryStages.this.builder.clientExtensionResults(clientExtensionResults);
                }
            }

            public class Step2 {
                public com.yubico.webauthn.data.PublicKeyCredential$PublicKeyCredentialBuilder$MandatoryStages.Step3 response(A response) {
                    MandatoryStages.this.builder.response(response);
                    return new Step3();
                }
            }
        }
    }
}

