/*
 * Decompiled with CFR 0.152.
 */
package COSE;

import COSE.ASN1;
import COSE.AlgorithmID;
import COSE.CoseException;
import COSE.KeyKeys;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAMultiPrimePrivateCrtKeySpec;
import java.security.spec.RSAOtherPrimeInfo;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.spec.EdDSAGenParameterSpec;

public class OneKey {
    protected CBORObject keyMap;
    private PrivateKey privateKey;
    private PublicKey publicKey;
    private Object UserData;

    public OneKey() {
        this.keyMap = CBORObject.NewMap();
    }

    public OneKey(CBORObject keyData) throws CoseException {
        if (keyData.getType() != CBORType.Map) {
            throw new CoseException("Key data is malformed");
        }
        this.keyMap = keyData;
        this.CheckKeyState();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OneKey(PublicKey pubKey, PrivateKey privKey) throws CoseException {
        byte[] oid;
        ArrayList<ASN1.TagValue> alg;
        this.keyMap = CBORObject.NewMap();
        if (pubKey != null) {
            ArrayList<ASN1.TagValue> spki = ASN1.DecodeSubjectPublicKeyInfo(pubKey.getEncoded());
            alg = spki.get((int)0).list;
            if (Arrays.equals(alg.get((int)0).value, ASN1.oid_ecPublicKey)) {
                oid = alg.get((int)1).value;
                if (oid == null) {
                    throw new CoseException("Invalid SPKI structure");
                }
                this.keyMap.Add(KeyKeys.KeyType.AsCBOR(), KeyKeys.KeyType_EC2);
                if (Arrays.equals(oid, ASN1.Oid_secp256r1)) {
                    this.keyMap.Add(KeyKeys.EC2_Curve.AsCBOR(), KeyKeys.EC2_P256);
                } else if (Arrays.equals(oid, ASN1.Oid_secp384r1)) {
                    this.keyMap.Add(KeyKeys.EC2_Curve.AsCBOR(), KeyKeys.EC2_P384);
                } else {
                    if (!Arrays.equals(oid, ASN1.Oid_secp521r1)) throw new CoseException("Unsupported curve");
                    this.keyMap.Add(KeyKeys.EC2_Curve.AsCBOR(), KeyKeys.EC2_P521);
                }
                byte[] keyData = spki.get((int)1).value;
                if (keyData[1] == 2 || keyData[1] == 3) {
                    this.keyMap.Add(KeyKeys.EC2_X.AsCBOR(), Arrays.copyOfRange(keyData, 2, keyData.length));
                    this.keyMap.Add(KeyKeys.EC2_Y.AsCBOR(), keyData[1] != 2);
                } else {
                    if (keyData[1] != 4) throw new CoseException("Invalid key data");
                    int keyLength = (keyData.length - 2) / 2;
                    this.keyMap.Add(KeyKeys.EC2_X.AsCBOR(), Arrays.copyOfRange(keyData, 2, 2 + keyLength));
                    this.keyMap.Add(KeyKeys.EC2_Y.AsCBOR(), Arrays.copyOfRange(keyData, 2 + keyLength, keyData.length));
                }
            } else {
                if (!Arrays.equals(alg.get((int)0).value, ASN1.Oid_rsaEncryption)) throw new CoseException("Unsupported Algorithm");
                ASN1.TagValue compound = ASN1.DecodeCompound(1, spki.get((int)1).value);
                if (compound.list == null || compound.list.size() != 2) {
                    throw new CoseException("Invalid SPKI structure");
                }
                ASN1.TagValue n = compound.list.get(0);
                ASN1.TagValue e = compound.list.get(1);
                if (n.tag != 2 || e.tag != 2) {
                    throw new CoseException("Invalid SPKI structure");
                }
                this.keyMap.Add(KeyKeys.RSA_N.AsCBOR(), n.value);
                this.keyMap.Add(KeyKeys.RSA_E.AsCBOR(), e.value);
            }
            this.publicKey = pubKey;
        }
        if (privKey == null) return;
        ArrayList<ASN1.TagValue> pkl = ASN1.DecodePKCS8Structure(privKey.getEncoded());
        if (pkl.get((int)0).tag != 2) {
            throw new CoseException("Invalid PKCS8 structure");
        }
        alg = pkl.get((int)1).list;
        if (Arrays.equals(alg.get((int)0).value, ASN1.oid_ecPublicKey)) {
            oid = alg.get((int)1).value;
            if (oid == null) {
                throw new CoseException("Invalid PKCS8 structure");
            }
            if (!this.keyMap.ContainsKey(KeyKeys.KeyType.AsCBOR())) {
                this.keyMap.Add(KeyKeys.KeyType.AsCBOR(), KeyKeys.KeyType_EC2);
                if (Arrays.equals(oid, ASN1.Oid_secp256r1)) {
                    this.keyMap.Add(KeyKeys.EC2_Curve.AsCBOR(), KeyKeys.EC2_P256);
                } else if (Arrays.equals(oid, ASN1.Oid_secp384r1)) {
                    this.keyMap.Add(KeyKeys.EC2_Curve.AsCBOR(), KeyKeys.EC2_P384);
                } else {
                    if (!Arrays.equals(oid, ASN1.Oid_secp521r1)) throw new CoseException("Unsupported curve");
                    this.keyMap.Add(KeyKeys.EC2_Curve.AsCBOR(), KeyKeys.EC2_P521);
                }
            } else if (!this.get(KeyKeys.KeyType).equals(KeyKeys.KeyType_EC2)) {
                throw new CoseException("Public/Private key don't match");
            }
            ArrayList<ASN1.TagValue> pkdl = ASN1.DecodePKCS8EC(pkl);
            if (pkdl.get((int)1).tag != 4) {
                throw new CoseException("Invalid PKCS8 structure");
            }
            byte[] keyData = pkdl.get((int)1).value;
            this.keyMap.Add(KeyKeys.EC2_D.AsCBOR(), keyData);
        } else {
            if (!Arrays.equals(alg.get((int)0).value, ASN1.Oid_rsaEncryption)) throw new CoseException("Unsupported Algorithm");
            ArrayList<ASN1.TagValue> pkdl = ASN1.DecodePKCS8RSA(pkl);
            if (!this.keyMap.ContainsKey(KeyKeys.RSA_N.AsCBOR())) {
                this.keyMap.Add(KeyKeys.RSA_N.AsCBOR(), pkdl.get((int)1).value);
            }
            if (!this.keyMap.ContainsKey(KeyKeys.RSA_E.AsCBOR())) {
                this.keyMap.Add(KeyKeys.RSA_E.AsCBOR(), pkdl.get((int)2).value);
            }
            this.keyMap.Add(KeyKeys.RSA_D.AsCBOR(), pkdl.get((int)3).value);
            this.keyMap.Add(KeyKeys.RSA_P.AsCBOR(), pkdl.get((int)4).value);
            this.keyMap.Add(KeyKeys.RSA_Q.AsCBOR(), pkdl.get((int)5).value);
            this.keyMap.Add(KeyKeys.RSA_DP.AsCBOR(), pkdl.get((int)6).value);
            this.keyMap.Add(KeyKeys.RSA_DQ.AsCBOR(), pkdl.get((int)7).value);
            this.keyMap.Add(KeyKeys.RSA_QI.AsCBOR(), pkdl.get((int)8).value);
        }
        this.privateKey = privKey;
    }

    public void add(KeyKeys keyValue, CBORObject value) {
        this.keyMap.Add(keyValue.AsCBOR(), value);
    }

    public void add(CBORObject keyValue, CBORObject value) {
        this.keyMap.Add(keyValue, value);
    }

    public CBORObject get(KeyKeys keyValue) {
        return this.keyMap.get(keyValue.AsCBOR());
    }

    public CBORObject get(CBORObject keyValue) throws CoseException {
        if (keyValue.getType() != CBORType.Integer && keyValue.getType() != CBORType.TextString) {
            throw new CoseException("keyValue type is incorrect");
        }
        return this.keyMap.get(keyValue);
    }

    public boolean HasAlgorithmID(AlgorithmID algorithmId) {
        CBORObject thatObj;
        CBORObject thisObj = this.get(KeyKeys.Algorithm);
        CBORObject cBORObject = thatObj = algorithmId == null ? null : algorithmId.AsCBOR();
        boolean result = thatObj == null ? thisObj == null : thatObj.equals(thisObj);
        return result;
    }

    @Deprecated
    public boolean HasKeyID(String id) {
        byte[] idB = StandardCharsets.UTF_8.encode(id).array();
        return this.HasKeyID(idB);
    }

    public boolean HasKeyID(byte[] id) {
        CBORObject thatObj = id == null ? null : CBORObject.FromObject(id);
        CBORObject thisObj = this.get(KeyKeys.KeyId);
        boolean result = thatObj == null ? thisObj == null : thatObj.equals(thisObj);
        return result;
    }

    public boolean HasKeyType(CBORObject keyTypeObj) {
        CBORObject thatObj = keyTypeObj;
        CBORObject thisObj = this.get(KeyKeys.KeyType);
        boolean result = thatObj == null ? thisObj == null : thatObj.equals(thisObj);
        return result;
    }

    public boolean HasKeyOp(Integer that) {
        boolean result;
        block3: {
            CBORObject thisObj;
            block4: {
                block2: {
                    thisObj = this.get(KeyKeys.Key_Ops);
                    if (that != null) break block2;
                    result = thisObj == null;
                    break block3;
                }
                result = false;
                if (thisObj.getType() != CBORType.Integer) break block4;
                if (thisObj.AsInt32() != that.intValue()) break block3;
                result = true;
                break block3;
            }
            if (thisObj.getType() == CBORType.Array) {
                for (int i = 0; i < thisObj.size(); ++i) {
                    if (thisObj.get(i).getType() != CBORType.Integer || thisObj.get(i).AsInt32() != that.intValue()) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    private void CheckKeyState() throws CoseException {
        CBORObject val = this.get(KeyKeys.KeyType);
        if (val == null || val.getType() != CBORType.Integer) {
            throw new CoseException("Missing or incorrect key type field");
        }
        if (val.equals(KeyKeys.KeyType_Octet)) {
            val = this.get(KeyKeys.Octet_K);
            if (val == null || val.getType() != CBORType.ByteString) {
                throw new CoseException("Malformed key structure");
            }
        } else if (val.equals(KeyKeys.KeyType_EC2)) {
            this.CheckECKey();
        } else if (val.equals(KeyKeys.KeyType_OKP)) {
            this.CheckOkpKey();
        } else if (val.equals(KeyKeys.KeyType_RSA)) {
            this.CheckRsaKey();
        } else {
            throw new CoseException("Unsupported key type");
        }
    }

    private void CheckECKey() throws CoseException {
        byte[] oid;
        boolean needPublic = false;
        CBORObject cn = this.get(KeyKeys.EC2_Curve);
        if (cn == KeyKeys.EC2_P256) {
            oid = ASN1.Oid_secp256r1;
        } else if (cn == KeyKeys.EC2_P384) {
            oid = ASN1.Oid_secp384r1;
        } else if (cn == KeyKeys.EC2_P521) {
            oid = ASN1.Oid_secp521r1;
        } else {
            throw new CoseException("Key has an unknown curve");
        }
        try {
            CBORObject val = this.get(KeyKeys.EC2_D);
            if (val != null) {
                if (val.getType() != CBORType.ByteString) {
                    throw new CoseException("Malformed key structure");
                }
                try {
                    byte[] privateBytes = ASN1.EncodeEcPrivateKey(oid, val.GetByteString(), null);
                    byte[] pkcs8 = ASN1.EncodePKCS8(ASN1.AlgorithmIdentifier(ASN1.oid_ecPublicKey, oid), privateBytes, null);
                    KeyFactory fact = KeyFactory.getInstance("EC");
                    PKCS8EncodedKeySpec keyspec = new PKCS8EncodedKeySpec(pkcs8);
                    this.privateKey = fact.generatePrivate(keyspec);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new CoseException("Unsupported Algorithm", e);
                }
                catch (InvalidKeySpecException e) {
                    throw new CoseException("Invalid Private Key", e);
                }
            }
            if ((val = this.get(KeyKeys.EC2_X)) == null) {
                if (this.privateKey == null) {
                    throw new CoseException("Malformed key structure");
                }
                needPublic = true;
            } else if (val.getType() != CBORType.ByteString) {
                throw new CoseException("Malformed key structure");
            }
            val = this.get(KeyKeys.EC2_Y);
            if (val == null) {
                if (this.privateKey == null) {
                    throw new CoseException("Malformed key structure");
                }
                needPublic = true;
            } else if (val.getType() != CBORType.ByteString && val.getType() != CBORType.Boolean) {
                throw new CoseException("Malformed key structure");
            }
            if (this.privateKey != null && needPublic) {
                byte[] pkcs8 = this.privateKey.getEncoded();
                return;
            }
            byte[] spki = null;
            if (spki == null) {
                byte[] rgbKey = null;
                byte[] X = this.get(KeyKeys.EC2_X).GetByteString();
                if (this.get(KeyKeys.EC2_Y).getType() == CBORType.Boolean) {
                    rgbKey = new byte[X.length + 1];
                    System.arraycopy(X, 0, rgbKey, 1, X.length);
                    rgbKey[0] = (byte)(2 + (this.get(KeyKeys.EC2_Y).AsBoolean() ? 1 : 0));
                } else {
                    rgbKey = new byte[X.length * 2 + 1];
                    System.arraycopy(X, 0, rgbKey, 1, X.length);
                    byte[] Y = this.get(KeyKeys.EC2_Y).GetByteString();
                    System.arraycopy(Y, 0, rgbKey, 1 + X.length, X.length);
                    rgbKey[0] = 4;
                }
                spki = ASN1.EncodeSubjectPublicKeyInfo(ASN1.AlgorithmIdentifier(ASN1.oid_ecPublicKey, oid), rgbKey);
            }
            KeyFactory fact = KeyFactory.getInstance("EC");
            X509EncodedKeySpec keyspec = new X509EncodedKeySpec(spki);
            this.publicKey = fact.generatePublic(keyspec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CoseException("Alorithm unsupported", e);
        }
        catch (InvalidKeySpecException e) {
            throw new CoseException("Internal error on SPKI", e);
        }
    }

    public ECGenParameterSpec GetCurve2() throws CoseException {
        if (this.get(KeyKeys.KeyType) != KeyKeys.KeyType_EC2) {
            throw new CoseException("Not an EC2 key");
        }
        CBORObject cnCurve = this.get(KeyKeys.EC2_Curve);
        if (cnCurve == KeyKeys.EC2_P256) {
            return new ECGenParameterSpec("secp256r1");
        }
        if (cnCurve == KeyKeys.EC2_P384) {
            return new ECGenParameterSpec("secp384r1");
        }
        if (cnCurve == KeyKeys.EC2_P521) {
            return new ECGenParameterSpec("secp521r1");
        }
        throw new CoseException("Unsupported curve " + cnCurve);
    }

    public static OneKey generateKey(AlgorithmID algorithm) throws CoseException {
        return OneKey.generateKey(algorithm, null);
    }

    public static OneKey generateKey(AlgorithmID algorithm, String parameters) throws CoseException {
        OneKey returnThis;
        switch (algorithm) {
            case ECDSA_256: {
                returnThis = OneKey.generateECDSAKey("P-256", KeyKeys.EC2_P256);
                break;
            }
            case ECDSA_384: {
                returnThis = OneKey.generateECDSAKey("P-384", KeyKeys.EC2_P384);
                break;
            }
            case ECDSA_512: {
                returnThis = OneKey.generateECDSAKey("P-521", KeyKeys.EC2_P521);
                break;
            }
            case EDDSA: {
                returnThis = OneKey.generateOkpKey("Ed25519", KeyKeys.OKP_Ed25519);
                break;
            }
            case RSA_PSS_256: 
            case RSA_PSS_384: 
            case RSA_PSS_512: {
                int keySize = 2048;
                if (parameters != null) {
                    try {
                        keySize = Integer.parseInt(parameters);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                returnThis = OneKey.generateRSAKey(keySize);
                break;
            }
            default: {
                throw new CoseException("Unknown algorithm");
            }
        }
        returnThis.add(KeyKeys.Algorithm, algorithm.AsCBOR());
        return returnThis;
    }

    public static OneKey generateKey(CBORObject curve) throws CoseException {
        switch (curve.AsInt32()) {
            case 1: {
                String curveName = "P-256";
                OneKey returnThis = OneKey.generateECDHKey(curveName, curve);
                return returnThis;
            }
            case 2: {
                String curveName = "P-384";
                OneKey returnThis = OneKey.generateECDHKey(curveName, curve);
                return returnThis;
            }
            case 3: {
                String curveName = "P-521";
                OneKey returnThis = OneKey.generateECDHKey(curveName, curve);
                return returnThis;
            }
            case 6: {
                String curveName = "Ed25519";
                return OneKey.generateOkpKey(curveName, curve);
            }
            case 7: {
                String curveName = "Ed448";
                return OneKey.generateOkpKey(curveName, curve);
            }
            case 4: {
                String curveName = "X25519";
                return OneKey.generateOkpKey(curveName, curve);
            }
            case 5: {
                String curveName = "X448";
                return OneKey.generateOkpKey(curveName, curve);
            }
        }
        throw new CoseException("Unknown curve");
    }

    private static OneKey generateECDHKey(String curveName, CBORObject curve) throws CoseException {
        try {
            int curveSize;
            switch (curveName) {
                case "P-256": {
                    curveName = "secp256r1";
                    curveSize = 256;
                    break;
                }
                case "P-384": {
                    curveName = "secp384r1";
                    curveSize = 384;
                    break;
                }
                case "P-521": {
                    curveName = "secp521r1";
                    curveSize = 521;
                    break;
                }
                default: {
                    throw new CoseException("Internal Error");
                }
            }
            ECGenParameterSpec paramSpec = new ECGenParameterSpec(curveName);
            KeyPairGenerator gen = KeyPairGenerator.getInstance("EC");
            gen.initialize(paramSpec);
            KeyPair keyPair = gen.genKeyPair();
            ECPoint pubPoint = ((ECPublicKey)keyPair.getPublic()).getW();
            byte[] rgbX = OneKey.ArrayFromBigNum(pubPoint.getAffineX(), curveSize);
            byte[] rgbY = OneKey.ArrayFromBigNum(pubPoint.getAffineY(), curveSize);
            byte[] rgbD = OneKey.ArrayFromBigNum(((ECPrivateKey)keyPair.getPrivate()).getS(), curveSize);
            OneKey key = new OneKey();
            key.add(KeyKeys.KeyType, KeyKeys.KeyType_EC2);
            key.add(KeyKeys.EC2_Curve, curve);
            key.add(KeyKeys.EC2_X, CBORObject.FromObject(rgbX));
            key.add(KeyKeys.EC2_Y, CBORObject.FromObject(rgbY));
            key.add(KeyKeys.EC2_D, CBORObject.FromObject(rgbD));
            key.publicKey = keyPair.getPublic();
            key.privateKey = keyPair.getPrivate();
            return key;
        }
        catch (NoSuchAlgorithmException e) {
            throw new CoseException("No provider for algorithm", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CoseException("THe curve is not supported", e);
        }
    }

    private static byte[] ArrayFromBigNum(BigInteger n, int curveSize) {
        byte[] rgb = new byte[(curveSize + 7) / 8];
        byte[] rgb2 = n.toByteArray();
        if (rgb.length == rgb2.length) {
            return rgb2;
        }
        if (rgb2.length > rgb.length) {
            System.arraycopy(rgb2, rgb2.length - rgb.length, rgb, 0, rgb.length);
        } else {
            System.arraycopy(rgb2, 0, rgb, rgb.length - rgb2.length, rgb2.length);
        }
        return rgb;
    }

    private static OneKey generateECDSAKey(String curveName, CBORObject curve) throws CoseException {
        try {
            int curveSize;
            switch (curveName) {
                case "P-256": {
                    curveName = "secp256r1";
                    curveSize = 256;
                    break;
                }
                case "P-384": {
                    curveName = "secp384r1";
                    curveSize = 384;
                    break;
                }
                case "P-521": {
                    curveName = "secp521r1";
                    curveSize = 521;
                    break;
                }
                default: {
                    throw new CoseException("Internal Error");
                }
            }
            ECGenParameterSpec paramSpec = new ECGenParameterSpec(curveName);
            KeyPairGenerator gen = KeyPairGenerator.getInstance("EC");
            gen.initialize(paramSpec);
            KeyPair keyPair = gen.genKeyPair();
            ECPoint pubPoint = ((ECPublicKey)keyPair.getPublic()).getW();
            byte[] rgbX = OneKey.ArrayFromBigNum(pubPoint.getAffineX(), curveSize);
            byte[] rgbY = OneKey.ArrayFromBigNum(pubPoint.getAffineY(), curveSize);
            byte[] rgbD = OneKey.ArrayFromBigNum(((ECPrivateKey)keyPair.getPrivate()).getS(), curveSize);
            OneKey key = new OneKey();
            key.add(KeyKeys.KeyType, KeyKeys.KeyType_EC2);
            key.add(KeyKeys.EC2_Curve, curve);
            key.add(KeyKeys.EC2_X, CBORObject.FromObject(rgbX));
            key.add(KeyKeys.EC2_Y, CBORObject.FromObject(rgbY));
            key.add(KeyKeys.EC2_D, CBORObject.FromObject(rgbD));
            key.publicKey = keyPair.getPublic();
            key.privateKey = keyPair.getPrivate();
            return key;
        }
        catch (NoSuchAlgorithmException e) {
            throw new CoseException("No provider for algorithm", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CoseException("The curve is not supported", e);
        }
    }

    public OneKey PublicKey() {
        OneKey newKey = new OneKey();
        CBORObject val = this.get(KeyKeys.KeyType);
        if (val.equals(KeyKeys.KeyType_Octet)) {
            return null;
        }
        if (val.equals(KeyKeys.KeyType_EC2)) {
            newKey.add(KeyKeys.EC2_Curve, this.get(KeyKeys.EC2_Curve));
            newKey.add(KeyKeys.EC2_X, this.get(KeyKeys.EC2_X));
            newKey.add(KeyKeys.EC2_Y, this.get(KeyKeys.EC2_Y));
        } else if (val.equals(KeyKeys.KeyType_OKP)) {
            newKey.add(KeyKeys.OKP_Curve, this.get(KeyKeys.OKP_Curve));
            newKey.add(KeyKeys.OKP_X, this.get(KeyKeys.OKP_X));
        } else if (val.equals(KeyKeys.KeyType_RSA)) {
            newKey.add(KeyKeys.RSA_N, this.get(KeyKeys.RSA_N));
            newKey.add(KeyKeys.RSA_E, this.get(KeyKeys.RSA_E));
        } else {
            return null;
        }
        newKey.publicKey = this.publicKey;
        for (CBORObject obj : this.keyMap.getKeys()) {
            val = this.keyMap.get(obj);
            if (obj.getType() == CBORType.Integer) {
                if (obj.AsInt32() <= 0) continue;
                newKey.add(obj, val);
                continue;
            }
            if (obj.getType() != CBORType.TextString) continue;
            newKey.add(obj, val);
        }
        return newKey;
    }

    public byte[] EncodeToBytes() {
        return this.keyMap.EncodeToBytes();
    }

    public CBORObject AsCBOR() {
        return this.keyMap;
    }

    public PublicKey AsPublicKey() throws CoseException {
        return this.publicKey;
    }

    public PrivateKey AsPrivateKey() throws CoseException {
        return this.privateKey;
    }

    public Object getUserData() {
        return this.UserData;
    }

    public void setUserData(Object newData) {
        this.UserData = newData;
    }

    private void CheckOkpKey() throws CoseException {
        String algName;
        byte[] oid;
        boolean needPublic = false;
        CBORObject cn = this.get(KeyKeys.OKP_Curve);
        if (cn == KeyKeys.OKP_Ed25519) {
            oid = ASN1.Oid_Ed25519;
            algName = "EdDSA";
        } else if (cn == KeyKeys.OKP_Ed448) {
            oid = ASN1.Oid_Ed448;
            algName = "EdDSA";
        } else if (cn == KeyKeys.OKP_X25519) {
            oid = ASN1.Oid_X25519;
            algName = "EdDH";
        } else if (cn == KeyKeys.OKP_X448) {
            oid = ASN1.Oid_X448;
            algName = "ECDH";
        } else {
            throw new CoseException("Key has an unknown curve");
        }
        try {
            CBORObject val = this.get(KeyKeys.OKP_D);
            if (val != null) {
                if (val.getType() != CBORType.ByteString) {
                    throw new CoseException("Malformed key structure");
                }
                try {
                    byte[] privateKeyBytes = ASN1.EncodeOctetString(val.GetByteString());
                    byte[] pkcs8 = ASN1.EncodePKCS8(ASN1.AlgorithmIdentifier(oid, null), privateKeyBytes, null);
                    KeyFactory fact = KeyFactory.getInstance(algName, "EdDSA");
                    PKCS8EncodedKeySpec keyspec = new PKCS8EncodedKeySpec(pkcs8);
                    this.privateKey = fact.generatePrivate(keyspec);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new CoseException("Unsupported Algorithm", e);
                }
                catch (InvalidKeySpecException e) {
                    throw new CoseException("Invalid Private Key", e);
                }
            }
            if ((val = this.get(KeyKeys.OKP_X)) == null) {
                if (this.privateKey == null) {
                    throw new CoseException("Malformed key structure");
                }
                needPublic = true;
            } else if (val.getType() != CBORType.ByteString) {
                throw new CoseException("Malformed key structure");
            }
            if (this.privateKey != null && needPublic) {
                byte[] pkcs8 = this.privateKey.getEncoded();
                return;
            }
            byte[] spki = null;
            if (spki == null) {
                byte[] rgbKey = this.get(KeyKeys.OKP_X).GetByteString();
                spki = ASN1.EncodeSubjectPublicKeyInfo(ASN1.AlgorithmIdentifier(oid, null), rgbKey);
            }
            KeyFactory fact = KeyFactory.getInstance("EdDSA", "EdDSA");
            X509EncodedKeySpec keyspec = new X509EncodedKeySpec(spki);
            this.publicKey = fact.generatePublic(keyspec);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new CoseException("Algorithm unsupported", e);
        }
        catch (InvalidKeySpecException e) {
            throw new CoseException("Internal error on SPKI", e);
        }
    }

    private static OneKey generateOkpKey(String curveName, CBORObject curve) throws CoseException {
        try {
            switch (curveName) {
                case "Ed25519": {
                    break;
                }
                case "Ed448": 
                case "X22519": 
                case "X448": {
                    throw new CoseException("Algorithm not supported.");
                }
                default: {
                    throw new CoseException("Internal Error");
                }
            }
            EdDSAGenParameterSpec paramSpec = new EdDSAGenParameterSpec(curveName);
            KeyPairGenerator gen = KeyPairGenerator.getInstance("EdDSA", "EdDSA");
            gen.initialize((AlgorithmParameterSpec)paramSpec);
            KeyPair keyPair = gen.genKeyPair();
            byte[] rgbX = ((EdDSAPublicKey)keyPair.getPublic()).getAbyte();
            byte[] rgbD = ((EdDSAPrivateKey)keyPair.getPrivate()).getSeed();
            OneKey key = new OneKey();
            key.add(KeyKeys.KeyType, KeyKeys.KeyType_OKP);
            key.add(KeyKeys.OKP_Curve, curve);
            key.add(KeyKeys.OKP_X, CBORObject.FromObject(rgbX));
            key.add(KeyKeys.OKP_D, CBORObject.FromObject(rgbD));
            key.publicKey = keyPair.getPublic();
            key.privateKey = keyPair.getPrivate();
            return key;
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new CoseException("No provider for algorithm", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CoseException("The curve is not supported", e);
        }
    }

    private void CheckRsaKey() throws CoseException {
        KeyFactory factory;
        CBORObject n = this.get(KeyKeys.RSA_N);
        CBORObject e = this.get(KeyKeys.RSA_E);
        CBORObject d = this.get(KeyKeys.RSA_D);
        CBORObject p = this.get(KeyKeys.RSA_P);
        CBORObject q = this.get(KeyKeys.RSA_Q);
        CBORObject dP = this.get(KeyKeys.RSA_DP);
        CBORObject dQ = this.get(KeyKeys.RSA_DQ);
        CBORObject qInv = this.get(KeyKeys.RSA_QI);
        CBORObject other = this.get(KeyKeys.RSA_OTHER);
        if (n != null && e != null) {
            if (n.getType() != CBORType.ByteString || e.getType() != CBORType.ByteString) {
                throw new CoseException("Malformed key structure");
            }
            RSAPublicKeySpec spec = new RSAPublicKeySpec(new BigInteger(1, n.GetByteString()), new BigInteger(1, e.GetByteString()));
            try {
                factory = KeyFactory.getInstance("RSA");
                this.publicKey = factory.generatePublic(spec);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new CoseException("No provider for algorithm", ex);
            }
            catch (InvalidKeySpecException ex) {
                throw new CoseException("Invalid Public Key", ex);
            }
        }
        if (n != null && e != null && d != null && p != null && q != null && dP != null && dQ != null && qInv != null) {
            RSAPrivateKeySpec privateKeySpec;
            if (n.getType() != CBORType.ByteString || e.getType() != CBORType.ByteString || d.getType() != CBORType.ByteString || p.getType() != CBORType.ByteString || q.getType() != CBORType.ByteString || dP.getType() != CBORType.ByteString || dQ.getType() != CBORType.ByteString || qInv.getType() != CBORType.ByteString) {
                throw new CoseException("Malformed key structure");
            }
            if (other == null) {
                privateKeySpec = new RSAPrivateCrtKeySpec(new BigInteger(1, n.GetByteString()), new BigInteger(1, e.GetByteString()), new BigInteger(1, d.GetByteString()), new BigInteger(1, p.GetByteString()), new BigInteger(1, q.GetByteString()), new BigInteger(1, dP.GetByteString()), new BigInteger(1, dQ.GetByteString()), new BigInteger(1, qInv.GetByteString()));
            } else {
                if (other.getType() != CBORType.Array) {
                    throw new CoseException("Malformed key structure");
                }
                RSAOtherPrimeInfo[] others = new RSAOtherPrimeInfo[other.size()];
                for (int i = 0; i < other.size(); ++i) {
                    CBORObject object = other.get(i);
                    if (object.getType() != CBORType.Map) {
                        throw new CoseException("Malformed key structure");
                    }
                    CBORObject ri = object.get(KeyKeys.RSA__R_I.AsCBOR());
                    CBORObject di = object.get(KeyKeys.RSA__D_I.AsCBOR());
                    CBORObject ti = object.get(KeyKeys.RSA__T_I.AsCBOR());
                    if (ri == null || di == null || ti == null) {
                        throw new CoseException("Malformed key structure");
                    }
                    if (ri.getType() != CBORType.ByteString || di.getType() != CBORType.ByteString || ti.getType() != CBORType.ByteString) {
                        throw new CoseException("Malformed key structure");
                    }
                    others[i] = new RSAOtherPrimeInfo(new BigInteger(1, ri.GetByteString()), new BigInteger(1, di.GetByteString()), new BigInteger(1, ti.GetByteString()));
                }
                privateKeySpec = new RSAMultiPrimePrivateCrtKeySpec(new BigInteger(1, n.GetByteString()), new BigInteger(1, e.GetByteString()), new BigInteger(1, d.GetByteString()), new BigInteger(1, p.GetByteString()), new BigInteger(1, q.GetByteString()), new BigInteger(1, dP.GetByteString()), new BigInteger(1, dQ.GetByteString()), new BigInteger(1, qInv.GetByteString()), others);
            }
            try {
                factory = KeyFactory.getInstance("RSA");
                this.privateKey = factory.generatePrivate(privateKeySpec);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new CoseException("No provider for algorithm", ex);
            }
            catch (InvalidKeySpecException ex) {
                throw new CoseException("Invalid Private Key", ex);
            }
        }
    }

    private static OneKey generateRSAKey(int keySize) throws CoseException {
        try {
            KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA");
            gen.initialize(keySize);
            KeyPair keyPair = gen.genKeyPair();
            RSAPrivateCrtKey priv = (RSAPrivateCrtKey)keyPair.getPrivate();
            OneKey key = new OneKey();
            key.add(KeyKeys.KeyType, KeyKeys.KeyType_RSA);
            key.add(KeyKeys.RSA_N, CBORObject.FromObject(priv.getModulus().toByteArray()));
            key.add(KeyKeys.RSA_E, CBORObject.FromObject(priv.getPublicExponent().toByteArray()));
            key.add(KeyKeys.RSA_D, CBORObject.FromObject(priv.getPrivateExponent().toByteArray()));
            key.add(KeyKeys.RSA_P, CBORObject.FromObject(priv.getPrimeP().toByteArray()));
            key.add(KeyKeys.RSA_Q, CBORObject.FromObject(priv.getPrimeQ().toByteArray()));
            key.add(KeyKeys.RSA_DP, CBORObject.FromObject(priv.getPrimeExponentP().toByteArray()));
            key.add(KeyKeys.RSA_DQ, CBORObject.FromObject(priv.getPrimeExponentQ().toByteArray()));
            key.add(KeyKeys.RSA_QI, CBORObject.FromObject(priv.getCrtCoefficient().toByteArray()));
            key.publicKey = keyPair.getPublic();
            key.privateKey = keyPair.getPrivate();
            return key;
        }
        catch (NoSuchAlgorithmException e) {
            throw new CoseException("No provider for algorithm", e);
        }
    }
}

