/*
 * Decompiled with CFR 0.152.
 */
package COSE;

import COSE.CoseException;
import COSE.MessageTag;
import COSE.OneKey;
import COSE.SignCommon;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;

public class Sign1Message
extends SignCommon {
    byte[] rgbSignature;

    public Sign1Message() {
        this(true, true);
    }

    public Sign1Message(boolean emitTag) {
        this(emitTag, true);
    }

    public Sign1Message(boolean emitTag, boolean emitContent) {
        this.emitTag = emitTag;
        this.contextString = "Signature1";
        this.emitContent = emitContent;
        this.messageTag = MessageTag.Sign1;
    }

    public void sign(OneKey key) throws CoseException {
        if (this.rgbContent == null) {
            throw new CoseException("No Content Specified");
        }
        if (this.rgbSignature != null) {
            return;
        }
        if (this.rgbProtected == null) {
            this.rgbProtected = this.objProtected.size() > 0 ? this.objProtected.EncodeToBytes() : new byte[0];
        }
        CBORObject obj = CBORObject.NewArray();
        obj.Add(this.contextString);
        obj.Add(this.rgbProtected);
        obj.Add(this.externalData);
        obj.Add(this.rgbContent);
        this.rgbSignature = this.computeSignature(obj.EncodeToBytes(), key);
        this.ProcessCounterSignatures();
    }

    public boolean validate(OneKey cnKey) throws CoseException {
        CBORObject obj = CBORObject.NewArray();
        obj.Add(this.contextString);
        if (this.objProtected.size() > 0) {
            obj.Add(this.rgbProtected);
        } else {
            obj.Add(CBORObject.FromObject(new byte[0]));
        }
        obj.Add(this.externalData);
        obj.Add(this.rgbContent);
        return this.validateSignature(obj.EncodeToBytes(), this.rgbSignature, cnKey);
    }

    @Override
    protected void DecodeFromCBORObject(CBORObject messageObject) throws CoseException {
        if (messageObject.size() != 4) {
            throw new CoseException("Invalid Sign1 structure");
        }
        if (messageObject.get(0).getType() == CBORType.ByteString) {
            this.rgbProtected = messageObject.get(0).GetByteString();
            if (messageObject.get(0).GetByteString().length == 0) {
                this.objProtected = CBORObject.NewMap();
            } else {
                this.objProtected = CBORObject.DecodeFromBytes(this.rgbProtected);
                if (this.objProtected.size() == 0) {
                    this.rgbProtected = new byte[0];
                }
            }
        } else {
            throw new CoseException("Invalid Sign1 structure");
        }
        if (messageObject.get(1).getType() != CBORType.Map) {
            throw new CoseException("Invalid Sign1 structure");
        }
        this.objUnprotected = messageObject.get(1);
        if (messageObject.get(2).getType() == CBORType.ByteString) {
            this.rgbContent = messageObject.get(2).GetByteString();
        } else if (!messageObject.get(2).isNull()) {
            throw new CoseException("Invalid Sign1 structure");
        }
        if (messageObject.get(3).getType() != CBORType.ByteString) {
            throw new CoseException("Invalid Sign1 structure");
        }
        this.rgbSignature = messageObject.get(3).GetByteString();
    }

    @Override
    protected CBORObject EncodeCBORObject() throws CoseException {
        if (this.rgbSignature == null) {
            throw new CoseException("sign function not called");
        }
        if (this.rgbProtected == null) {
            throw new CoseException("Internal Error");
        }
        CBORObject obj = CBORObject.NewArray();
        obj.Add(this.rgbProtected);
        obj.Add(this.objUnprotected);
        if (this.emitContent) {
            obj.Add(this.rgbContent);
        } else {
            obj.Add(null);
        }
        obj.Add(this.rgbSignature);
        return obj;
    }
}

