/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.fido.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.yubico.internal.util.ExceptionUtil;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.exception.HexException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public final class AAGUID {
    private static final Pattern AAGUID_PATTERN = Pattern.compile("^([0-9a-fA-F]{8})-?([0-9a-fA-F]{4})-?([0-9a-fA-F]{4})-?([0-9a-fA-F]{4})-?([0-9a-fA-F]{12})$");
    private static final ByteArray ZERO = new ByteArray(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    private final ByteArray value;

    public AAGUID(ByteArray value) {
        ExceptionUtil.assertTrue(value.size() == 16, "AAGUID as bytes must be exactly 16 bytes long, was %d: %s", value.size(), value);
        this.value = value;
    }

    public ByteArray asBytes() {
        return this.value;
    }

    public String asHexString() {
        return this.value.getHex();
    }

    @JsonValue
    public String asGuidString() {
        String hex = this.value.getHex();
        return String.format("%s-%s-%s-%s-%s", hex.substring(0, 8), hex.substring(8, 12), hex.substring(12, 16), hex.substring(16, 20), hex.substring(20, 32));
    }

    public boolean isZero() {
        return ZERO.equals(this.value);
    }

    private static ByteArray parse(String value) {
        Matcher matcher = AAGUID_PATTERN.matcher(value);
        if (matcher.find()) {
            try {
                return ByteArray.fromHex(matcher.group(1)).concat(ByteArray.fromHex(matcher.group(2))).concat(ByteArray.fromHex(matcher.group(3))).concat(ByteArray.fromHex(matcher.group(4))).concat(ByteArray.fromHex(matcher.group(5)));
            }
            catch (HexException e) {
                throw new RuntimeException("This exception should be impossible, please file a bug report.", e);
            }
        }
        throw new IllegalArgumentException("Value does not match AAGUID pattern: " + value);
    }

    @JsonCreator
    private static AAGUID fromString(String aaguid) {
        return new AAGUID(AAGUID.parse(aaguid));
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AAGUID)) {
            return false;
        }
        AAGUID other = (AAGUID)o;
        ByteArray this$value = this.value;
        ByteArray other$value = other.value;
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ByteArray $value = this.value;
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AAGUID(" + this.asGuidString() + ")";
    }
}

