/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.fido.metadata;

import com.yubico.fido.metadata.AAGUID;
import com.yubico.fido.metadata.AuthenticatorStatus;
import com.yubico.fido.metadata.FidoMetadataDownloaderException;
import com.yubico.fido.metadata.MetadataBLOB;
import com.yubico.fido.metadata.MetadataBLOBPayload;
import com.yubico.fido.metadata.MetadataBLOBPayloadEntry;
import com.yubico.fido.metadata.MetadataStatement;
import com.yubico.fido.metadata.UnexpectedLegalHeader;
import com.yubico.internal.util.CertificateParser;
import com.yubico.internal.util.OptionalUtil;
import com.yubico.webauthn.RegistrationResult;
import com.yubico.webauthn.attestation.AttestationTrustSource;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.exception.Base64UrlException;
import java.io.IOException;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FidoMetadataService
implements AttestationTrustSource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FidoMetadataService.class);
    private final HashMap<String, HashSet<MetadataBLOBPayloadEntry>> prefilteredEntriesByCertificateKeyIdentifier;
    private final HashMap<AAGUID, HashSet<MetadataBLOBPayloadEntry>> prefilteredEntriesByAaguid;
    private final HashSet<MetadataBLOBPayloadEntry> prefilteredUnindexedEntries;
    private final Predicate<Filters.AuthenticatorToBeFiltered> filter;
    private final CertStore certStore;

    private FidoMetadataService(@NonNull MetadataBLOBPayload blob, @NonNull Predicate<MetadataBLOBPayloadEntry> prefilter, @NonNull Predicate<Filters.AuthenticatorToBeFiltered> filter, CertStore certStore) {
        if (blob == null) {
            throw new NullPointerException("blob is marked non-null but is null");
        }
        if (prefilter == null) {
            throw new NullPointerException("prefilter is marked non-null but is null");
        }
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        List<MetadataBLOBPayloadEntry> prefilteredEntries = blob.getEntries().stream().filter(FidoMetadataService::ignoreInvalidUpdateAvailableAuthenticatorVersion).filter(prefilter).collect(Collectors.toList());
        this.prefilteredEntriesByCertificateKeyIdentifier = FidoMetadataService.buildCkiMap(prefilteredEntries);
        this.prefilteredEntriesByAaguid = FidoMetadataService.buildAaguidMap(prefilteredEntries);
        this.prefilteredUnindexedEntries = new HashSet<MetadataBLOBPayloadEntry>(prefilteredEntries);
        for (HashSet<MetadataBLOBPayloadEntry> byAaguid : this.prefilteredEntriesByAaguid.values()) {
            this.prefilteredUnindexedEntries.removeAll(byAaguid);
        }
        for (HashSet<MetadataBLOBPayloadEntry> byCski : this.prefilteredEntriesByCertificateKeyIdentifier.values()) {
            this.prefilteredUnindexedEntries.removeAll(byCski);
        }
        this.filter = filter;
        this.certStore = certStore;
    }

    private static boolean ignoreInvalidUpdateAvailableAuthenticatorVersion(MetadataBLOBPayloadEntry metadataBLOBPayloadEntry) {
        return metadataBLOBPayloadEntry.getMetadataStatement().map(MetadataStatement::getAuthenticatorVersion).map(authenticatorVersion -> metadataBLOBPayloadEntry.getStatusReports().stream().filter(statusReport -> AuthenticatorStatus.UPDATE_AVAILABLE.equals((Object)statusReport.getStatus())).noneMatch(statusReport -> statusReport.getAuthenticatorVersion().map(av -> av > authenticatorVersion).orElse(false))).orElse(true);
    }

    private static HashMap<String, HashSet<MetadataBLOBPayloadEntry>> buildCkiMap(@NonNull List<MetadataBLOBPayloadEntry> entries) {
        if (entries == null) {
            throw new NullPointerException("entries is marked non-null but is null");
        }
        return entries.stream().collect(HashMap::new, (result, metadataBLOBPayloadEntry) -> {
            for (String acki : metadataBLOBPayloadEntry.getAttestationCertificateKeyIdentifiers()) {
                result.computeIfAbsent(acki, o -> new HashSet()).add(metadataBLOBPayloadEntry);
            }
            for (String acki : metadataBLOBPayloadEntry.getMetadataStatement().map(MetadataStatement::getAttestationCertificateKeyIdentifiers).orElseGet(Collections::emptySet)) {
                result.computeIfAbsent(acki, o -> new HashSet()).add(metadataBLOBPayloadEntry);
            }
        }, (mapA, mapB) -> {
            for (Map.Entry e : mapB.entrySet()) {
                mapA.merge((String)e.getKey(), (HashSet)e.getValue(), (entriesA, entriesB) -> {
                    entriesA.addAll(entriesB);
                    return entriesA;
                });
            }
        });
    }

    private static HashMap<AAGUID, HashSet<MetadataBLOBPayloadEntry>> buildAaguidMap(@NonNull List<MetadataBLOBPayloadEntry> entries) {
        if (entries == null) {
            throw new NullPointerException("entries is marked non-null but is null");
        }
        return entries.stream().collect(HashMap::new, (result, metadataBLOBPayloadEntry) -> {
            Consumer<AAGUID> appendToAaguidEntry = aaguid -> result.computeIfAbsent(aaguid, o -> new HashSet()).add(metadataBLOBPayloadEntry);
            metadataBLOBPayloadEntry.getAaguid().filter(aaguid -> !aaguid.isZero()).ifPresent(appendToAaguidEntry);
            metadataBLOBPayloadEntry.getMetadataStatement().flatMap(MetadataStatement::getAaguid).filter(aaguid -> !aaguid.isZero()).ifPresent(appendToAaguidEntry);
        }, (mapA, mapB) -> {
            for (Map.Entry e : mapB.entrySet()) {
                mapA.merge((AAGUID)e.getKey(), (HashSet)e.getValue(), (entriesA, entriesB) -> {
                    entriesA.addAll(entriesB);
                    return entriesA;
                });
            }
        });
    }

    public static FidoMetadataServiceBuilder.Step1 builder() {
        return new FidoMetadataServiceBuilder.Step1();
    }

    public Set<MetadataBLOBPayloadEntry> findEntries(@NonNull List<X509Certificate> attestationCertificateChain, @NonNull Optional<AAGUID> aaguid) {
        if (attestationCertificateChain == null) {
            throw new NullPointerException("attestationCertificateChain is marked non-null but is null");
        }
        if (aaguid == null) {
            throw new NullPointerException("aaguid is marked non-null but is null");
        }
        Set certSubjectKeyIdentifiers = attestationCertificateChain.stream().map(cert -> {
            try {
                return new ByteArray(CertificateParser.computeSubjectKeyIdentifier(cert)).getHex();
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("SHA-1 hash algorithm is not available in JCA context.", e);
            }
        }).collect(Collectors.toSet());
        Optional<AAGUID> nonzeroAaguid = OptionalUtil.orElseOptional(aaguid.filter(a -> !a.isZero()), () -> {
            log.debug("findEntries: attempting to look up AAGUID from certificate");
            if (attestationCertificateChain.isEmpty()) {
                return Optional.empty();
            }
            return CertificateParser.parseFidoAaguidExtension((X509Certificate)attestationCertificateChain.get(0)).map(ByteArray::new).map(AAGUID::new);
        });
        log.debug("findEntries(certSubjectKeyIdentifiers = {}, aaguid = {}, nonzeroAaguid= {})", new Object[]{certSubjectKeyIdentifiers, aaguid, nonzeroAaguid});
        Set<MetadataBLOBPayloadEntry> result = Stream.concat(nonzeroAaguid.map(this.prefilteredEntriesByAaguid::get).map(Collection::stream).orElseGet(Stream::empty), certSubjectKeyIdentifiers.stream().flatMap(cski -> Optional.ofNullable(this.prefilteredEntriesByCertificateKeyIdentifier.get(cski)).map(Collection::stream).orElseGet(Stream::empty))).filter(metadataBLOBPayloadEntry -> this.filter.test(new Filters.AuthenticatorToBeFiltered(attestationCertificateChain, (MetadataBLOBPayloadEntry)metadataBLOBPayloadEntry, nonzeroAaguid.orElse(null)))).collect(Collectors.toSet());
        log.debug("findEntries(certSubjectKeyIdentifiers = {}, aaguid = {}) => {} matches", new Object[]{certSubjectKeyIdentifiers, aaguid, result.size()});
        return result;
    }

    public Set<MetadataBLOBPayloadEntry> findEntries(@NonNull List<X509Certificate> attestationCertificateChain) {
        if (attestationCertificateChain == null) {
            throw new NullPointerException("attestationCertificateChain is marked non-null but is null");
        }
        return this.findEntries(attestationCertificateChain, Optional.empty());
    }

    public Set<MetadataBLOBPayloadEntry> findEntries(@NonNull List<X509Certificate> attestationCertificateChain, @NonNull AAGUID aaguid) {
        if (attestationCertificateChain == null) {
            throw new NullPointerException("attestationCertificateChain is marked non-null but is null");
        }
        if (aaguid == null) {
            throw new NullPointerException("aaguid is marked non-null but is null");
        }
        return this.findEntries(attestationCertificateChain, Optional.of(aaguid));
    }

    public Set<MetadataBLOBPayloadEntry> findEntries(@NonNull RegistrationResult registrationResult) {
        if (registrationResult == null) {
            throw new NullPointerException("registrationResult is marked non-null but is null");
        }
        return registrationResult.getAttestationTrustPath().map(atp -> this.findEntries((List<X509Certificate>)atp, new AAGUID(registrationResult.getAaguid()))).orElseGet(Collections::emptySet);
    }

    public Set<MetadataBLOBPayloadEntry> findEntries(@NonNull AAGUID aaguid) {
        if (aaguid == null) {
            throw new NullPointerException("aaguid is marked non-null but is null");
        }
        return this.findEntries(Collections.emptyList(), aaguid);
    }

    public Set<MetadataBLOBPayloadEntry> findEntries(@NonNull Predicate<MetadataBLOBPayloadEntry> filter) {
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        return Stream.concat(Stream.concat(this.prefilteredEntriesByAaguid.values().stream().flatMap(Collection::stream), this.prefilteredEntriesByCertificateKeyIdentifier.values().stream().flatMap(Collection::stream)), this.prefilteredUnindexedEntries.stream()).filter(filter).collect(Collectors.toSet());
    }

    @Override
    public AttestationTrustSource.TrustRootsResult findTrustRoots(List<X509Certificate> attestationCertificateChain, Optional<ByteArray> aaguid) {
        return AttestationTrustSource.TrustRootsResult.builder().trustRoots(this.findEntries(attestationCertificateChain, aaguid.map(AAGUID::new)).stream().map(MetadataBLOBPayloadEntry::getMetadataStatement).flatMap(OptionalUtil::stream).flatMap(metadataStatement -> metadataStatement.getAttestationRootCertificates().stream()).collect(Collectors.toSet())).certStore(this.certStore).enableRevocationChecking(false).policyTreeValidator(policyNode -> true).build();
    }

    public static class FidoMetadataServiceBuilder {
        @NonNull
        private final MetadataBLOBPayload blob;
        private Predicate<MetadataBLOBPayloadEntry> prefilter = Filters.notRevoked();
        private Predicate<Filters.AuthenticatorToBeFiltered> filter = Filters.noAttestationKeyCompromise();
        private CertStore certStore = null;

        public FidoMetadataServiceBuilder prefilter(@NonNull Predicate<MetadataBLOBPayloadEntry> prefilter) {
            if (prefilter == null) {
                throw new NullPointerException("prefilter is marked non-null but is null");
            }
            this.prefilter = prefilter;
            return this;
        }

        public FidoMetadataServiceBuilder filter(@NonNull Predicate<Filters.AuthenticatorToBeFiltered> filter) {
            if (filter == null) {
                throw new NullPointerException("filter is marked non-null but is null");
            }
            this.filter = filter;
            return this;
        }

        public FidoMetadataServiceBuilder certStore(@NonNull CertStore certStore) {
            if (certStore == null) {
                throw new NullPointerException("certStore is marked non-null but is null");
            }
            this.certStore = certStore;
            return this;
        }

        public FidoMetadataService build() throws CertPathValidatorException, InvalidAlgorithmParameterException, Base64UrlException, DigestException, FidoMetadataDownloaderException, CertificateException, UnexpectedLegalHeader, IOException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
            return new FidoMetadataService(this.blob, this.prefilter, this.filter, this.certStore);
        }

        @Generated
        private FidoMetadataServiceBuilder(@NonNull MetadataBLOBPayload blob) {
            if (blob == null) {
                throw new NullPointerException("blob is marked non-null but is null");
            }
            this.blob = blob;
        }

        public static class Step1 {
            public FidoMetadataServiceBuilder useBlob(@NonNull MetadataBLOB blob) {
                if (blob == null) {
                    throw new NullPointerException("blob is marked non-null but is null");
                }
                return this.useBlob(blob.getPayload());
            }

            public FidoMetadataServiceBuilder useBlob(@NonNull MetadataBLOBPayload blobPayload) {
                if (blobPayload == null) {
                    throw new NullPointerException("blobPayload is marked non-null but is null");
                }
                return new FidoMetadataServiceBuilder(blobPayload);
            }
        }
    }

    public static class Filters {
        @SafeVarargs
        public static <T> Predicate<T> allOf(Predicate<T> ... filters) {
            return entry -> Stream.of(filters).allMatch(filter -> filter.test(entry));
        }

        public static Predicate<MetadataBLOBPayloadEntry> notRevoked() {
            return entry -> entry.getStatusReports().stream().noneMatch(statusReport -> AuthenticatorStatus.REVOKED.equals((Object)statusReport.getStatus()));
        }

        public static Predicate<AuthenticatorToBeFiltered> noAttestationKeyCompromise() {
            return params -> params.getMetadataEntry().getStatusReports().stream().filter(statusReport -> AuthenticatorStatus.ATTESTATION_KEY_COMPROMISE.equals((Object)statusReport.getStatus())).noneMatch(statusReport -> !statusReport.getCertificate().isPresent() || params.getAttestationCertificateChain().stream().anyMatch(cert -> Arrays.equals(statusReport.getCertificate().get().getPublicKey().getEncoded(), cert.getPublicKey().getEncoded())));
        }

        public static final class AuthenticatorToBeFiltered {
            @NonNull
            private final List<X509Certificate> attestationCertificateChain;
            @NonNull
            private final MetadataBLOBPayloadEntry metadataEntry;
            private final AAGUID aaguid;

            public Optional<AAGUID> getAaguid() {
                return Optional.ofNullable(this.aaguid);
            }

            @NonNull
            @Generated
            public List<X509Certificate> getAttestationCertificateChain() {
                return this.attestationCertificateChain;
            }

            @NonNull
            @Generated
            public MetadataBLOBPayloadEntry getMetadataEntry() {
                return this.metadataEntry;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AuthenticatorToBeFiltered)) {
                    return false;
                }
                AuthenticatorToBeFiltered other = (AuthenticatorToBeFiltered)o;
                List<X509Certificate> this$attestationCertificateChain = this.getAttestationCertificateChain();
                List<X509Certificate> other$attestationCertificateChain = other.getAttestationCertificateChain();
                if (this$attestationCertificateChain == null ? other$attestationCertificateChain != null : !((Object)this$attestationCertificateChain).equals(other$attestationCertificateChain)) {
                    return false;
                }
                MetadataBLOBPayloadEntry this$metadataEntry = this.getMetadataEntry();
                MetadataBLOBPayloadEntry other$metadataEntry = other.getMetadataEntry();
                if (this$metadataEntry == null ? other$metadataEntry != null : !((Object)this$metadataEntry).equals(other$metadataEntry)) {
                    return false;
                }
                Optional<AAGUID> this$aaguid = this.getAaguid();
                Optional<AAGUID> other$aaguid = other.getAaguid();
                return !(this$aaguid == null ? other$aaguid != null : !((Object)this$aaguid).equals(other$aaguid));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<X509Certificate> $attestationCertificateChain = this.getAttestationCertificateChain();
                result = result * 59 + ($attestationCertificateChain == null ? 43 : ((Object)$attestationCertificateChain).hashCode());
                MetadataBLOBPayloadEntry $metadataEntry = this.getMetadataEntry();
                result = result * 59 + ($metadataEntry == null ? 43 : ((Object)$metadataEntry).hashCode());
                Optional<AAGUID> $aaguid = this.getAaguid();
                result = result * 59 + ($aaguid == null ? 43 : ((Object)$aaguid).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "FidoMetadataService.Filters.AuthenticatorToBeFiltered(attestationCertificateChain=" + this.getAttestationCertificateChain() + ", metadataEntry=" + this.getMetadataEntry() + ", aaguid=" + this.getAaguid() + ")";
            }

            @Generated
            private AuthenticatorToBeFiltered(@NonNull List<X509Certificate> attestationCertificateChain, @NonNull MetadataBLOBPayloadEntry metadataEntry, AAGUID aaguid) {
                if (attestationCertificateChain == null) {
                    throw new NullPointerException("attestationCertificateChain is marked non-null but is null");
                }
                if (metadataEntry == null) {
                    throw new NullPointerException("metadataEntry is marked non-null but is null");
                }
                this.attestationCertificateChain = attestationCertificateChain;
                this.metadataEntry = metadataEntry;
                this.aaguid = aaguid;
            }
        }
    }
}

