/*
 * Decompiled with CFR 0.152.
 */
package COSE;

import COSE.CoseException;
import COSE.Message;
import COSE.Signer;
import com.upokecenter.cbor.CBORObject;

public class CounterSign
extends Signer {
    private Message m_msgToSign;
    private Signer m_signerToSign;

    public CounterSign() {
        this.contextString = "CounterSignature";
    }

    public CounterSign(byte[] rgb) throws CoseException {
        this.contextString = "CounterSignature";
        this.DecodeFromBytes(rgb);
    }

    public CounterSign(CBORObject cbor) throws CoseException {
        this.DecodeFromCBORObject(cbor);
        this.contextString = "CounterSignature";
    }

    public void DecodeFromBytes(byte[] rgb) throws CoseException {
        CBORObject obj = CBORObject.DecodeFromBytes(rgb);
        this.DecodeFromCBORObject(obj);
    }

    public byte[] EncodeToBytes() throws CoseException {
        return this.EncodeToCBORObject().EncodeToBytes();
    }

    public void Sign(Message message) throws CoseException {
        byte[] rgbBodyProtect = message.objProtected.size() > 0 ? message.objProtected.EncodeToBytes() : new byte[]{};
        this.sign(rgbBodyProtect, message.rgbContent);
    }

    public boolean Validate(Message message) throws CoseException {
        byte[] rgbBodyProtect = message.objProtected.size() > 0 ? message.objProtected.EncodeToBytes() : new byte[]{};
        return this.validate(rgbBodyProtect, message.rgbContent);
    }

    public void setObject(Message msg) {
        this.m_msgToSign = msg;
    }

    public void setObject(Signer signer) {
        this.m_signerToSign = signer;
    }
}

